SUBROUTINE rotatf_loc(klevel, x, y, rot )
  !
  ! Auteur : P.Le Van
  !**************************************************************
  !.  calcule le rotationnel
  ! a tous les niveaux d'1 vecteur de comp. x et y ..
  !   x  et  y etant des composantes  covariantes  ...
  !********************************************************************
  !   klevel, x  et y   sont des arguments d'entree pour le s-prog
  !        rot          est  un argument  de sortie pour le s-prog
  !
  USE parallel_lmdz
  USE lmdz_filtreg_p
  IMPLICIT NONE
  !
  INCLUDE "dimensions.h"
  INCLUDE "paramet.h"
  INCLUDE "comgeom.h"
  !
  !   .....  variables en arguments  ......
  !
  INTEGER :: klevel
  REAL :: rot( ijb_v:ije_v,klevel )
  REAL :: x( ijb_u:ije_u,klevel ), y( ijb_v:ije_v,klevel )
  !
  !  ...   variables  locales  ...
  !
  INTEGER :: l, ij
  INTEGER :: ijb,ije,jjb,jje
  !
  !
  ijb=ij_begin
  ije=ij_end
  IF(pole_sud) ije=ij_end-iip1

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO  l = 1,klevel
  !
    DO   ij = ijb, ije - 1
     rot( ij,l )  =    y( ij+1 , l )  -  y( ij,l )   + &
           x(ij +iip1, l )  -  x( ij,l )
    ENDDO
  !
  !    .... correction pour rot( iip1,j,l)  ....
  !    ....   rot(iip1,j,l)= rot(1,j,l) ...
  !DIR$ IVDEP
    DO  ij = ijb+iip1-1, ije, iip1
     rot( ij,l ) = rot( ij -iim,l )
    ENDDO
  !
  END DO
!$OMP END DO NOWAIT
    jjb=jj_begin
    jje=jj_end
    if (pole_sud) jje=jj_end-1
    CALL filtreg_p( rot, jjb_v, jje_v,jjb,jje,jjm, &
          klevel, 2, 2, .FALSE., 1 )

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
    DO l = 1, klevel
      DO ij = ijb, ije
       rot(ij,l) = rot(ij,l) * unsairez(ij)
      ENDDO
    ENDDO
!$OMP END DO NOWAIT
  !
  !

END SUBROUTINE rotatf_loc
