SUBROUTINE laplacien_rotgam_loc( klevel, rotin, rotout )
  !
  ! P. Le Van
  !
  !   ************************************************************
  !   ... calcul de  (rotat x nxgrad)_gam  du rotationnel rotin ..
  !   ************************************************************
  ! klevel et teta  sont des arguments  d'entree pour le s-prog
  !  divgra     est  un argument  de sortie pour le s-prog
  !
  USE parallel_lmdz
  IMPLICIT NONE
  !
  INCLUDE "dimensions.h"
  INCLUDE "paramet.h"
  INCLUDE "comgeom.h"

  !
  !    .............   variables  en  arguments    ...........
  !
  INTEGER :: klevel
  REAL :: rotin( ijb_v:ije_v,klevel ), rotout( ijb_v:ije_v,klevel )
  !
  !   ............     variables   locales     ...............
  !
  INTEGER :: l, ij
  REAL :: ghy(ijb_v:ije_v,llm), ghx(ijb_u:ije_u,llm)
  !   ........................................................
  !
  INTEGER :: ijb,ije

  !

  CALL   nxgrad_gam_loc ( klevel, rotin,   ghx ,   ghy  )
  CALL   rotat_nfil_loc ( klevel, ghx  ,   ghy , rotout )
  !
  ijb=ij_begin
  ije=ij_end
  IF(pole_sud) ije=ij_end-iip1
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1, klevel
    DO ij = ijb, ije
     rotout(ij,l) = rotout(ij,l) * unsairz_gam(ij)
    ENDDO
  ENDDO
!$OMP END DO NOWAIT

END SUBROUTINE laplacien_rotgam_loc
