
! $Header$

SUBROUTINE gr_v_scal_loc(nx,x_v,x_scal)
  !%W%    %G%
  !=======================================================================
  !
  !   Author:    Frederic Hourdin      original: 11/11/92
  !   -------
  !
  !   Subject:
  !   ------
  !
  !   Method:
  !   --------
  !
  !   Interface:
  !   ----------
  !
  !  Input:
  !  ------
  !
  !  Output:
  !  -------
  !
  !=======================================================================
  USE parallel_lmdz
  IMPLICIT NONE
  !-----------------------------------------------------------------------
  !   Declararations:
  !   ---------------

  INCLUDE "dimensions.h"
  INCLUDE "paramet.h"
  INCLUDE "comgeom.h"

  !   Arguments:
  !   ----------

  INTEGER :: nx
  REAL :: x_v(ijb_v:ije_v,nx),x_scal(ijb_v:ije_v,nx)

  !   Local:
  !   ------

  INTEGER :: l,ij
  INTEGER :: ijb,ije
  !-----------------------------------------------------------------------
  ijb=ij_begin
  ije=ij_end
  if (pole_nord) ijb=ij_begin+iip1
  if (pole_sud)  ije=ij_end-iip1

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l=1,nx
     DO ij=ijb,ije
        x_scal(ij,l)= &
              (airev(ij-iip1)*x_v(ij-iip1,l)+airev(ij)*x_v(ij,l)) &
              /(airev(ij-iip1)+airev(ij))
     ENDDO
  ENDDO
!$OMP ENDDO NOWAIT

  if (pole_nord) THEN
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
    DO l=1,nx
       DO ij=1,iip1
          x_scal(ij,l)=0.
       ENDDO
    ENDDO
!$OMP ENDDO NOWAIT
  endif

  if (pole_sud) THEN
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
    DO l=1,nx
       DO ij=ip1jm+1,ip1jmp1
          x_scal(ij,l)=0.
       ENDDO
    ENDDO
!$OMP ENDDO NOWAIT
  endif


END SUBROUTINE gr_v_scal_loc
