! $Id: abort_gcm.F90 5116 2024-07-24 12:54:37Z abarral $

!
!
SUBROUTINE abort_gcm(modname, message, ierr)

  USE IOIPSL
  !! ug Pour les sorties XIOS
  USE wxios

  include "iniprint.h"

  !
  ! Stops the simulation cleanly, closing files and printing various
  ! comments
  !
  !  Input: modname = name of calling program
  !     message = stuff to print
  !     ierr    = severity of situation ( = 0 normal )

  CHARACTER(LEN = *), intent(in) :: modname
  integer, intent(in) :: ierr
  CHARACTER(LEN = *), intent(in) :: message

  WRITE(lunout, *) 'in abort_gcm'

  IF (using_xios) THEN
    !Fermeture propre de XIOS
    CALL wxios_close()
  ENDIF

  CALL histclo
  CALL restclo
  CALL getin_dump
  WRITE(lunout, *) 'Stopping in ', modname
  WRITE(lunout, *) 'Reason = ', message
  if (ierr == 0) THEN
    WRITE(lunout, *) 'Everything is cool'
    stop
  else
    WRITE(lunout, *) 'Houston, we have a problem, ierr = ', ierr
    stop 1
  endif
END SUBROUTINE abort_gcm
