! $Id: fxysinus.f90 5108 2024-07-24 08:58:59Z abarral $

SUBROUTINE fxysinus(rlatu, yprimu, rlatv, yprimv, rlatu1, yprimu1, &
        rlatu2, yprimu2, &
        rlonu, xprimu, rlonv, xprimv, rlonm025, xprimm025, rlonp025, xprimp025)

  USE comconst_mod, ONLY: pi
  USE lmdz_fxy, ONLY: fxy_sin
  IMPLICIT NONE
  !
  ! Calcul  des longitudes et des latitudes  pour une fonction f(x,y)
  !        avec y = Asin( j )  .
  !
  ! Auteur  :  P. Le Van
  !
  !
  INCLUDE "dimensions.h"
  INCLUDE "paramet.h"

  INTEGER :: i, j

  REAL :: rlatu(jjp1), yprimu(jjp1), rlatv(jjm), yprimv(jjm), &
          rlatu1(jjm), yprimu1(jjm), rlatu2(jjm), yprimu2(jjm)
  REAL :: rlonu(iip1), xprimu(iip1), rlonv(iip1), xprimv(iip1), &
          rlonm025(iip1), xprimm025(iip1), rlonp025(iip1), xprimp025(iip1)
  REAL :: fy, fx, fxprim, fyprim, ri, rj

  CALL fxy_sin(fy, fx, fxprim, fyprim, ri, rj)


  !    ......  calcul  des  latitudes  et de y'   .....
  !
  DO j = 1, jjm + 1
    rlatu(j) = fy    (REAL(j))
    yprimu(j) = fyprim(REAL(j))
  ENDDO

  DO j = 1, jjm

    rlatv(j) = fy    (REAL(j) + 0.5)
    rlatu1(j) = fy    (REAL(j) + 0.25)
    rlatu2(j) = fy    (REAL(j) + 0.75)

    yprimv(j) = fyprim(REAL(j) + 0.5)
    yprimu1(j) = fyprim(REAL(j) + 0.25)
    yprimu2(j) = fyprim(REAL(j) + 0.75)

  ENDDO

  !
  ! .....  calcul   des  longitudes et de  x'   .....
  !
  DO i = 1, iim + 1
    rlonv(i) = fx    (REAL(i))
    rlonu(i) = fx    (REAL(i) + 0.5)
    rlonm025(i) = fx    (REAL(i) - 0.25)
    rlonp025(i) = fx    (REAL(i) + 0.25)

    xprimv  (i) = fxprim (REAL(i))
    xprimu  (i) = fxprim (REAL(i) + 0.5)
    xprimm025(i) = fxprim (REAL(i) - 0.25)
    xprimp025(i) = fxprim (REAL(i) + 0.25)
  ENDDO

  !
  RETURN
END SUBROUTINE fxysinus

