module lmdz_cloudth_ini

real, save, protected :: C_cap ,cloudth_ratqsmin ,sigma1s_factor ,sigma1s_power ,sigma2s_factor ,sigma2s_power ,vert_alpha_th ,vert_alpha ,C_mpc , d_top , Ei , Ni
integer, save, protected :: iflag_cloudth_vert_noratqs,iflag_cloudth_vert,iflag_ratqs

!$OMP THREADPRIVATE(C_cap ,cloudth_ratqsmin ,sigma1s_factor ,sigma1s_power ,sigma2s_factor ,sigma2s_power ,vert_alpha_th ,vert_alpha ,C_mpc , d_top , Ei , Ni)
!$OMP THREADPRIVATE(iflag_cloudth_vert_noratqs,iflag_cloudth_vert,iflag_ratqs)


contains

SUBROUTINE cloudth_ini(iflag_cloudth_vert_in,iflag_ratqs_in)

use ioipsl_getin_p_mod, ONLY: getin_p
implicit none
integer, intent(in) :: iflag_cloudth_vert_in,iflag_ratqs_in


        iflag_cloudth_vert=iflag_cloudth_vert_in
        iflag_ratqs=iflag_ratqs_in

        vert_alpha=0.5
        sigma1s_factor=1.1
        sigma1s_power=0.6
        sigma2s_factor=0.09
        sigma2s_power=0.5
        cloudth_ratqsmin=-1.
        iflag_cloudth_vert_noratqs=0
        C_mpc=1.e4
        Ni=2.0e3
        Ei=0.5
        C_cap=0.5
        d_top=1.2


        CALL getin_p('C_cap', C_cap)
        CALL getin_p('cloudth_ratqsmin',cloudth_ratqsmin)
        CALL getin_p('cloudth_sigma1s_factor',sigma1s_factor)
        CALL getin_p('cloudth_sigma1s_power',sigma1s_power)
        CALL getin_p('cloudth_sigma2s_factor',sigma2s_factor)
        CALL getin_p('cloudth_sigma2s_power',sigma2s_power)
        CALL getin_p('cloudth_vert_alpha',vert_alpha)
        vert_alpha_th=vert_alpha
        CALL getin_p('cloudth_vert_alpha_th',vert_alpha_th)
        CALL getin_p('C_mpc',C_mpc)
        CALL getin_p('d_top', d_top)
        CALL getin_p('Ei', Ei)
        CALL getin_p('iflag_cloudth_vert_noratqs',iflag_cloudth_vert_noratqs)
        CALL getin_p('Ni', Ni)

END SUBROUTINE  cloudth_ini

end module lmdz_cloudth_ini
