! mpi SUBROUTINE wrappers

#ifndef CPP_MPI

SUBROUTINE lmdz_mpi_wrapper_abort
  STOP 'CPP_MPI key undefined, must not enter in MPI wrappers ==> aborting'
END SUBROUTINE lmdz_mpi_wrapper_abort

SUBROUTINE MPI_ABORT(COMM, ERRORCODE, IERROR)
IMPLICIT NONE
    INTEGER ::       COMM, ERRORCODE, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_ABORT

SUBROUTINE MPI_ALLGATHER(SENDBUF, SENDCOUNT, SENDTYPE, RECVBUF, RECVCOUNT, RECVTYPE, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::   SENDBUF , RECVBUF
    INTEGER    SENDCOUNT, SENDTYPE, RECVCOUNT, RECVTYPE, COMM
    INTEGER    IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE   MPI_ALLGATHER
  
SUBROUTINE MPI_COMM_SIZE(COMM, SIZE, IERROR)
IMPLICIT NONE
    INTEGER    COMM, SIZE, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_COMM_SIZE

SUBROUTINE MPI_COMM_RANK(COMM, RANK, IERROR)
IMPLICIT NONE
    INTEGER    COMM, RANK, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_COMM_RANK

SUBROUTINE MPI_BARRIER(COMM, IERROR)
IMPLICIT NONE
    INTEGER    COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_BARRIER   

SUBROUTINE MPI_ISEND(BUF, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::    BUF
    INTEGER    COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR
    
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_ISEND

SUBROUTINE MPI_ISSEND(BUF, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::    BUF
    INTEGER    COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_ISSEND

SUBROUTINE MPI_IRECV(BUF, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::    BUF
    INTEGER    COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_IRECV   

SUBROUTINE MPI_WAITALL(COUNT, ARRAY_OF_REQUESTS, ARRAY_OF_STATUSES, IERROR)
USE lmdz_mpi, ONLY: MPI_STATUS_SIZE
IMPLICIT NONE
    INTEGER    COUNT, ARRAY_OF_REQUESTS(*)
    INTEGER    ARRAY_OF_STATUSES(MPI_STATUS_SIZE,*), IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE  MPI_WAITALL  

SUBROUTINE MPI_GATHERV(SENDBUF, SENDCOUNT, SENDTYPE, RECVBUF, RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::    SENDBUF, RECVBUF
    INTEGER    SENDCOUNT, SENDTYPE, RECVCOUNTS(*), DISPLS(*)
    INTEGER    RECVTYPE, ROOT, COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_GATHERV
    
SUBROUTINE MPI_BCAST(BUFFER, COUNT, DATATYPE, ROOT, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::    BUFFER
    INTEGER    COUNT, DATATYPE, ROOT, COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_BCAST

SUBROUTINE MPI_ALLREDUCE(SENDBUF, RECVBUF, COUNT, DATATYPE, OP, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::    SENDBUF, RECVBUF
    INTEGER    COUNT, DATATYPE, OP, COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_ALLREDUCE

SUBROUTINE MPI_INIT_THREAD(REQUIRED, PROVIDED, IERROR)
IMPLICIT NONE
    INTEGER    REQUIRED, PROVIDED, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_INIT_THREAD

SUBROUTINE MPI_ALLOC_MEM(SIZE, INFO, BASEPTR, IERROR)
USE lmdz_mpi, ONLY: MPI_ADDRESS_KIND
IMPLICIT NONE
    INTEGER INFO, IERROR
    INTEGER(KIND=MPI_ADDRESS_KIND) SIZE, BASEPTR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_ALLOC_MEM

SUBROUTINE MPI_SCATTERV(SENDBUF, SENDCOUNTS, DISPLS, SENDTYPE, RECVBUF, RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::    SENDBUF, RECVBUF
    INTEGER    SENDCOUNTS(*), DISPLS(*), SENDTYPE
    INTEGER    RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_SCATTERV

SUBROUTINE MPI_REDUCE(SENDBUF, RECVBUF, COUNT, DATATYPE, OP, ROOT, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE ::    SENDBUF, RECVBUF
    INTEGER    COUNT, DATATYPE, OP, ROOT, COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_REDUCE

SUBROUTINE MPI_RECV(BUF, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)
USE ISO_C_BINDING
USE lmdz_mpi, ONLY: MPI_STATUS_SIZE
IMPLICIT NONE
    TYPE(C_PTR),VALUE ::    BUF
    INTEGER    COUNT, DATATYPE, SOURCE, TAG, COMM
    INTEGER    STATUS(MPI_STATUS_SIZE), IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_RECV

SUBROUTINE MPI_SEND(BUF, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::  BUF
    INTEGER    COUNT, DATATYPE, DEST, TAG, COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_SEND

SUBROUTINE MPI_COMM_SPLIT(COMM, COLOR, KEY, NEWCOMM, IERROR)
IMPLICIT NONE
    INTEGER    COMM, COLOR, KEY, NEWCOMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_COMM_SPLIT


SUBROUTINE MPI_GATHER(SENDBUF, SENDCOUNT, SENDTYPE, RECVBUF, RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)
USE ISO_C_BINDING
IMPLICIT NONE
    TYPE(C_PTR),VALUE  ::  SENDBUF, RECVBUF
    INTEGER    SENDCOUNT, SENDTYPE, RECVCOUNT, RECVTYPE, ROOT
    INTEGER    COMM, IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_GATHER


SUBROUTINE MPI_FINALIZE(IERROR)
IMPLICIT NONE
    INTEGER    IERROR
    CALL lmdz_mpi_wrapper_abort
END SUBROUTINE MPI_Finalize

#endif
