
! $Id: writedynav_p.F 1279 2009-12-10 09:02:56Z fairhead $

      SUBROUTINE writedynav_loc( time, vcov, ucov,teta,ppk,phi,q,
     .                           masse,ps,phis)

! This routine needs IOIPSL
      USE ioipsl
      USE parallel_lmdz
      USE misc_mod
      USE infotrac, ONLY: nqtot
      use com_io_dyn_mod, ONLY: histaveid,histvaveid,histuaveid
      USE comconst_mod, ONLY: cpp
      USE temps_mod, ONLY: itau_dyn
      
      implicit none

C
C   Ecriture du fichier histoire au format IOIPSL
C
C   Appels succesifs des routines: histwrite
C
C   Entree:
C      histid: ID du fichier histoire
C      time: temps de l'ecriture
C      vcov: vents v covariants
C      ucov: vents u covariants
C      teta: temperature potentielle
C      phi : geopotentiel instantane
C      q   : traceurs
C      masse: masse
C      ps   :pression au sol
C      phis : geopotentiel au sol
C      
C
C   Sortie:
C      fileid: ID du fichier netcdf cree
C
C   L. Fairhead, LMD, 03/99
C
C =====================================================================
C
C   Declarations
      include "dimensions.h"
      include "paramet.h"
      include "comgeom.h"
      include "description.h"
      include "iniprint.h"

C
C   Arguments
C

      REAL vcov(ijb_v:ije_v,llm),ucov(ijb_u:ije_u,llm) 
      REAL teta(ijb_u:ije_u,llm),phi(ijb_u:ije_u,llm)
      REAL ppk(ijb_u:ije_u,llm)                  
      REAL ps(ijb_u:ije_u),masse(ijb_u:ije_u,llm)                   
      REAL phis(ijb_u:ije_u)                  
      REAL q(ijb_u:ije_u,llm,nqtot)
      integer time


! This routine needs IOIPSL
C   Variables locales
C
      INTEGER,SAVE,ALLOCATABLE :: ndex2d(:),ndexu(:),ndexv(:)
      INTEGER :: iq, ii, ll
      REAL,SAVE,ALLOCATABLE :: tm(:,:)
      REAL,SAVE,ALLOCATABLE :: vnat(:,:),unat(:,:)
      logical ok_sync
      integer itau_w
      integer :: ijb,ije,jjn
      LOGICAL,SAVE :: first=.TRUE.
!$OMP THREADPRIVATE(first)

C
C  Initialisations
C
      if (adjust) return

      IF (first) THEN
!$OMP BARRIER
!$OMP MASTER
        ALLOCATE(unat(ijb_u:ije_u,llm))
        ALLOCATE(vnat(ijb_v:ije_v,llm))
        ALLOCATE(tm(ijb_u:ije_u,llm))
        ALLOCATE(ndex2d(ijnb_u*llm))
        ALLOCATE(ndexu(ijnb_u*llm))
        ALLOCATE(ndexv(ijnb_v*llm))
        ndex2d = 0
        ndexu = 0
        ndexv = 0
!$OMP END MASTER
!$OMP BARRIER
        first=.FALSE.
      ENDIF

      ok_sync = .TRUE.
      itau_w = itau_dyn + time

C Passage aux composantes naturelles du vent
      CALL covnat_loc(llm, ucov, vcov, unat, vnat)

C
C  Appels a histwrite pour l'ecriture des variables a sauvegarder
C
C  Vents U
C

!$OMP BARRIER
!$OMP MASTER
      ijb=ij_begin
      ije=ij_end
      jjn=jj_nb

      CALL histwrite(histuaveid, 'u', itau_w, unat(ijb:ije,:),
     .               iip1*jjn*llm, ndexu)
!$OMP END MASTER

C
C  Vents V
C
      ije=ij_end
      if (pole_sud) jjn=jj_nb-1
      if (pole_sud) ije=ij_end-iip1
!$OMP BARRIER
!$OMP MASTER
      CALL histwrite(histvaveid, 'v', itau_w, vnat(ijb:ije,:),
     .               iip1*jjn*llm, ndexv)
!$OMP END MASTER


C
C  Temperature potentielle moyennee
C
      ijb=ij_begin
      ije=ij_end
      jjn=jj_nb
!$OMP MASTER
      CALL histwrite(histaveid, 'theta', itau_w, teta(ijb:ije,:),
     .                iip1*jjn*llm, ndexu)
!$OMP END MASTER

C
C  Temperature moyennee
C

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
      do ll=1,llm
        do ii = ijb, ije
          tm(ii,ll) = teta(ii,ll) * ppk(ii,ll)/cpp
        enddo
      enddo
!$OMP ENDDO

!$OMP MASTER
      CALL histwrite(histaveid, 'temp', itau_w, tm(ijb:ije,:),
     .                iip1*jjn*llm, ndexu)
!$OMP END MASTER


C
C  Geopotentiel
C
!$OMP MASTER
      CALL histwrite(histaveid, 'phi', itau_w, phi(ijb:ije,:),
     .                iip1*jjn*llm, ndexu)
!$OMP END MASTER


C
C  Traceurs
C
!!$OMP MASTER
!        DO iq=1,nqtot
!          CALL histwrite(histaveid, tracers(iq)%longName, itau_w, &
!     .                   q(ijb:ije,:,iq), iip1*jjn*llm, ndexu)
!        enddo
!!$OMP END MASTER


C
C  Masse
C
!$OMP MASTER
       CALL histwrite(histaveid, 'masse', itau_w, masse(ijb:ije,:),
     .                iip1*jjn*llm, ndexu)
!$OMP END MASTER


C
C  Pression au sol
C
!$OMP MASTER

       CALL histwrite(histaveid, 'ps', itau_w, ps(ijb:ije),
     .                 iip1*jjn, ndex2d)
!$OMP END MASTER

C
C  Geopotentiel au sol
C
!$OMP MASTER
!       CALL histwrite(histaveid, 'phis', itau_w, phis(ijb:ije),
!     .                 iip1*jjn, ndex2d)
!$OMP END MASTER

C
C  Fin
C
!$OMP MASTER
      if (ok_sync) then
          CALL histsync(histaveid)
          CALL histsync(histvaveid)
          CALL histsync(histuaveid)
      ENDIF
!$OMP END MASTER
      end
