
! $Id: abort_gcm.F 1747 2013-04-23 14:06:30Z lguez $

c
c
      SUBROUTINE abort_gcm(modname, message, ierr)
     
      USE IOIPSL
      USE parallel_lmdz
      INCLUDE "iniprint.h"
 
C
C Stops the simulation cleanly, closing files and printing various
C comments
C
C  Input: modname = name of calling program
C         message = stuff to print
C         ierr    = severity of situation ( = 0 normal )

      character(len=*), intent(in):: modname
      integer ierr, ierror_mpi
      character(len=*), intent(in):: message

      write(lunout,*) 'in abort_gcm'
c$OMP MASTER
      CALL histclo
      CALL restclo
      if (MPI_rank == 0) then
         CALL getin_dump
      endif
c$OMP END MASTER
c     CALL histclo(2)
c     CALL histclo(3)
c     CALL histclo(4)
c     CALL histclo(5)
      write(lunout,*) 'Stopping in ', modname
      write(lunout,*) 'Reason = ',message
      if (ierr == 0) then
        write(lunout,*) 'Everything is cool'
      else
        write(lunout,*) 'Houston, we have a problem, ierr = ', ierr

        if (using_mpi) THEN
C$OMP CRITICAL (MPI_ABORT_GCM)
          CALL MPI_ABORT(COMM_LMDZ, 1, ierror_mpi)
C$OMP END CRITICAL (MPI_ABORT_GCM)
        else
         stop 1
        endif          
      
      endif
      END
