! $Header$

SUBROUTINE dteta1 (teta, pbaru, pbarv, dteta)
  IMPLICIT NONE

  !=======================================================================
  !
  !   Auteur:  P. Le Van
  !   -------
  ! Modif F.Forget 03/94 (on retire q et dq  pour construire dteta1)
  !
  !   ********************************************************************
  !   ... calcul du terme de convergence horizontale du flux d'enthalpie
  !    potentielle   ......
  !   ********************************************************************
  !  .. teta,pbaru et pbarv sont des arguments d'entree  pour le s-pg ....
  ! dteta 	          sont des arguments de sortie pour le s-pg ....
  !
  !=======================================================================

  include "dimensions.h"
  include "paramet.h"

  REAL :: teta(ip1jmp1, llm), pbaru(ip1jmp1, llm), pbarv(ip1jm, llm)
  REAL :: dteta(ip1jmp1, llm)
  INTEGER :: l, ij

  REAL :: hbyv(ip1jm, llm), hbxu(ip1jmp1, llm)

  !

  DO l = 1, llm

    DO ij = iip2, ip1jm - 1
      hbxu(ij, l) = pbaru(ij, l) * 0.5 * (teta(ij, l) + teta(ij + 1, l))
    END DO

    !    .... correction pour  hbxu(iip1,j,l)  .....
    !    ....   hbxu(iip1,j,l)= hbxu(1,j,l) ....

    !DIR$ IVDEP
    DO ij = iip1 + iip1, ip1jm, iip1
      hbxu(ij, l) = hbxu(ij - iim, l)
    END DO

    DO ij = 1, ip1jm
      hbyv(ij, l) = pbarv(ij, l) * 0.5 * (teta(ij, l) + teta(ij + iip1, l))
    END DO

  END DO

  CALL  convflu (hbxu, hbyv, llm, dteta)


  !    stockage dans  dh de la convergence horizont. filtree' du  flux
  ! ....                           ...........
  ! d'enthalpie potentielle .

  CALL filtreg(dteta, jjp1, llm, 2, 2, .TRUE., 1)

  !
  RETURN
END SUBROUTINE dteta1
