! $Id: abort_gcm.F90 5103 2024-07-23 13:29:36Z abarral $

!
!
SUBROUTINE abort_gcm(modname, message, ierr)

  USE IOIPSL
  !! ug Pour les sorties XIOS
  USE wxios

  include "iniprint.h"

  !
  ! Stops the simulation cleanly, closing files and printing various
  ! comments
  !
  !  Input: modname = name of calling program
  !     message = stuff to print
  !     ierr    = severity of situation ( = 0 normal )

  character(len = *), intent(in) :: modname
  integer, intent(in) :: ierr
  character(len = *), intent(in) :: message

  write(lunout, *) 'in abort_gcm'

  IF (using_xios) THEN
    !Fermeture propre de XIOS
    CALL wxios_close()
  ENDIF

  CALL histclo
  CALL restclo
  CALL getin_dump
  write(lunout, *) 'Stopping in ', modname
  write(lunout, *) 'Reason = ', message
  if (ierr == 0) then
    write(lunout, *) 'Everything is cool'
    stop
  else
    write(lunout, *) 'Houston, we have a problem, ierr = ', ierr
    stop 1
  endif
END SUBROUTINE abort_gcm
