MODULE lmdz_thermcell_closure

! $Header$

CONTAINS

      SUBROUTINE thermcell_closure(ngrid,nlay,r_aspect,ptimestep,rho,  &
     zlev,lalim,alim_star,zmax,wmax,f)

!-------------------------------------------------------------------------
!thermcell_closure: fermeture, determination de f

! Modification 7 septembre 2009
! 1. On enleve alim_star_tot des arguments pour le recalculer et etre ainis
! coherent avec l'integrale au numerateur.
! 2. On ne garde qu'une version des couples wmax,zmax et wmax_sec,zmax_sec
! l'idee etant que le choix se fasse a l'appel de thermcell_closure
! 3. Vectorisation en mettant les boucles en l l'exterieur avec des if
!-------------------------------------------------------------------------
      IMPLICIT NONE

! --- arguments ------------------------------------------
integer, intent(in) :: ngrid,nlay
real, intent(in) :: r_aspect,ptimestep
real, intent(in), dimension(ngrid,nlay) :: alim_star,rho,zlev
integer, intent(in), dimension(ngrid) :: lalim
real, intent(in), dimension(ngrid) :: zmax,wmax

real, intent(out), dimension(ngrid) :: f


! --- local ------------------------------------------
real, dimension(ngrid) :: zdenom,alim_star2,alim_star_tot
INTEGER llmax
INTEGER ig,k       

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!PRINT*,'THERMCELL CLOSURE 26E'

alim_star2(:)=0.
alim_star_tot(:)=0.
f(:)=0.

! Indice vertical max (max de lalim) atteint par les thermiques sur le domaine
llmax=1
DO ig=1,ngrid
   if (lalim(ig)>llmax) llmax=lalim(ig)
END DO


! Calcul des integrales sur la verticale de alim_star et de
!   alim_star^2/(rho dz)
DO k=1,llmax-1
   do ig=1,ngrid
      if (k<lalim(ig)) then
         alim_star2(ig)=alim_star2(ig)+alim_star(ig,k)**2  &
&                    /(rho(ig,k)*(zlev(ig,k+1)-zlev(ig,k)))
         alim_star_tot(ig)=alim_star_tot(ig)+alim_star(ig,k)
      endif
   enddo
END DO


DO ig=1,ngrid
   if (alim_star2(ig)>1.e-10) then
      f(ig)=wmax(ig)*alim_star_tot(ig)/  &
&     (max(500.,zmax(ig))*r_aspect*alim_star2(ig))
   endif
END DO



 RETURN
      end
END MODULE lmdz_thermcell_closure
