      SUBROUTINE iotd_ini(fichnom,iim,jjm,llm,prlon,prlat,pcoordv,jour0,mois0,an0,t0,timestep,calendrier)
            USE netcdf, ONLY: nf90_enddef,nf90_put_att,nf90_float,nf90_def_var,nf90_redef,&
                    nf90_global,nf90_def_dim,nf90_create,nf90_clobber,nf90_unlimited,nf90_put_var
      IMPLICIT NONE

!=======================================================================

!   Auteur:  F. Hourdin
!   -------

!   Objet:
!   ------
!   Light interface for netcdf outputs. can be used outside LMDZ

!=======================================================================
!-----------------------------------------------------------------------
!   Declarations:
!   -------------

      INCLUDE "iotd.h"

!   Arguments:
!   ----------

      integer iim,jjm,llm
      real prlon(iim),prlat(jjm),pcoordv(llm),timestep,t0
      INTEGER id_FOCE
      INTEGER jour0,mois0,an0
      CHARACTER*(*) calendrier

      integer corner(4),edges(4),ndim
      real  px(1000)
      character (len=10) :: nom
      real(kind=4) rlon(iim),rlat(jjm),coordv(llm)

!   Local:
!   ------
      CHARACTER*3,DIMENSION(12) :: cmois=(/'JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC'/)
      CHARACTER*10 date0
      CHARACTER*11 date0b

      INTEGER :: ierr

      integer :: nvarid
      integer, dimension(2) :: id  

      character*(*) fichnom

      real pi

      iotd_ts=timestep
      iotd_t0=t0
      PRINT*,'iotd_ini, ',timestep,iotd_ts
      imax=iim
      jmax=jjm
      lmax=llm
      ! Utile pour passer en real*4 pour les ecritures
      rlon=prlon
      rlat=prlat
      coordv=pcoordv


      !-----------------------------------------------------------------------
      ! Possibilité de spécifier une liste de variables à sortir
      ! dans iotd.def
      ! Si iotd.def existe et est non vide,
      ! seules les variables faisant à la fois l'objet d'un CALL iotd_ecrit
      ! et étant spécifiées dans iotd.def sont sorties.
      ! Sinon, toutes les variables faisant l'objet d'un CALL iotd_ecrit
      ! sont sorties
      !-----------------------------------------------------------------------
      n_names_iotd_def=0
      open(99,file='iotd.def',form='formatted',status='old',iostat=ierr)
         if ( ierr==0 ) then
            ierr=0
            do while (ierr==0)
               read(99,*,iostat=ierr) un_nom
               if (ierr==0) then
                  n_names_iotd_def=n_names_iotd_def+1
                  names_iotd_def(n_names_iotd_def)=un_nom
               endif
            enddo
         endif
         PRINT*,n_names_iotd_def,names_iotd_def(1:n_names_iotd_def)
      close(99)


      pi=2.*asin(1.)

! Define dimensions
    
      ! Create the NetCDF file
      ierr=nf90_create(fichnom, nf90_clobber, nid)
      ierr=nf90_def_dim(nid, "lon", iim, dim_coord(1))
      ierr=nf90_def_dim(nid, "lat", jjm, dim_coord(2))
      ierr=nf90_def_dim(nid, "lev", llm, dim_coord(3))
      ierr=nf90_def_dim(nid,"time",nf90_unlimited,dim_coord(4))
      ierr = nf90_put_att(nid,nf90_global,'Conventions',"CF-1.1")
      !ierr = nf90_put_att(nid,nf90_global,'file_name',TRIM(fname))
      ierr=nf90_enddef(nid)

      ! Switch out of NetCDF Define mode


      ierr=nf90_enddef(nid)

!  Contol parameters for this run
! ---- longitude -----------

      ierr=nf90_redef(nid)
      ierr=nf90_def_var(nid,"lon", nf90_float, dim_coord(1),nvarid)
      ierr = nf90_put_att(nid,nvarid,'axis','X')
      ierr=nf90_put_att(nid,nvarid,'units',"degrees_east")
      ierr=nf90_enddef(nid)
      ierr=nf90_put_var(nid,nvarid,rlon)
       PRINT*,ierr

! ---- latitude ------------
      ierr=nf90_redef(nid)
      ierr=nf90_def_var(nid, "lat", nf90_float, dim_coord(2),nvarid)
      ierr = nf90_put_att(nid,nvarid,'axis','Y')
      ierr=nf90_put_att(nid,nvarid,'units',"degrees_north")
      ierr=nf90_enddef(nid)
      ierr=nf90_put_var(nid,nvarid,rlat)

! ---- vertical ------------
      ierr=nf90_redef(nid)
      ierr=nf90_def_var(nid, "lev", nf90_float,dim_coord(3),nvarid)
      ierr=nf90_put_att(nid,nvarid,"long_name","vert level")
      if ( coordv(2)>coordv(1) ) then
         ierr=nf90_put_att(nid,nvarid,"long_name","pseudo-alt")
         ierr=nf90_put_att(nid,nvarid,'positive',"up")
      else
         ierr=nf90_put_att(nid,nvarid,"long_name","pressure")
         ierr = nf90_put_att(nid,nvarid,'positive',"down")
      endif
      ierr=nf90_enddef(nid)
      ierr=nf90_put_var(nid,nvarid,coordv)

! ---- time ----------------
      ierr=nf90_redef(nid)
      ! Define the 'time' variable
      ierr=nf90_def_var(nid, "time", nf90_float, dim_coord(4),nvarid)
!     ! Add attributes
      ierr = nf90_put_att(nid,nvarid,'axis','T')
      ierr = nf90_put_att(nid,nvarid,'standard_name','time')
      WRITE(date0,'(i4.4,"-",i2.2,"-",i2.2)') an0,mois0,jour0
      ierr=nf90_put_att(nid, nvarid,'units', &
   "seconds since "//date0//" 00:00:00")
      ierr = nf90_put_att(nid,nvarid,'calendar',calendrier)
      !ierr = nf90_put_att(nid,nvarid,'calendar','360d')
      ierr = nf90_put_att(nid,nvarid,'title','Time')
      ierr = nf90_put_att(nid,nvarid,'long_name','Time axis')
      WRITE(date0b,'(i4.4,"-",a3,"-",i2.2)') an0,cmois(mois0),jour0
      ierr = nf90_put_att(nid,nvarid,'time_origin', &
          date0b//' 00:00:00')
      ierr=nf90_enddef(nid)


      END
