module config_ocean_skin_m

  implicit none

  logical, protected:: jcool ! cool skin calculation
  logical, protected:: jwarm ! warm layer calculation
  logical, protected:: rain_effect

  real, protected:: depth_1 = 20.
  ! Depth at which the temperature and salinity are input. Could be
  ! the depth of a sensor, or the depth at the middle of the first
  ! layer of an ocean model (half the depth of the first layer). In
  ! m. Setting depth_1 to any value >= depth (named constant defined
  ! in module `near_Surface_m`) has the same effect as setting depth_1
  ! to depth.

  !$omp threadprivate(jcool, jwarm, rain_effect, depth_1)

#ifdef IN_LMDZ
  integer, protected:: activate_ocean_skin = 0
  ! Allowed values: 0 do not activate; 1 activate without retroaction
  ! on LMDZ; 2 activate with retroaction on LMDZ
  
  !$omp threadprivate(activate_ocean_skin)
#endif

contains

  SUBROUTINE config_ocean_skin

#ifdef IN_LMDZ
    use ioipsl_getin_p_mod, only: getin_p
    use assert_m, only: assert
#endif

    integer:: flag_ocean_skin = 3
    !$omp threadprivate(flag_ocean_skin)
    
    namelist /config_ocean_skin_nml/ flag_ocean_skin, depth_1

    !-----------------------------------------------------------------------

#ifdef IN_LMDZ
    CALL getin_p("activate_ocean_skin", activate_ocean_skin)
    CALL assert(activate_ocean_skin >= 0 .and. activate_ocean_skin <= 2, &
         "config_ocean_skin bad value of activate_ocean_skin")
    if (activate_ocean_skin >= 1) then
       CALL getin_p("flag_ocean_skin", flag_ocean_skin)
       CALL getin_p("depth_1", depth_1)
    end if
#else
    write(unit = *, nml = config_ocean_skin_nml)
    print *, "Enter namelist config_ocean_skin_nml."
    read(unit = *, nml = config_ocean_skin_nml)
    write(unit = *, nml = config_ocean_skin_nml)
#endif

    select case (flag_ocean_skin)
    case (0)
       jwarm = .FALSE.
       jcool = .FALSE.
       rain_effect = .FALSE.
    case (1)
       jwarm = .FALSE.
       jcool = .TRUE.
       rain_effect = .FALSE.
    case (2)
       jwarm = .TRUE.
       jcool = .TRUE.
       rain_effect = .FALSE.
    case (3)
       jwarm = .TRUE.
       jcool = .TRUE.
       rain_effect = .TRUE.
    case default
       print *, "config_ocean_skin: bad value for flag_ocean_skin."
       stop 1
    end select

  END SUBROUTINE  config_ocean_skin

end module config_ocean_skin_m
