! ---------------------------------------------
! This file is part of an effort to replace most uses of preprocessor CPP keys by fortran variables,
! to improve readability, compilation coverage, and linting.
! CPP keys used here should ONLY be used here (unless specified explicitely),
! and imported through USE ..., ONLY: ... elsewhere
! CPP keys supported (key -> fortran variables associated):
!      NC_DOUBLE -> nf90_format
!      CPP_PHYS  -> CPPKEY_PHYS
!      INCA      -> CPPKEY_INCA
!      CPP_StratAer-> CPPKEY_STRATAER
! ---------------------------------------------

MODULE lmdz_cppkeys_wrapper
  USE, INTRINSIC :: ISO_FORTRAN_ENV, ONLY : REAL64, REAL32
  USE netcdf, ONLY: nf90_float, nf90_double
  IMPLICIT NONE; PRIVATE
  PUBLIC nf90_format, CPPKEY_PHYS, CPPKEY_INCA, CPPKEY_STRATAER

#ifdef NC_DOUBLE
  INTEGER, PARAMETER :: nf90_format = nf90_double
#else
  INTEGER, PARAMETER :: nf90_format = nf90_float
#endif

#ifdef CPP_PHYS
  LOGICAL, PARAMETER :: CPPKEY_PHYS = .TRUE.
#else
  LOGICAL, PARAMETER :: CPPKEY_PHYS = .FALSE.
#endif

#ifdef INCA
  LOGICAL, PARAMETER :: CPPKEY_INCA = .TRUE.
#else
  LOGICAL, PARAMETER :: CPPKEY_INCA = .FALSE.
#endif

#ifdef CPP_StratAer
  LOGICAL, PARAMETER :: CPPKEY_STRATAER = .TRUE.
#else
  LOGICAL, PARAMETER :: CPPKEY_STRATAER = .FALSE.
#endif

END MODULE lmdz_cppkeys_wrapper