!
! $Id: phys_local_var_mod.F90 3888 2021-05-05 10:50:37Z jyg $
!
      MODULE phys_local_var_mod
! Variables locales pour effectuer les appels en serie
!======================================================================
!
!
!======================================================================
! Declaration des variables

      REAL, SAVE, ALLOCATABLE :: t_seri(:,:), q_seri(:,:)
      !$OMP THREADPRIVATE(t_seri, q_seri)
      REAL, SAVE, ALLOCATABLE :: ql_seri(:,:),qs_seri(:,:)
      !$OMP THREADPRIVATE(ql_seri,qs_seri)
      REAL, SAVE, ALLOCATABLE :: qx_seri(:,:,:)
      !$OMP THREADPRIVATE(qx_seri)
      REAL, SAVE, ALLOCATABLE :: qbs_seri(:,:)
      !$OMP THREADPRIVATE(qbs_seri)
      REAL, SAVE, ALLOCATABLE :: u_seri(:,:), v_seri(:,:)
      !$OMP THREADPRIVATE(u_seri, v_seri)
      REAL, SAVE, ALLOCATABLE :: rneb_seri(:,:)
      !$OMP THREADPRIVATE(rneb_seri)
      REAL, SAVE, ALLOCATABLE :: d_rneb_dyn(:,:)
      !$OMP THREADPRIVATE(d_rneb_dyn)
      REAL, SAVE, ALLOCATABLE :: l_mixmin(:,:,:),l_mix(:,:,:),wprime(:,:,:)
      !$OMP THREADPRIVATE(l_mixmin, l_mix, wprime)
      REAL, SAVE, ALLOCATABLE :: pbl_eps(:,:,:)
      !$OMP THREADPRIVATE(pbl_eps)
      REAL, SAVE, ALLOCATABLE :: tke_shear(:,:,:), tke_buoy(:,:,:), tke_trans(:,:,:)
      !$OMP THREADPRIVATE(tke_shear,tke_buoy,tke_trans)
      REAL, SAVE, ALLOCATABLE :: tr_seri(:,:,:)
      !$OMP THREADPRIVATE(tr_seri)
      REAL, SAVE, ALLOCATABLE :: rhcl(:,:)
      !$OMP THREADPRIVATE(rhcl)
      REAL, SAVE, ALLOCATABLE :: d_t_dyn(:,:), d_q_dyn(:,:)
      !$OMP THREADPRIVATE(d_t_dyn, d_q_dyn)
      REAL, SAVE, ALLOCATABLE :: d_ql_dyn(:,:), d_qs_dyn(:,:), d_qbs_dyn(:,:)
      !$OMP THREADPRIVATE(d_ql_dyn, d_qs_dyn, d_qbs_dyn)
      REAL, SAVE, ALLOCATABLE :: d_q_dyn2d(:), d_ql_dyn2d(:), d_qs_dyn2d(:), d_qbs_dyn2d(:)
      !$OMP THREADPRIVATE(d_q_dyn2d, d_ql_dyn2d, d_qs_dyn2d, d_qbs_dyn2d)
      REAL, SAVE, ALLOCATABLE :: d_u_dyn(:,:), d_v_dyn(:,:)
      !$OMP THREADPRIVATE(d_u_dyn, d_v_dyn)
      REAL, SAVE, ALLOCATABLE :: d_tr_dyn(:,:,:)
      !$OMP THREADPRIVATE(d_tr_dyn)
      REAL, SAVE, ALLOCATABLE :: d_t_con(:,:),d_q_con(:,:),d_q_con_zmasse(:,:)
      !$OMP THREADPRIVATE(d_t_con,d_q_con,d_q_con_zmasse)
      REAL, SAVE, ALLOCATABLE :: d_u_con(:,:),d_v_con(:,:)
      !$OMP THREADPRIVATE(d_u_con,d_v_con)
      REAL, SAVE, ALLOCATABLE :: d_t_wake(:,:),d_q_wake(:,:)
      !$OMP THREADPRIVATE( d_t_wake,d_q_wake)
      REAL, SAVE, ALLOCATABLE :: d_t_lsc(:,:),d_q_lsc(:,:),d_ql_lsc(:,:),d_qi_lsc(:,:)
      !$OMP THREADPRIVATE(d_t_lsc,d_q_lsc,d_ql_lsc,d_qi_lsc)
      REAL, SAVE, ALLOCATABLE :: d_t_lwr(:,:),d_t_lw0(:,:),d_t_swr(:,:),d_t_sw0(:,:)
      !$OMP THREADPRIVATE(d_t_lwr,d_t_lw0,d_t_swr,d_t_sw0)
      REAL, SAVE, ALLOCATABLE :: d_t_ajsb(:,:), d_q_ajsb(:,:)
      !$OMP THREADPRIVATE(d_t_ajsb, d_q_ajsb)
      REAL, SAVE, ALLOCATABLE :: d_t_ajs(:,:), d_q_ajs(:,:)
      !$OMP THREADPRIVATE(d_t_ajs, d_q_ajs)
      REAL, SAVE, ALLOCATABLE :: d_u_ajs(:,:), d_v_ajs(:,:)
      !$OMP THREADPRIVATE(d_u_ajs, d_v_ajs)
!nrlmd<
      REAL, SAVE, ALLOCATABLE :: d_t_ajs_w(:,:), d_q_ajs_w(:,:)
      !$OMP THREADPRIVATE(d_t_ajs_w, d_q_ajs_w)
      REAL, SAVE, ALLOCATABLE :: d_t_ajs_x(:,:), d_q_ajs_x(:,:)
      !$OMP THREADPRIVATE(d_t_ajs_x, d_q_ajs_x)
!>nrlmd
      REAL, SAVE, ALLOCATABLE :: d_t_eva(:,:),d_q_eva(:,:),d_ql_eva(:,:),d_qi_eva(:,:)
      !$OMP THREADPRIVATE(d_t_eva,d_q_eva,d_ql_eva,d_qi_eva)
      REAL, SAVE, ALLOCATABLE :: d_qx_eva(:,:,:)
      !$OMP THREADPRIVATE(d_qx_eva)
      REAL, SAVE, ALLOCATABLE :: d_t_lscst(:,:),d_q_lscst(:,:)
      !$OMP THREADPRIVATE(d_t_lscst,d_q_lscst)
      REAL, SAVE, ALLOCATABLE :: d_t_lscth(:,:),d_q_lscth(:,:)
      !$OMP THREADPRIVATE(d_t_lscth,d_q_lscth)
      REAL, SAVE, ALLOCATABLE :: plul_th(:),plul_st(:)
      !$OMP THREADPRIVATE(plul_th,plul_st)
!tendances dues a oro et lif
      REAL, SAVE, ALLOCATABLE :: d_t_oli(:,:)
      !$OMP THREADPRIVATE(d_t_oli)
      REAL, SAVE, ALLOCATABLE :: d_u_oli(:,:), d_v_oli(:,:)
      !$OMP THREADPRIVATE(d_u_oli, d_v_oli)
      REAL, SAVE, ALLOCATABLE :: d_t_vdf(:,:), d_q_vdf(:,:), d_qbs_vdf(:,:), d_t_diss(:,:)
      !$OMP THREADPRIVATE( d_t_vdf, d_q_vdf, d_qbs_vdf, d_t_diss)
      REAL, SAVE, ALLOCATABLE :: d_u_vdf(:,:), d_v_vdf(:,:)
      !$OMP THREADPRIVATE(d_u_vdf, d_v_vdf)
!nrlmd+jyg<
      REAL, SAVE, ALLOCATABLE :: d_t_vdf_w(:,:), d_q_vdf_w(:,:)
      !$OMP THREADPRIVATE( d_t_vdf_w, d_q_vdf_w)
      REAL, SAVE, ALLOCATABLE :: d_t_vdf_x(:,:), d_q_vdf_x(:,:)
      !$OMP THREADPRIVATE( d_t_vdf_x, d_q_vdf_x)
      REAL, SAVE, ALLOCATABLE :: d_t_bsss(:,:), d_q_bsss(:,:), d_qbs_bsss(:,:)
      !$OMP THREADPRIVATE( d_t_bsss,d_q_bsss, d_qbs_bsss)
!>nrlmd+jyg
      REAL, SAVE, ALLOCATABLE :: d_t_oro(:,:)
      !$OMP THREADPRIVATE(d_t_oro)
      REAL, SAVE, ALLOCATABLE :: d_u_oro(:,:), d_v_oro(:,:)
      !$OMP THREADPRIVATE(d_u_oro, d_v_oro)
      REAL, SAVE, ALLOCATABLE :: d_t_oro_gw(:,:)
      !$OMP THREADPRIVATE(d_t_oro_gw)
      REAL, SAVE, ALLOCATABLE :: d_u_oro_gw(:,:), d_v_oro_gw(:,:)
      !$OMP THREADPRIVATE(d_u_oro_gw, d_v_oro_gw)
      REAL, SAVE, ALLOCATABLE :: d_t_lif(:,:)
      !$OMP THREADPRIVATE(d_t_lif)
      REAL, SAVE, ALLOCATABLE :: d_u_lif(:,:), d_v_lif(:,:)
      !$OMP THREADPRIVATE(d_u_lif, d_v_lif)
! Tendances Ondes de G non oro (runs strato).
      REAL, SAVE, ALLOCATABLE :: du_gwd_hines(:,:)
      !$OMP THREADPRIVATE(du_gwd_hines)
      REAL, SAVE, ALLOCATABLE :: dv_gwd_hines(:,:)
      !$OMP THREADPRIVATE(dv_gwd_hines)
      REAL, SAVE, ALLOCATABLE :: dv_gwd_rando(:,:)
      !$OMP THREADPRIVATE(dv_gwd_rando)
      REAL, SAVE, ALLOCATABLE :: dv_gwd_front(:,:)
      !$OMP THREADPRIVATE(dv_gwd_front)
      REAL, SAVE, ALLOCATABLE :: east_gwstress(:,:)
      !$OMP THREADPRIVATE(east_gwstress)
      REAL, SAVE, ALLOCATABLE :: west_gwstress(:,:)
      !$OMP THREADPRIVATE(west_gwstress)
      REAL, SAVE, ALLOCATABLE :: d_t_hin(:,:)
      !$OMP THREADPRIVATE(d_t_hin)
! tendance due a l'oxydation du methane
      REAL, SAVE, ALLOCATABLE :: d_q_ch4(:,:)
      !$OMP THREADPRIVATE(d_q_ch4)
#ifdef ISO
      REAL, SAVE, ALLOCATABLE :: xt_seri(:,:,:)
      !$OMP THREADPRIVATE( xt_seri)
      REAL, SAVE, ALLOCATABLE :: xtl_seri(:,:,:)
      !$OMP THREADPRIVATE( xtl_seri)
      REAL, SAVE, ALLOCATABLE :: xts_seri(:,:,:)
      !$OMP THREADPRIVATE( xts_seri)
      REAL, SAVE, ALLOCATABLE :: xtbs_seri(:,:,:)
      !$OMP THREADPRIVATE( xtbs_seri)
      REAL, SAVE, ALLOCATABLE :: d_xt_eva(:,:,:)
      !$OMP THREADPRIVATE( d_xt_eva)
      REAL, SAVE, ALLOCATABLE :: d_xtl_eva(:,:,:)
      !$OMP THREADPRIVATE( d_xtl_eva)
      REAL, SAVE, ALLOCATABLE :: d_xti_eva(:,:,:)
      !$OMP THREADPRIVATE( d_xti_eva)
      REAL, SAVE, ALLOCATABLE :: d_xt_vdf(:,:,:)
      !$OMP THREADPRIVATE( d_xt_vdf)
      REAL, SAVE, ALLOCATABLE :: d_xt_dyn(:,:,:)
      !$OMP THREADPRIVATE( d_xt_dyn)
      REAL, SAVE, ALLOCATABLE :: d_xtl_dyn(:,:,:), d_xts_dyn(:,:,:), d_xtbs_dyn(:,:,:)
      !$OMP THREADPRIVATE(d_xtl_dyn, d_xts_dyn, d_xtbs_dyn)
      REAL, SAVE, ALLOCATABLE :: d_xt_con(:,:,:)
      !$OMP THREADPRIVATE( d_xt_con)
      REAL, SAVE, ALLOCATABLE :: d_xt_wake(:,:,:)
      !$OMP THREADPRIVATE( d_xt_wake)
      REAL, SAVE, ALLOCATABLE :: d_xt_lsc(:,:,:),d_xtl_lsc(:,:,:),d_xti_lsc(:,:,:)
      !$OMP THREADPRIVATE( d_xt_lsc,d_xtl_lsc,d_xti_lsc)
      REAL, SAVE, ALLOCATABLE :: d_xt_ajsb(:,:,:)
      !$OMP THREADPRIVATE( d_xt_ajsb)
      REAL, SAVE, ALLOCATABLE :: d_xt_ajs(:,:,:)
      !$OMP THREADPRIVATE( d_xt_ajs)
      REAL, SAVE, ALLOCATABLE :: d_xt_ajs_w(:,:,:), d_xt_ajs_x(:,:,:)
      !$OMP THREADPRIVATE(d_xt_ajs_w, d_xt_ajs_x)
      REAL, SAVE, ALLOCATABLE :: d_xt_vdf_w(:,:,:), d_xt_vdf_x(:,:,:)
      !$OMP THREADPRIVATE(d_xt_vdf_w, d_xt_vdf_x)
      REAL, SAVE, ALLOCATABLE :: d_xt_ch4(:,:,:)
      !$OMP THREADPRIVATE( d_xt_ch4)
      REAL, SAVE, ALLOCATABLE :: d_xt_prod_nucl(:,:,:)
      !$OMP THREADPRIVATE( d_xt_prod_nucl)
      REAL, SAVE, ALLOCATABLE :: d_xt_cosmo(:,:,:)
      !$OMP THREADPRIVATE( d_xt_cosmo)
      REAL, SAVE, ALLOCATABLE :: d_xt_decroiss(:,:,:)
      !$OMP THREADPRIVATE( d_xt_decroiss)
#endif

! tendance du a la conersion Ec -> E thermique
      REAL, SAVE, ALLOCATABLE :: d_t_ec(:,:)
      !$OMP THREADPRIVATE(d_t_ec)
      REAL, SAVE, ALLOCATABLE :: d_ts(:,:), d_tr(:,:,:)
      !$OMP THREADPRIVATE(d_ts, d_tr)

! aerosols
      REAL, SAVE, ALLOCATABLE :: m_allaer (:,:,:)
      !$OMP THREADPRIVATE(m_allaer)
! diagnostique pour le rayonnement
      REAL, SAVE, ALLOCATABLE :: topswad_aero(:),  solswad_aero(:)      ! diag
      !$OMP THREADPRIVATE(topswad_aero,solswad_aero)
      REAL, SAVE, ALLOCATABLE :: topswai_aero(:),  solswai_aero(:)      ! diag
      !$OMP THREADPRIVATE(topswai_aero,solswai_aero)
      REAL, SAVE, ALLOCATABLE :: topswad0_aero(:), solswad0_aero(:)     ! diag
      !$OMP THREADPRIVATE(topswad0_aero,solswad0_aero)
      REAL, SAVE, ALLOCATABLE :: topsw_aero(:,:),  solsw_aero(:,:)      ! diag
      !$OMP THREADPRIVATE(topsw_aero,solsw_aero)
      REAL, SAVE, ALLOCATABLE :: topsw0_aero(:,:), solsw0_aero(:,:)     ! diag
      !$OMP THREADPRIVATE(topsw0_aero,solsw0_aero)
      REAL, SAVE, ALLOCATABLE :: topswcf_aero(:,:),  solswcf_aero(:,:)  ! diag
      !$OMP THREADPRIVATE(topswcf_aero,solswcf_aero)
! LW radiation diagnostics CK
      REAL, SAVE, ALLOCATABLE :: toplwad_aero(:),  sollwad_aero(:)      ! diag
      !$OMP THREADPRIVATE(toplwad_aero,sollwad_aero)
      REAL, SAVE, ALLOCATABLE :: toplwai_aero(:),  sollwai_aero(:)      ! diag
      !$OMP THREADPRIVATE(toplwai_aero,sollwai_aero)
      REAL, SAVE, ALLOCATABLE :: toplwad0_aero(:), sollwad0_aero(:)     ! diag
      !$OMP THREADPRIVATE(toplwad0_aero,sollwad0_aero)
! Special RRTM
      REAL, SAVE, ALLOCATABLE :: ZLWFT0_i(:,:),  ZSWFT0_i(:,:)      ! diag
      !$OMP THREADPRIVATE(ZLWFT0_i,ZSWFT0_i)
      REAL, SAVE, ALLOCATABLE :: ZFLDN0(:,:),  ZFLUP0(:,:)      ! diag
      !$OMP THREADPRIVATE(ZFLDN0,ZFLUP0)
      REAL, SAVE, ALLOCATABLE :: ZFSDN0(:,:),  ZFSUP0(:,:)      ! diag
      !$OMP THREADPRIVATE(ZFSDN0,ZFSUP0)
!
      REAL, SAVE, ALLOCATABLE :: stratomask(:,:) 
      !$OMP THREADPRIVATE(stratomask) 
      REAL, SAVE, ALLOCATABLE :: tausum_aero(:,:,:) 
      !$OMP THREADPRIVATE(tausum_aero) 
      REAL, SAVE, ALLOCATABLE :: drytausum_aero(:,:) 
      !$OMP THREADPRIVATE(drytausum_aero) 
      REAL, SAVE, ALLOCATABLE :: tau3d_aero(:,:,:,:) 
      !$OMP THREADPRIVATE(tau3d_aero) 
      REAL, SAVE, ALLOCATABLE :: dNovrN(:) 
      !$OMP THREADPRIVATE(dNovrN) 
      REAL, SAVE, ALLOCATABLE :: zfice(:,:)
      !$OMP THREADPRIVATE(zfice)
      REAL, SAVE, ALLOCATABLE :: od443aer(:) 
      !$OMP THREADPRIVATE(od443aer) 
      REAL, SAVE, ALLOCATABLE :: od550aer(:) 
      !$OMP THREADPRIVATE(od550aer) 
      REAL, SAVE, ALLOCATABLE :: dryod550aer(:) 
      !$OMP THREADPRIVATE(dryod550aer) 
      REAL, SAVE, ALLOCATABLE :: abs550aer(:) 
      !$OMP THREADPRIVATE(abs550aer) 
      REAL, SAVE, ALLOCATABLE :: od865aer(:) 
      !$OMP THREADPRIVATE(od865aer) 
      REAL, SAVE, ALLOCATABLE :: ec550aer(:,:) 
      !$OMP THREADPRIVATE(ec550aer) 
      REAL, SAVE, ALLOCATABLE :: od550lt1aer(:) 
      !$OMP THREADPRIVATE(od550lt1aer) 
      REAL, SAVE, ALLOCATABLE :: sconcso4(:) 
      !$OMP THREADPRIVATE(sconcso4) 
      REAL, SAVE, ALLOCATABLE :: sconcno3(:) 
      !$OMP THREADPRIVATE(sconcno3) 
      REAL, SAVE, ALLOCATABLE :: sconcoa(:) 
      !$OMP THREADPRIVATE(sconcoa) 
      REAL, SAVE, ALLOCATABLE :: sconcbc(:) 
      !$OMP THREADPRIVATE(sconcbc) 
      REAL, SAVE, ALLOCATABLE :: sconcss(:) 
      !$OMP THREADPRIVATE(sconcss) 
      REAL, SAVE, ALLOCATABLE :: sconcdust(:) 
      !$OMP THREADPRIVATE(sconcdust) 
      REAL, SAVE, ALLOCATABLE :: concso4(:,:) 
      !$OMP THREADPRIVATE(concso4) 
      REAL, SAVE, ALLOCATABLE :: concno3(:,:) 
      !$OMP THREADPRIVATE(concno3) 
      REAL, SAVE, ALLOCATABLE :: concoa(:,:) 
      !$OMP THREADPRIVATE(concoa) 
      REAL, SAVE, ALLOCATABLE :: concbc(:,:) 
      !$OMP THREADPRIVATE(concbc) 
      REAL, SAVE, ALLOCATABLE :: concss(:,:) 
      !$OMP THREADPRIVATE(concss) 
      REAL, SAVE, ALLOCATABLE :: concdust(:,:) 
      !$OMP THREADPRIVATE(concdust) 
      REAL, SAVE, ALLOCATABLE :: loadso4(:) 
      !$OMP THREADPRIVATE(loadso4) 
      REAL, SAVE, ALLOCATABLE :: loadoa(:) 
      !$OMP THREADPRIVATE(loadoa) 
      REAL, SAVE, ALLOCATABLE :: loadbc(:) 
      !$OMP THREADPRIVATE(loadbc) 
      REAL, SAVE, ALLOCATABLE :: loadss(:) 
      !$OMP THREADPRIVATE(loadss) 
      REAL, SAVE, ALLOCATABLE :: loaddust(:) 
      !$OMP THREADPRIVATE(loaddust) 
      REAL, SAVE, ALLOCATABLE :: loadno3(:) 
      !$OMP THREADPRIVATE(loadno3) 
      REAL, SAVE, ALLOCATABLE :: load_tmp1(:), load_tmp2(:)
      !$OMP THREADPRIVATE(load_tmp1, load_tmp2) 
      REAL, SAVE, ALLOCATABLE :: load_tmp3(:), load_tmp4(:)
      !$OMP THREADPRIVATE(load_tmp3, load_tmp4) 
      REAL, SAVE, ALLOCATABLE :: load_tmp5(:), load_tmp6(:)
      !$OMP THREADPRIVATE(load_tmp5, load_tmp6) 
      REAL, SAVE, ALLOCATABLE :: load_tmp7(:), load_tmp8(:)
      !$OMP THREADPRIVATE(load_tmp7, load_tmp8) 
      REAL, SAVE, ALLOCATABLE :: load_tmp9(:), load_tmp10(:)
      !$OMP THREADPRIVATE(load_tmp9, load_tmp10) 

!IM ajout variables CFMIP2/CMIP5
      REAL,ALLOCATABLE,SAVE :: topswad_aerop(:), solswad_aerop(:)
!$OMP THREADPRIVATE(topswad_aerop, solswad_aerop)
      REAL,ALLOCATABLE,SAVE :: topswai_aerop(:), solswai_aerop(:)
!$OMP THREADPRIVATE(topswai_aerop, solswai_aerop)
      REAL,ALLOCATABLE,SAVE :: topswad0_aerop(:), solswad0_aerop(:)
!$OMP THREADPRIVATE(topswad0_aerop, solswad0_aerop)
      REAL,ALLOCATABLE,SAVE :: topsw_aerop(:,:), topsw0_aerop(:,:)  
!$OMP THREADPRIVATE(topsw_aerop, topsw0_aerop)
      REAL,ALLOCATABLE,SAVE :: solsw_aerop(:,:), solsw0_aerop(:,:)
!$OMP THREADPRIVATE(solsw_aerop, solsw0_aerop)
      REAL,ALLOCATABLE,SAVE :: topswcf_aerop(:,:), solswcf_aerop(:,:)
!$OMP THREADPRIVATE(topswcf_aerop, solswcf_aerop)

! additional LW variables CK
      REAL,ALLOCATABLE,SAVE :: toplwad_aerop(:), sollwad_aerop(:)
!$OMP THREADPRIVATE(toplwad_aerop, sollwad_aerop)
      REAL,ALLOCATABLE,SAVE :: toplwai_aerop(:), sollwai_aerop(:)
!$OMP THREADPRIVATE(toplwai_aerop, sollwai_aerop)
      REAL,ALLOCATABLE,SAVE :: toplwad0_aerop(:), sollwad0_aerop(:)
!$OMP THREADPRIVATE(toplwad0_aerop, sollwad0_aerop)

!AI 08 2023 ajout pour Ecrad
      REAL,ALLOCATABLE,SAVE :: topswad_aero_s2(:), solswad_aero_s2(:)
!$OMP THREADPRIVATE(topswad_aero_s2, solswad_aero_s2)
      REAL,ALLOCATABLE,SAVE :: topswai_aero_s2(:), solswai_aero_s2(:)
!$OMP THREADPRIVATE(topswai_aero_s2, solswai_aero_s2)
      REAL,ALLOCATABLE,SAVE :: topswad0_aero_s2(:), solswad0_aero_s2(:)
!$OMP THREADPRIVATE(topswad0_aero_s2, solswad0_aero_s2)
      REAL,ALLOCATABLE,SAVE :: topsw_aero_s2(:,:), topsw0_aero_s2(:,:)
!$OMP THREADPRIVATE(topsw_aero_s2, topsw0_aero_s2)
      REAL,ALLOCATABLE,SAVE :: solsw_aero_s2(:,:), solsw0_aero_s2(:,:)
!$OMP THREADPRIVATE(solsw_aero_s2, solsw0_aero_s2)
      REAL,ALLOCATABLE,SAVE :: topswcf_aero_s2(:,:), solswcf_aero_s2(:,:)
!$OMP THREADPRIVATE(topswcf_aero_s2, solswcf_aero_s2)
! additional LW variables CK
      REAL,ALLOCATABLE,SAVE :: toplwad_aero_s2(:), sollwad_aero_s2(:)
!$OMP THREADPRIVATE(toplwad_aero_s2, sollwad_aero_s2)
      REAL,ALLOCATABLE,SAVE :: toplwai_aero_s2(:), sollwai_aero_s2(:)
!$OMP THREADPRIVATE(toplwai_aero_s2, sollwai_aero_s2)
      REAL,ALLOCATABLE,SAVE :: toplwad0_aero_s2(:), sollwad0_aero_s2(:)
!$OMP THREADPRIVATE(toplwad0_aero_s2, sollwad0_aero_s2)

!Ajout de celles n??cessaires au phys_output_write_mod
      REAL, SAVE, ALLOCATABLE :: tal1(:), pal1(:), pab1(:), pab2(:)
!$OMP THREADPRIVATE(tal1, pal1, pab1, pab2)
      REAL, SAVE, ALLOCATABLE :: ptstar(:), pt0(:), slp(:)
!$OMP THREADPRIVATE(ptstar, pt0, slp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: sens, flwp, fiwp 
!$OMP THREADPRIVATE(sens, flwp, fiwp)
!!
!FC 
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: zxfluxt, zxfluxq
!$OMP THREADPRIVATE(zxfluxt, zxfluxq)
!FC
!!         Wake variables
      REAL,ALLOCATABLE,SAVE,DIMENSION(:)            :: alp_wake
!$OMP THREADPRIVATE(alp_wake)           
!!jyg!      REAL,ALLOCATABLE,SAVE,DIMENSION(:)            :: wake_h,wake_k
      REAL,ALLOCATABLE,SAVE,DIMENSION(:)            :: wake_h
      INTEGER,ALLOCATABLE,SAVE,DIMENSION(:)         :: wake_k
!$OMP THREADPRIVATE(wake_h,wake_k)                       
    REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)            :: wake_omg
!$OMP THREADPRIVATE(wake_omg)                     
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:)          :: d_deltat_wk, d_deltaq_wk
!$OMP THREADPRIVATE(d_deltat_wk, d_deltaq_wk)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:)            :: d_s_wk, d_dens_a_wk, d_dens_wk
!$OMP THREADPRIVATE(d_s_wk, d_dens_a_wk, d_dens_wk)
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:)          :: d_deltat_wk_gw, d_deltaq_wk_gw
!$OMP THREADPRIVATE(d_deltat_wk_gw, d_deltaq_wk_gw)
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:)          :: d_deltat_vdf, d_deltaq_vdf
!$OMP THREADPRIVATE(d_deltat_vdf, d_deltaq_vdf)
!!!      REAL,ALLOCATABLE,SAVE,DIMENSION(:)          :: d_s_vdf, d_dens_vdf
!!!OMP THREADPRIVATE(d_s_vdf, d_dens_vdf)
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:)          :: d_deltat_the, d_deltaq_the
!$OMP THREADPRIVATE(d_deltat_the, d_deltaq_the)
!!!      REAL,ALLOCATABLE,SAVE,DIMENSION(:)          :: d_s_the, d_dens_the
!!!OMP THREADPRIVATE(d_s_the, d_dens_the)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)           :: d_deltat_ajs_cv, d_deltaq_ajs_cv
!$OMP THREADPRIVATE(d_deltat_ajs_cv, d_deltaq_ajs_cv)                       
#ifdef ISO
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:,:)          :: d_deltaxt_wk
!$OMP THREADPRIVATE(d_deltaxt_wk)
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:,:)          :: d_deltaxt_wk_gw
!$OMP THREADPRIVATE(d_deltaxt_wk_gw)
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:,:)          ::  d_deltaxt_the
!$OMP THREADPRIVATE(d_deltaxt_the)
    REAL, SAVE, ALLOCATABLE,DIMENSION(:,:,:)          ::  d_deltaxt_vdf
!$OMP THREADPRIVATE(d_deltaxt_vdf)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)           ::  d_deltaxt_ajs_cv
!$OMP THREADPRIVATE(d_deltaxt_ajs_cv)
#endif                       
!!         End of Wake variables
!!
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: bils
!$OMP THREADPRIVATE(bils)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cdragm, cdragh
!$OMP THREADPRIVATE(cdragm, cdragh)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cldh, cldl, cldm, cldq, cldt, qsat2m
!$OMP THREADPRIVATE(cldh, cldl, cldm, cldq, cldt, qsat2m)
!AS: cldhjn, cldljn, cldmjn,cldtjn pas utilisés en tant que variables, juste noms de diagnostics
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: JrNt
!$OMP THREADPRIVATE(JrNt)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: dthmin, evap, snowerosion, fder, plcl, plfc, prw, prlw, prsw, prbsw, water_budget
!$OMP THREADPRIVATE(dthmin, evap, snowerosion, fder, plcl, plfc, prw, prlw, prsw, prbsw, water_budget)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zustar, zu10m, zv10m, rh2m
!$OMP THREADPRIVATE(zustar, zu10m, zv10m, rh2m)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: s_lcl, s_pblh, s_pblt, s_therm
!$OMP THREADPRIVATE(s_lcl, s_pblh, s_pblt, s_therm)
!
!nrlmd+jyg<
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: s_pblh_x, s_pblh_w
!$OMP THREADPRIVATE(s_pblh_x, s_pblh_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: s_lcl_x, s_lcl_w
!$OMP THREADPRIVATE(s_lcl_x, s_lcl_w)
!>nrlmd+jyg
!
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: slab_wfbils
!$OMP THREADPRIVATE(slab_wfbils)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: tpot, tpote, ue, uq, uwat, ve, vq, vwat, zxffonte
!$OMP THREADPRIVATE(tpot, tpote, ue, uq, uwat, ve, vq, vwat, zxffonte)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxustartlic, zxrhoslic, zxqsaltlic
!$OMP THREADPRIVATE(zxustartlic, zxrhoslic, zxqsaltlic)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxfqcalving
!$OMP THREADPRIVATE(zxfqcalving)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxfluxlat, zxtsol, snow_lsc, zxfqfonte
!$OMP THREADPRIVATE(zxfluxlat, zxtsol, snow_lsc, zxfqfonte)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxrunofflic
!$OMP THREADPRIVATE(zxrunofflic)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxqsurf, rain_lsc, rain_num
!$OMP THREADPRIVATE(zxqsurf, rain_lsc, rain_num)
#ifdef ISO
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: xtevap,xtprw
!$OMP THREADPRIVATE(xtevap,xtprw)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: h1_diag,runoff_diag
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: xtrunoff_diag
!$OMP THREADPRIVATE(h1_diag,runoff_diag,xtrunoff_diag)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: zxfxtcalving
!$OMP THREADPRIVATE(zxfxtcalving)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: xtsnow_lsc, zxfxtfonte
!$OMP THREADPRIVATE(xtsnow_lsc, zxfxtfonte)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: zxxtrunofflic
!$OMP THREADPRIVATE(zxxtrunofflic)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: xtrain_lsc
!$OMP THREADPRIVATE(xtrain_lsc)
#endif
!
!jyg+nrlmd<
!!!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!                                                                          c
!       Declarations liees a la couche limite differentiee w-x             c
!                                                                          c
!!!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: sens_x, sens_w
!$OMP THREADPRIVATE(sens_x, sens_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zxfluxlat_x, zxfluxlat_w
!$OMP THREADPRIVATE(zxfluxlat_x, zxfluxlat_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: delta_qsurf
!$OMP THREADPRIVATE(delta_qsurf)
!jyg<
!!! Entrees supplementaires couche-limite
!!      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: t_x, t_w
!!!$OMP THREADPRIVATE(t_x, t_w)
!!      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: q_x, q_w
!!!$OMP THREADPRIVATE(q_x, q_w)
!>jyg
!!! Sorties ferret
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: dtvdf_x, dtvdf_w
!$OMP THREADPRIVATE(dtvdf_x, dtvdf_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: dqvdf_x, dqvdf_w
!$OMP THREADPRIVATE(dqvdf_x, dqvdf_w)
! Variables supplementaires dans physiq.F relative au splitting de la surface
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: pbl_tke_input
!$OMP THREADPRIVATE(pbl_tke_input)
! Entree supplementaire Thermiques :
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: t_therm, q_therm, u_therm, v_therm
!$OMP THREADPRIVATE(t_therm, q_therm, u_therm, v_therm)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cdragh_x, cdragh_w
!$OMP THREADPRIVATE(cdragh_x, cdragh_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: cdragm_x, cdragm_w
!$OMP THREADPRIVATE(cdragm_x, cdragm_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: kh, kh_x, kh_w
!$OMP THREADPRIVATE(kh, kh_x, kh_w)
#ifdef ISO
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: dxtvdf_x, dxtvdf_w
!$OMP THREADPRIVATE(dxtvdf_x, dxtvdf_w)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: xt_therm
!$OMP THREADPRIVATE(xt_therm)
#endif
!!!
!!!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      LOGICAL, SAVE, ALLOCATABLE :: ptconv(:,:)
      !$OMP THREADPRIVATE(ptconv)
      REAL, SAVE, ALLOCATABLE :: ratqsc(:,:)
      !$OMP THREADPRIVATE(ratqsc)
!>jyg+nrlmd
  !
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: wbeff, convoccur, zmax_th, zq2m, zt2m
!$OMP THREADPRIVATE(wbeff, convoccur, zmax_th, zq2m, zt2m)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: zt2m_min_mon, zt2m_max_mon
!$OMP THREADPRIVATE(zt2m_min_mon, zt2m_max_mon)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: t2m_min_mon, t2m_max_mon
!$OMP THREADPRIVATE(t2m_min_mon, t2m_max_mon)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: weak_inversion
!$OMP THREADPRIVATE(weak_inversion)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: alp_bl_conv,alp_bl_det
!$OMP THREADPRIVATE(alp_bl_conv,alp_bl_det)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: alp_bl_fluct_m,alp_bl_fluct_tke
!$OMP THREADPRIVATE(alp_bl_fluct_m,alp_bl_fluct_tke)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: alp_bl_stat, n2, s2, strig, zcong, zlcl_th
!$OMP THREADPRIVATE(alp_bl_stat, n2, s2, strig, zcong, zlcl_th)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: proba_notrig, random_notrig
!$OMP THREADPRIVATE(proba_notrig, random_notrig)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: fsolsw, wfbils
!$OMP THREADPRIVATE(fsolsw, wfbils)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: wfevap
!$OMP THREADPRIVATE(wfevap)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: t2m, fluxlat, fsollw,evap_pot
!$OMP THREADPRIVATE(t2m, fluxlat, fsollw,evap_pot)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: dnwd0, omega
!$OMP THREADPRIVATE(dnwd0, omega)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:) :: epmax_diag ! epmax_cape
!$OMP THREADPRIVATE(epmax_diag)
!
!  Deep convective variables used in phytrac
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: ep ! epmax_cape
!$OMP THREADPRIVATE(ep)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: dnwd, upwd
!$OMP THREADPRIVATE(dnwd, upwd)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: pmflxr, pmflxs
!$OMP THREADPRIVATE(pmflxr, pmflxs)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: wdtrainA, wdtrainS, wdtrainM
!$OMP THREADPRIVATE(wdtrainA, wdtrainS, wdtrainM)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: da, mp
!$OMP THREADPRIVATE(da, mp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: wght_cvfd
!$OMP THREADPRIVATE(wght_cvfd)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:):: phi, phi2, elij, epmlmMm
!$OMP THREADPRIVATE(phi, phi2, elij, epmlmMm)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: d1a, dam
!$OMP THREADPRIVATE(d1a, dam)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: ev
!$OMP THREADPRIVATE(ev)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: qtaa
!$OMP THREADPRIVATE(qtaa)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: clw
!$OMP THREADPRIVATE(clw)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: eplaMm
!$OMP THREADPRIVATE(eplaMm)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:):: sij
!$OMP THREADPRIVATE(sij)
#ifdef ISO
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xtwdtrainA
!$OMP THREADPRIVATE(xtwdtrainA)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xtev
!$OMP THREADPRIVATE(xtev)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xttaa
!$OMP THREADPRIVATE(xttaa)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xtclw
!$OMP THREADPRIVATE(xtclw)
#ifdef DIAGISO
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: qlp
!$OMP THREADPRIVATE(qlp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: qvp
!$OMP THREADPRIVATE(qvp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: fq_detrainement
!$OMP THREADPRIVATE(fq_detrainement)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: fq_ddft
!$OMP THREADPRIVATE(fq_ddft)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: fq_fluxmasse
!$OMP THREADPRIVATE(fq_fluxmasse)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: fq_evapprecip
!$OMP THREADPRIVATE(fq_evapprecip)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: f_detrainement
!$OMP THREADPRIVATE(f_detrainement)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: q_detrainement
!$OMP THREADPRIVATE(q_detrainement)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xt_detrainement
!$OMP THREADPRIVATE(xt_detrainement)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xtlp
!$OMP THREADPRIVATE(xtlp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xtvp
!$OMP THREADPRIVATE(xtvp)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:)  :: q_the
!$OMP THREADPRIVATE(q_the)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: xt_the
!$OMP THREADPRIVATE(xt_the)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: fxt_detrainement
!$OMP THREADPRIVATE(fxt_detrainement)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: fxt_ddft
!$OMP THREADPRIVATE(fxt_ddft)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: fxt_fluxmasse
!$OMP THREADPRIVATE(fxt_fluxmasse)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:)  :: fxt_evapprecip
!$OMP THREADPRIVATE(fxt_evapprecip)
#endif
#endif
!
!      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: coefh, coefm, lambda_th
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: lambda_th
!$OMP THREADPRIVATE(lambda_th)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: cldemi, cldfra, cldtau, fiwc, fl, re, flwc
!$OMP THREADPRIVATE(cldemi, cldfra, cldtau, fiwc, fl, re, flwc)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: qlth, qith, qsith, wiceth
!$OMP THREADPRIVATE(qlth, qith, qsith, wiceth)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: ref_liq, ref_ice, theta, zphi
!$OMP THREADPRIVATE(ref_liq, ref_ice, theta, zphi)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: ref_liq_pi, ref_ice_pi
!$OMP THREADPRIVATE(ref_liq_pi, ref_ice_pi)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: zx_rh, zx_rhl, zx_rhi
!$OMP THREADPRIVATE(zx_rh, zx_rhl, zx_rhi)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: prfl, psfl, fraca, bsfl
!$OMP THREADPRIVATE(prfl, psfl, fraca, bsfl)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: Vprecip, zw2
!$OMP THREADPRIVATE(Vprecip, zw2)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: pmfd, pmfu
!$OMP THREADPRIVATE(pmfd, pmfu)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: fluxt, fluxu, fluxv
!$OMP THREADPRIVATE(fluxt, fluxu, fluxv)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: uwriteSTD, vwriteSTD, wwriteSTD
!$OMP THREADPRIVATE(uwriteSTD, vwriteSTD, wwriteSTD)
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: phiwriteSTD, qwriteSTD, twriteSTD, rhwriteSTD
!$OMP THREADPRIVATE(phiwriteSTD, qwriteSTD, twriteSTD, rhwriteSTD)


! ug et d'autres encore:
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:) :: beta_prec
!$OMP THREADPRIVATE(beta_prec)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: rneb,rnebjn,rneblsvol
!$OMP THREADPRIVATE(rneb,rnebjn,rneblsvol)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: pfraclr,pfracld
!$OMP THREADPRIVATE(pfraclr,pfracld)
      REAL, SAVE, ALLOCATABLE :: cldfraliq(:,:)
!$OMP THREADPRIVATE(cldfraliq)
      REAL, SAVE, ALLOCATABLE ::mean_icefracturb(:,:)
!$OMP THREADPRIVATE(mean_icefracturb)
      REAL, SAVE, ALLOCATABLE :: sigma2_icefracturb(:,:)
!$OMP THREADPRIVATE(sigma2_icefracturb)

! variables de sorties MM
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: zxsnow,snowhgt,qsnow,to_ice
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: sissnow,runoff,albsol3_lic
!$OMP THREADPRIVATE(zxsnow,snowhgt,qsnow,to_ice)
!$OMP THREADPRIVATE(sissnow,runoff,albsol3_lic)
#ifdef ISO
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: zxxtsnow
!$OMP THREADPRIVATE(zxxtsnow)     
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: xtVprecip,xtVprecipi
!$OMP THREADPRIVATE(xtVprecip,xtVprecipi) 
      REAL,ALLOCATABLE,SAVE,DIMENSION(:,:,:) :: pxtrfl, pxtsfl
!$OMP THREADPRIVATE(pxtrfl, pxtsfl) 
#endif

      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: p_tropopause, z_tropopause, t_tropopause
!$OMP THREADPRIVATE(p_tropopause, z_tropopause, t_tropopause)

      INTEGER,ALLOCATABLE,SAVE,DIMENSION(:,:) :: zn2mout
!$OMP THREADPRIVATE(zn2mout)

      REAL, SAVE, ALLOCATABLE :: qclr(:,:)
      !$OMP THREADPRIVATE(qclr)
      REAL, SAVE, ALLOCATABLE :: qcld(:,:)
      !$OMP THREADPRIVATE(qcld)
      REAL, SAVE, ALLOCATABLE :: qss(:,:)
      !$OMP THREADPRIVATE(qss)
      REAL, SAVE, ALLOCATABLE :: qvc(:,:)
      !$OMP THREADPRIVATE(qvc)
      REAL, SAVE, ALLOCATABLE :: rnebclr(:,:)
      !$OMP THREADPRIVATE(rnebclr)
      REAL, SAVE, ALLOCATABLE :: rnebss(:,:)
      !$OMP THREADPRIVATE(rnebss)
      REAL, SAVE, ALLOCATABLE :: gamma_ss(:,:)
      !$OMP THREADPRIVATE(gamma_ss)
      REAL, SAVE, ALLOCATABLE :: N1_ss(:,:)
      !$OMP THREADPRIVATE(N1_ss)
      REAL, SAVE, ALLOCATABLE :: N2_ss(:,:)
      !$OMP THREADPRIVATE(N2_ss)
      REAL, SAVE, ALLOCATABLE :: drneb_sub(:,:)
      !$OMP THREADPRIVATE(drneb_sub)
      REAL, SAVE, ALLOCATABLE :: drneb_con(:,:)
      !$OMP THREADPRIVATE(drneb_con)
      REAL, SAVE, ALLOCATABLE :: drneb_tur(:,:)
      !$OMP THREADPRIVATE(drneb_tur)
      REAL, SAVE, ALLOCATABLE :: drneb_avi(:,:)
      !$OMP THREADPRIVATE(drneb_avi)
      REAL, SAVE, ALLOCATABLE :: zqsatl(:,:)
      !$OMP THREADPRIVATE(zqsatl)
      REAL, SAVE, ALLOCATABLE :: zqsats(:,:)
      !$OMP THREADPRIVATE(zqsats)
      REAL, SAVE, ALLOCATABLE :: Tcontr(:,:)
      !$OMP THREADPRIVATE(Tcontr)
      REAL, SAVE, ALLOCATABLE :: qcontr(:,:)
      !$OMP THREADPRIVATE(qcontr)
      REAL, SAVE, ALLOCATABLE :: qcontr2(:,:)
      !$OMP THREADPRIVATE(qcontr2)
      REAL, SAVE, ALLOCATABLE :: fcontrN(:,:)
      !$OMP THREADPRIVATE(fcontrN)
      REAL, SAVE, ALLOCATABLE :: fcontrP(:,:)
      !$OMP THREADPRIVATE(fcontrP)
      REAL, SAVE, ALLOCATABLE :: distcltop(:,:)
      !$OMP THREADPRIVATE(distcltop)
      REAL, SAVE, ALLOCATABLE :: temp_cltop(:,:)
      !$OMP THREADPRIVATE(temp_cltop)


!--POPRECIP variables
      REAL, SAVE, ALLOCATABLE :: qraindiag(:,:)
      !$OMP THREADPRIVATE(qraindiag)
      REAL, SAVE, ALLOCATABLE :: qsnowdiag(:,:)
      !$OMP THREADPRIVATE(qsnowdiag)
      REAL, SAVE, ALLOCATABLE :: dqreva(:,:)
      !$OMP THREADPRIVATE(dqreva)
      REAL, SAVE, ALLOCATABLE :: dqrauto(:,:)
      !$OMP THREADPRIVATE(dqrauto)
      REAL, SAVE, ALLOCATABLE :: dqrcol(:,:)
      !$OMP THREADPRIVATE(dqrcol)
      REAL, SAVE, ALLOCATABLE :: dqrmelt(:,:)
      !$OMP THREADPRIVATE(dqrmelt)
       REAL, SAVE, ALLOCATABLE :: dqrfreez(:,:)
      !$OMP THREADPRIVATE(dqrfreez)
      REAL, SAVE, ALLOCATABLE :: dqssub(:,:)
      !$OMP THREADPRIVATE(dqssub)
      REAL, SAVE, ALLOCATABLE :: dqsauto(:,:)
      !$OMP THREADPRIVATE(dqsauto)
      REAL, SAVE, ALLOCATABLE :: dqsagg(:,:)
      !$OMP THREADPRIVATE(dqsagg)
      REAL, SAVE, ALLOCATABLE :: dqsrim(:,:)
      !$OMP THREADPRIVATE(dqsrim)
      REAL, SAVE, ALLOCATABLE :: dqsmelt(:,:)
      !$OMP THREADPRIVATE(dqsmelt)
      REAL, SAVE, ALLOCATABLE :: dqsfreez(:,:)
      !$OMP THREADPRIVATE(dqsfreez)


      


#ifdef CPP_StratAer
!
! variables for stratospheric aerosol
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: d_q_emiss
!$OMP THREADPRIVATE(d_q_emiss)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: R2SO4
!$OMP THREADPRIVATE(R2SO4)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: DENSO4
!$OMP THREADPRIVATE(DENSO4)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: f_r_wet
!$OMP THREADPRIVATE(f_r_wet)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: decfluxaer
!$OMP THREADPRIVATE(decfluxaer)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: mdw
!$OMP THREADPRIVATE(mdw)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: OCS_lifetime
!$OMP THREADPRIVATE(OCS_lifetime)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: SO2_lifetime
!$OMP THREADPRIVATE(SO2_lifetime)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: H2SO4_lifetime
!$OMP THREADPRIVATE(H2SO4_lifetime)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: O3_clim
!$OMP THREADPRIVATE(O3_clim)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: alpha_bin
!$OMP THREADPRIVATE(alpha_bin)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: piz_bin
!$OMP THREADPRIVATE(piz_bin)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: cg_bin
!$OMP THREADPRIVATE(cg_bin)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: tau_strat_550
!$OMP THREADPRIVATE(tau_strat_550)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: tau_strat_1020
!$OMP THREADPRIVATE(tau_strat_1020)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: tausum_strat
!$OMP THREADPRIVATE(tausum_strat)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: surf_PM25_sulf
!$OMP THREADPRIVATE(surf_PM25_sulf)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: vsed_aer
!$OMP THREADPRIVATE(vsed_aer)
!
!---3D budget variables
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: budg_3D_nucl
!$OMP THREADPRIVATE(budg_3D_nucl)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: budg_3D_cond_evap
!$OMP THREADPRIVATE(budg_3D_cond_evap)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: budg_3D_ocs_to_so2
!$OMP THREADPRIVATE(budg_3D_ocs_to_so2)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: budg_3D_so2_to_h2so4
!$OMP THREADPRIVATE(budg_3D_so2_to_h2so4)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: budg_3D_backgr_ocs
!$OMP THREADPRIVATE(budg_3D_backgr_ocs)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:,:) :: budg_3D_backgr_so2
!$OMP THREADPRIVATE(budg_3D_backgr_so2)
!
!---2D budget variables
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_dry_ocs
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_dry_so2
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_dry_h2so4
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_dry_part
!$OMP THREADPRIVATE(budg_dep_dry_ocs,budg_dep_dry_so2,budg_dep_dry_h2so4,budg_dep_dry_part)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_wet_ocs
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_wet_so2
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_wet_h2so4
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_dep_wet_part
!$OMP THREADPRIVATE(budg_dep_wet_ocs,budg_dep_wet_so2,budg_dep_wet_h2so4,budg_dep_wet_part)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_emi_ocs
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_emi_so2
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_emi_h2so4
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_emi_part
!$OMP THREADPRIVATE(budg_emi_ocs,budg_emi_so2,budg_emi_h2so4,budg_emi_part)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_ocs_to_so2
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_so2_to_h2so4
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_h2so4_to_part
!$OMP THREADPRIVATE(budg_ocs_to_so2,budg_so2_to_h2so4,budg_h2so4_to_part)
      REAL, ALLOCATABLE, SAVE, DIMENSION(:) :: budg_sed_part
!$OMP THREADPRIVATE(budg_sed_part)
#endif
#ifdef REPROBUS
      REAL,SAVE,ALLOCATABLE    :: d_q_emiss(:,:)
!$OMP THREADPRIVATE(d_q_emiss)
#endif

CONTAINS

!======================================================================
SUBROUTINE phys_local_var_init
USE dimphy
USE infotrac_phy, ONLY : nbtr,nqtot
#ifdef ISO
USE infotrac_phy, ONLY : ntraciso=>ntiso,niso
#endif
USE aero_mod
USE indice_sol_mod
USE phys_output_var_mod
USE phys_state_var_mod

IMPLICIT NONE
      ALLOCATE(t_seri(klon,klev),q_seri(klon,klev),ql_seri(klon,klev),qs_seri(klon,klev), qbs_seri(klon,klev))
      ALLOCATE(qx_seri(klon,klev,nqtot))
      ALLOCATE(u_seri(klon,klev),v_seri(klon,klev))
      ALLOCATE(l_mixmin(klon,klev+1,nbsrf),l_mix(klon,klev+1,nbsrf),wprime(klon,klev+1,nbsrf))
      ALLOCATE(pbl_eps(klon,klev+1,nbsrf+1))
      ALLOCATE(tke_shear(klon,klev+1,nbsrf), tke_buoy(klon,klev+1,nbsrf), tke_trans(klon,klev+1,nbsrf))
      pbl_eps(:,:,:)=0.
      tke_shear(:,:,:)=0.; tke_buoy(:,:,:)=0.; tke_trans(:,:,:)=0.
      l_mix(:,:,:)=0.;l_mixmin(:,:,:)=0.;wprime(:,:,:)=0. ! doit etre initialse car pas toujours remplis
      ALLOCATE(rhcl(klon,klev))
      ALLOCATE(tr_seri(klon,klev,nbtr))
      ALLOCATE(d_t_dyn(klon,klev),d_q_dyn(klon,klev))
      ALLOCATE(d_ql_dyn(klon,klev),d_qs_dyn(klon,klev), d_qbs_dyn(klon,klev))
      ALLOCATE(d_q_dyn2d(klon),d_ql_dyn2d(klon),d_qs_dyn2d(klon), d_qbs_dyn2d(klon))
      ALLOCATE(d_u_dyn(klon,klev),d_v_dyn(klon,klev))
      ALLOCATE(d_tr_dyn(klon,klev,nbtr))                   !RomP
      ALLOCATE(d_t_con(klon,klev),d_q_con(klon,klev),d_q_con_zmasse(klon,klev))
      ALLOCATE(d_u_con(klon,klev),d_v_con(klon,klev))
      ALLOCATE(d_t_wake(klon,klev),d_q_wake(klon,klev))
      ALLOCATE(d_t_lsc(klon,klev),d_q_lsc(klon,klev))
      ALLOCATE(d_t_lwr(klon,klev),d_t_lw0(klon,klev))
      ALLOCATE(d_t_swr(klon,klev),d_t_sw0(klon,klev))
      ALLOCATE(d_ql_lsc(klon,klev),d_qi_lsc(klon,klev))
      ALLOCATE(d_t_ajsb(klon,klev),d_q_ajsb(klon,klev))
      ALLOCATE(d_t_ajs(klon,klev),d_q_ajs(klon,klev))
!nrlmd<
      ALLOCATE(d_t_ajs_w(klon,klev),d_q_ajs_w(klon,klev))
      ALLOCATE(d_t_ajs_x(klon,klev),d_q_ajs_x(klon,klev))
!>nrlmd
      ALLOCATE(d_u_ajs(klon,klev),d_v_ajs(klon,klev))
      ALLOCATE(d_t_eva(klon,klev),d_q_eva(klon,klev))
      ALLOCATE(d_qx_eva(klon,klev,nqtot))
      ALLOCATE(d_ql_eva(klon,klev),d_qi_eva(klon,klev))
      ALLOCATE(d_t_lscst(klon,klev),d_q_lscst(klon,klev))
      ALLOCATE(d_t_lscth(klon,klev),d_q_lscth(klon,klev))
      ALLOCATE(plul_st(klon),plul_th(klon))
      ALLOCATE(d_t_vdf(klon,klev),d_q_vdf(klon,klev),d_t_diss(klon,klev))
      ALLOCATE (d_qbs_vdf(klon,klev))
      ALLOCATE(d_t_bsss(klon,klev),d_q_bsss(klon,klev),d_qbs_bsss(klon,klev))
      ALLOCATE(d_t_vdf_w(klon,klev),d_q_vdf_w(klon,klev))
      ALLOCATE(d_t_vdf_x(klon,klev),d_q_vdf_x(klon,klev))
#ifdef ISO
      allocate(xt_seri(ntraciso,klon,klev))
      allocate(xtl_seri(ntraciso,klon,klev))
      allocate(xts_seri(ntraciso,klon,klev))
      allocate(xtbs_seri(ntraciso,klon,klev))
      allocate(d_xt_dyn(ntraciso,klon,klev))
      allocate(d_xtl_dyn(ntraciso,klon,klev))
      allocate(d_xts_dyn(ntraciso,klon,klev))
      allocate(d_xtbs_dyn(ntraciso,klon,klev))
      allocate(d_xt_con(ntraciso,klon,klev))
      allocate(d_xt_wake(ntraciso,klon,klev))
      allocate(d_xt_lsc(ntraciso,klon,klev))
      allocate(d_xtl_lsc(ntraciso,klon,klev))
      allocate(d_xti_lsc(ntraciso,klon,klev))
      allocate(d_xt_ajsb(ntraciso,klon,klev))
      allocate(d_xt_ajs(ntraciso,klon,klev))
      allocate(d_xt_ajs_w(ntraciso,klon,klev))
      allocate(d_xt_ajs_x(ntraciso,klon,klev))
      allocate(d_xt_eva(ntraciso,klon,klev))
      allocate(d_xtl_eva(ntraciso,klon,klev))
      allocate(d_xti_eva(ntraciso,klon,klev))
      allocate(d_xt_vdf(ntraciso,klon,klev))  
      allocate(d_xt_vdf_w(ntraciso,klon,klev))
      allocate(d_xt_vdf_x(ntraciso,klon,klev))
      allocate(d_xt_ch4(ntraciso,klon,klev))
      allocate(d_xt_prod_nucl(ntraciso,klon,klev))
      allocate(d_xt_cosmo(ntraciso,klon,klev))
      allocate(d_xt_decroiss(ntraciso,klon,klev))
#endif

      ALLOCATE(d_u_vdf(klon,klev),d_v_vdf(klon,klev))
      ALLOCATE(d_t_oli(klon,klev),d_t_oro(klon,klev))
      ALLOCATE(d_u_oli(klon,klev),d_v_oli(klon,klev))
      ALLOCATE(d_u_oro(klon,klev),d_v_oro(klon,klev))
      ALLOCATE(d_u_oro_gw(klon,klev),d_v_oro_gw(klon,klev))
      ALLOCATE(d_t_oro_gw(klon,klev))
      ALLOCATE(d_t_lif(klon,klev),d_t_ec(klon,klev))
      ALLOCATE(d_u_lif(klon,klev),d_v_lif(klon,klev))
      ALLOCATE(d_ts(klon,nbsrf), d_tr(klon,klev,nbtr))

! aerosols
      ALLOCATE(m_allaer(klon,klev,naero_tot))
! Special RRTM
      ALLOCATE(ZLWFT0_i(klon,klev+1),ZSWFT0_i(klon,klev+1),ZFLDN0(klon,klev+1))
      ZFLDN0= 0.
      ALLOCATE(ZFLUP0(klon,klev+1),ZFSDN0(klon,klev+1),ZFSUP0(klon,klev+1))
!
      ALLOCATE(topswad_aero(klon), solswad_aero(klon))
      ALLOCATE(topswai_aero(klon), solswai_aero(klon))
      ALLOCATE(topswad0_aero(klon), solswad0_aero(klon))
      ALLOCATE(toplwad_aero(klon), sollwad_aero(klon))
      ALLOCATE(toplwai_aero(klon), sollwai_aero(klon))
      ALLOCATE(toplwad0_aero(klon), sollwad0_aero(klon))
      ALLOCATE(topsw_aero(klon,naero_grp), solsw_aero(klon,naero_grp))
      ALLOCATE(topsw0_aero(klon,naero_grp), solsw0_aero(klon,naero_grp))
      ALLOCATE(topswcf_aero(klon,3), solswcf_aero(klon,3))
      ALLOCATE(du_gwd_hines(klon,klev),dv_gwd_hines(klon,klev))
      ALLOCATE(dv_gwd_rando(klon,klev),dv_gwd_front(klon,klev))
      ALLOCATE(east_gwstress(klon,klev),west_gwstress(klon,klev))
      east_gwstress(:,:)=0 !ym missing init
      west_gwstress(:,:)=0 !ym missing init
      ALLOCATE(d_t_hin(klon,klev))
      ALLOCATE(d_q_ch4(klon,klev))
      ALLOCATE(stratomask(klon,klev))
      ALLOCATE(tausum_aero(klon,nwave,naero_tot))
      ALLOCATE(drytausum_aero(klon,naero_tot))
      ALLOCATE(tau3d_aero(klon,klev,nwave,naero_tot)) 
      ALLOCATE(dNovrN(klon))
      ALLOCATE(zfice(klon, klev))
      ALLOCATE(od443aer(klon))
      ALLOCATE(od550aer(klon))
      ALLOCATE(od865aer(klon))
      ALLOCATE(dryod550aer(klon))
      dryod550aer(:) = 0.
      ALLOCATE(abs550aer(klon))
      abs550aer(:) = 0.
      ALLOCATE(ec550aer(klon,klev))
      ALLOCATE(od550lt1aer(klon))
      ALLOCATE(sconcso4(klon))
      ALLOCATE(sconcno3(klon))
      ALLOCATE(sconcoa(klon))
      ALLOCATE(sconcbc(klon))
      ALLOCATE(sconcss(klon))
      ALLOCATE(sconcdust(klon))
      ALLOCATE(concso4(klon,klev))
      ALLOCATE(concno3(klon,klev))
      ALLOCATE(concoa(klon,klev))
      ALLOCATE(concbc(klon,klev))
      ALLOCATE(concss(klon,klev))
      ALLOCATE(concdust(klon,klev))
      ALLOCATE(loadso4(klon))
      ALLOCATE(loadoa(klon))
      ALLOCATE(loadbc(klon))
      ALLOCATE(loadss(klon))
      ALLOCATE(loaddust(klon))
      ALLOCATE(loadno3(klon))
      ALLOCATE(load_tmp1(klon))
      ALLOCATE(load_tmp2(klon))
      ALLOCATE(load_tmp3(klon))
      ALLOCATE(load_tmp4(klon))
      ALLOCATE(load_tmp5(klon))
      ALLOCATE(load_tmp6(klon))
      ALLOCATE(load_tmp7(klon))
      ALLOCATE(load_tmp8(klon))
      ALLOCATE(load_tmp9(klon))
      ALLOCATE(load_tmp10(klon))

!IM ajout variables CFMIP2/CMIP5
      ALLOCATE(topswad_aerop(klon), solswad_aerop(klon))
      ALLOCATE(topswai_aerop(klon), solswai_aerop(klon))
      ALLOCATE(topswad0_aerop(klon), solswad0_aerop(klon))
      ALLOCATE(topsw_aerop(klon,naero_grp), topsw0_aerop(klon,naero_grp))
      ALLOCATE(solsw_aerop(klon,naero_grp), solsw0_aerop(klon,naero_grp))
      ALLOCATE(topswcf_aerop(klon,naero_grp), solswcf_aerop(klon,naero_grp))

! additional LW variables CK
      ALLOCATE(toplwad_aerop(klon), sollwad_aerop(klon))
      ALLOCATE(toplwai_aerop(klon), sollwai_aerop(klon))
      ALLOCATE(toplwad0_aerop(klon), sollwad0_aerop(klon))

!AI Ajout Ecrad (3Deffect)
      ALLOCATE(topswad_aero_s2(klon), solswad_aero_s2(klon))
      ALLOCATE(topswai_aero_s2(klon), solswai_aero_s2(klon))
      ALLOCATE(topswad0_aero_s2(klon), solswad0_aero_s2(klon))
      ALLOCATE(topsw_aero_s2(klon,naero_grp), topsw0_aero_s2(klon,naero_grp))
      ALLOCATE(solsw_aero_s2(klon,naero_grp), solsw0_aero_s2(klon,naero_grp))
      ALLOCATE(topswcf_aero_s2(klon,naero_grp), solswcf_aero_s2(klon,naero_grp))
! additional LW variables CK
      ALLOCATE(toplwad_aero_s2(klon), sollwad_aero_s2(klon))
      ALLOCATE(toplwai_aero_s2(klon), sollwai_aero_s2(klon))
      ALLOCATE(toplwad0_aero_s2(klon), sollwad0_aero_s2(klon))

! FH Ajout de celles necessaires au phys_output_write_mod

      ALLOCATE(tal1(klon), pal1(klon), pab1(klon), pab2(klon))
      ALLOCATE(ptstar(klon),pt0(klon),slp(klon))
!!
!!          Wake variables
      ALLOCATE(alp_wake(klon))
      ALLOCATE(wake_h(klon),wake_k(klon))
      ALLOCATE(wake_omg(klon, klev))
      ALLOCATE(d_deltat_wk(klon, klev), d_deltaq_wk(klon, klev))
      ALLOCATE(d_s_wk(klon), d_dens_a_wk(klon), d_dens_wk(klon))
      ALLOCATE(d_deltat_wk_gw(klon, klev), d_deltaq_wk_gw(klon, klev))
      ALLOCATE(d_deltat_vdf(klon, klev), d_deltaq_vdf(klon, klev))
!!      ALLOCATE( d_s_vdf(klon), d_dens_vdf(klon))
      ALLOCATE(d_deltat_the(klon, klev), d_deltaq_the(klon, klev))
!!      ALLOCATE( d_s_the(klon), d_dens_the(klon))
      ALLOCATE(d_deltat_ajs_cv(klon, klev), d_deltaq_ajs_cv(klon, klev))
#ifdef ISO
      ALLOCATE(d_deltaxt_wk(ntraciso,klon, klev))
      ALLOCATE(d_deltaxt_wk_gw(ntraciso,klon, klev))
      ALLOCATE(d_deltaxt_the(ntraciso,klon, klev))
      ALLOCATE(d_deltaxt_vdf(ntraciso,klon, klev))
      ALLOCATE(d_deltaxt_ajs_cv(ntraciso,klon, klev))
#endif
!!         End of wake variables
!!
      ALLOCATE(bils(klon))
      ALLOCATE(cdragm(klon), cdragh(klon), cldh(klon), cldl(klon))
      ALLOCATE(cldm(klon), cldq(klon), cldt(klon), qsat2m(klon))
      ALLOCATE(JrNt(klon))
      ALLOCATE(dthmin(klon), evap(klon), snowerosion(klon), fder(klon), plcl(klon), plfc(klon))
      ALLOCATE(prw(klon), prlw(klon), prsw(klon), prbsw(klon), water_budget(klon), zustar(klon), zu10m(klon), zv10m(klon), rh2m(klon))
      ALLOCATE(s_lcl(klon))
      ALLOCATE(s_pblh(klon), s_pblt(klon), s_therm(klon))
!
!nrlmd+jyg<
      ALLOCATE(s_pblh_x(klon), s_pblh_w(klon))
      ALLOCATE(s_lcl_x(klon), s_lcl_w(klon))
!>nrlmd+jyg
!
      ALLOCATE(slab_wfbils(klon), tpot(klon), tpote(klon), ue(klon))
      ALLOCATE(uq(klon), ve(klon), vq(klon), zxffonte(klon))
      ALLOCATE(uwat(klon), vwat(klon))
      ALLOCATE(zxfqcalving(klon), zxfluxlat(klon))
      ALLOCATE(zxtsol(klon), snow_lsc(klon), zxfqfonte(klon), zxqsurf(klon))
      ALLOCATE(zxrunofflic(klon))
      ALLOCATE(zxustartlic(klon), zxrhoslic(klon), zxqsaltlic(klon))
      zxustartlic(:)=0. ; zxrhoslic(:)=0. ; zxqsaltlic(:)=0.
      ALLOCATE(rain_lsc(klon))
      ALLOCATE(rain_num(klon))
      ALLOCATE(qlth(klon,klev), qith(klon,klev), qsith(klon,klev), wiceth(klon,klev))
      !
#ifdef ISO
      ALLOCATE(xtevap(ntraciso,klon))
      ALLOCATE(xtprw(ntraciso,klon))
      ALLOCATE(zxfxtcalving(niso,klon))
      ALLOCATE(xtsnow_lsc(ntraciso,klon), zxfxtfonte(niso,klon)) 
      ALLOCATE(zxxtrunofflic(niso,klon)) 
      ALLOCATE(xtrain_lsc(ntraciso,klon))
      ALLOCATE(xtrunoff_diag(niso,klon))
      ALLOCATE(h1_diag(klon),runoff_diag(klon))
!SN
      runoff_diag(:)=0. ; xtrunoff_diag(:,:)=0. ! because variables are only given values on knon grid points
#endif
!
      ALLOCATE(sens_x(klon), sens_w(klon))
      ALLOCATE(zxfluxlat_x(klon), zxfluxlat_w(klon))
      ALLOCATE(delta_qsurf(klon))
!jyg<
!!      ALLOCATE(t_x(klon,klev), t_w(klon,klev))
!!      ALLOCATE(q_x(klon,klev), q_w(klon,klev))
!>jyg
      ALLOCATE(dtvdf_x(klon,klev), dtvdf_w(klon,klev))
      dtvdf_x = 0 ; dtvdf_w=0 ;   !ym missing init
      ALLOCATE(dqvdf_x(klon,klev), dqvdf_w(klon,klev))
      dqvdf_x = 0 ; dqvdf_w=0 ;   !ym missing init
      ALLOCATE(pbl_tke_input(klon,klev+1,nbsrf))
      ALLOCATE(t_therm(klon,klev), q_therm(klon,klev),u_therm(klon,klev), v_therm(klon,klev))
      ALLOCATE(cdragh_x(klon), cdragh_w(klon))
      ALLOCATE(cdragm_x(klon), cdragm_w(klon))
      ALLOCATE(kh(klon), kh_x(klon), kh_w(klon))
#ifdef ISO
      ALLOCATE(dxtvdf_x(ntraciso,klon,klev), dxtvdf_w(ntraciso,klon,klev))
      ALLOCATE(xt_therm(ntraciso,klon,klev))
#endif
!
      ALLOCATE(ptconv(klon,klev))
      ALLOCATE(ratqsc(klon,klev))
!
      ALLOCATE(wbeff(klon), convoccur(klon), zmax_th(klon))
      ALLOCATE(zq2m(klon), zt2m(klon), weak_inversion(klon))
      ALLOCATE(zt2m_min_mon(klon), zt2m_max_mon(klon))
      ALLOCATE(t2m_min_mon(klon), t2m_max_mon(klon))
      ALLOCATE(sens(klon), flwp(klon), fiwp(klon))
      ALLOCATE(alp_bl_conv(klon), alp_bl_det(klon))
      alp_bl_conv(:)=0 ;  alp_bl_det(:)=0
      ALLOCATE(alp_bl_fluct_m(klon), alp_bl_fluct_tke(klon))
      alp_bl_fluct_m(:)=0 ; alp_bl_fluct_tke(:)= 0.
      ALLOCATE(alp_bl_stat(klon), n2(klon), s2(klon), strig(klon), zcong(klon), zlcl_th(klon))
      alp_bl_stat(:)=0
      ALLOCATE(proba_notrig(klon), random_notrig(klon))

      ALLOCATE(dnwd0(klon, klev))
!      ALLOCATE(upwd(klon, klev), omega(klon, klev), coefh(klon, klev))
      ALLOCATE(omega(klon, klev))
      ALLOCATE(epmax_diag(klon)) ! epmax_cape
!      ALLOCATE(coefm(klon, klev), lambda_th(klon, klev), cldemi(klon, klev))
      ALLOCATE(lambda_th(klon, klev), cldemi(klon, klev))
      ALLOCATE(cldfra(klon, klev), cldtau(klon, klev), fiwc(klon, klev))
      ALLOCATE(fl(klon, klev), re(klon, klev), flwc(klon, klev))
      ALLOCATE(ref_liq(klon, klev), ref_ice(klon, klev), theta(klon, klev))
      ALLOCATE(ref_liq_pi(klon, klev), ref_ice_pi(klon, klev))
      ALLOCATE(zphi(klon, klev), zx_rh(klon, klev), zx_rhl(klon,klev), zx_rhi(klon,klev))
      zx_rhl(:,:)=0.; zx_rhi(:,:)=0. ! because not always defined
      ALLOCATE(pmfd(klon, klev), pmfu(klon, klev))

      ALLOCATE(t2m(klon, nbsrf), fluxlat(klon, nbsrf))
      ALLOCATE(fsollw(klon, nbsrf))
      ALLOCATE(fsolsw(klon, nbsrf), wfbils(klon, nbsrf))
      ALLOCATE(wfevap(klon, nbsrf))
      ALLOCATE(evap_pot(klon, nbsrf))
! FC 
      ALLOCATE(zxfluxq(klon,klev),zxfluxt(klon,klev))
!
!
!  Deep convective variables used in phytrac
      ALLOCATE(pmflxr(klon, klev+1), pmflxs(klon, klev+1))
      ALLOCATE(wdtrainA(klon,klev),wdtrainS(klon,klev),wdtrainM(klon,klev))
      ALLOCATE(dnwd(klon, klev), upwd(klon, klev))
      ALLOCATE(ep(klon,klev))                          ! epmax_cape
      ALLOCATE(da(klon,klev), mp(klon,klev))
      ALLOCATE(phi(klon,klev,klev))
      ALLOCATE(wght_cvfd(klon,klev))
      ALLOCATE(phi2(klon,klev,klev))
      ALLOCATE(d1a(klon,klev), dam(klon,klev))
      ALLOCATE(ev(klon,klev))
      ALLOCATE(elij(klon,klev,klev))
      ALLOCATE(qtaa(klon,klev))
      ALLOCATE(clw(klon,klev))
      ALLOCATE(epmlmMm(klon,klev,klev), eplaMm(klon,klev))
      ALLOCATE(sij(klon,klev,klev))
#ifdef ISO
      ALLOCATE(xtwdtrainA(ntraciso,klon,klev))
      ALLOCATE(xtev(ntraciso,klon,klev) )
      ALLOCATE(xttaa(ntraciso,klon,klev) )
      ALLOCATE(xtclw(ntraciso,klon,klev) )
#ifdef DIAGISO
      ALLOCATE(qlp(klon,klev))
      ALLOCATE(qvp(klon,klev))
      ALLOCATE(fq_detrainement(klon,klev))
      ALLOCATE(fq_ddft(klon,klev))
      ALLOCATE(fq_fluxmasse(klon,klev))
      ALLOCATE(fq_evapprecip(klon,klev))
      ALLOCATE(f_detrainement(klon,klev), q_detrainement(klon,klev))
      ALLOCATE(xtlp(ntraciso,klon,klev))
      ALLOCATE(xtvp(ntraciso,klon,klev))
      ALLOCATE(q_the(klon,klev), xt_the(ntraciso,klon,klev))
      ALLOCATE(fxt_detrainement(ntraciso,klon,klev))
      ALLOCATE(fxt_ddft(ntraciso,klon,klev))
      ALLOCATE(fxt_fluxmasse(ntraciso,klon,klev))
      ALLOCATE(fxt_evapprecip(ntraciso,klon,klev))
      ALLOCATE(xt_detrainement(ntraciso,klon,klev))
#endif
#endif

      ALLOCATE(prfl(klon, klev+1))
      ALLOCATE(psfl(klon, klev+1), fraca(klon, klev+1), Vprecip(klon, klev+1))
      ALLOCATE(bsfl(klon,klev+1))
      ALLOCATE(zw2(klon, klev+1))

      ALLOCATE(fluxu(klon, klev, nbsrf), fluxv(klon, klev, nbsrf))
      ALLOCATE(fluxt(klon, klev, nbsrf))

      ALLOCATE(uwriteSTD(klon,nlevSTD,nfiles), vwriteSTD(klon,nlevSTD,nfiles))
      ALLOCATE(wwriteSTD(klon,nlevSTD,nfiles), phiwriteSTD(klon,nlevSTD,nfiles))
      ALLOCATE(qwriteSTD(klon,nlevSTD,nfiles), twriteSTD(klon,nlevSTD,nfiles))
      ALLOCATE(rhwriteSTD(klon,nlevSTD,nfiles))

! ug et d'autres encore:
      ALLOCATE(beta_prec(klon,klev))
      ALLOCATE(rneb(klon,klev),rnebjn(klon,klev),rneblsvol(klon,klev))
      ALLOCATE(pfraclr(klon,klev),pfracld(klon,klev))
      pfraclr(:,:)=0. ; pfracld(:,:)=0. ! because not always defined
      ALLOCATE(cldfraliq(klon,klev))
      ALLOCATE(sigma2_icefracturb(klon,klev))
      ALLOCATE(mean_icefracturb(klon,klev))
      ALLOCATE(distcltop(klon,klev))
      ALLOCATE(temp_cltop(klon,klev))

      ALLOCATE (zxsnow(klon),snowhgt(klon),qsnow(klon),to_ice(klon))
      ALLOCATE (sissnow(klon),runoff(klon),albsol3_lic(klon))
#ifdef ISO
      ALLOCATE (zxxtsnow(niso,klon))
      ALLOCATE(xtVprecip(ntraciso,klon, klev+1),xtVprecipi(ntraciso,klon, klev+1))
      ALLOCATE(pxtsfl(ntraciso,klon, klev+1),pxtrfl(ntraciso,klon, klev+1))
#endif

      ALLOCATE (p_tropopause(klon))
      ALLOCATE (z_tropopause(klon))
      ALLOCATE (t_tropopause(klon))

      ALLOCATE(zn2mout(klon,6))

! Supersaturation
      ALLOCATE(rneb_seri(klon,klev))
      ALLOCATE(d_rneb_dyn(klon,klev))
      ALLOCATE(qclr(klon,klev), qcld(klon,klev), qss(klon,klev), qvc(klon,klev))
      ALLOCATE(rnebclr(klon,klev), rnebss(klon,klev), gamma_ss(klon,klev))
      ALLOCATE(N1_ss(klon,klev), N2_ss(klon,klev))
      ALLOCATE(drneb_sub(klon,klev), drneb_con(klon,klev), drneb_tur(klon,klev), drneb_avi(klon,klev))
      ALLOCATE(zqsatl(klon,klev), zqsats(klon,klev))
      ALLOCATE(Tcontr(klon,klev), qcontr(klon,klev), qcontr2(klon,klev), fcontrN(klon,klev), fcontrP(klon,klev))

!--POPRECIP variables
      ALLOCATE(qraindiag(klon,klev), qsnowdiag(klon,klev))
      ALLOCATE(dqreva(klon,klev), dqssub(klon,klev))
      ALLOCATE(dqrauto(klon,klev), dqrcol(klon,klev), dqrmelt(klon,klev), dqrfreez(klon,klev))
      ALLOCATE(dqsauto(klon,klev), dqsagg(klon,klev), dqsrim(klon,klev), dqsmelt(klon,klev), dqsfreez(klon,klev))

#ifdef CPP_StratAer
      ALLOCATE (d_q_emiss(klon,klev))
      ALLOCATE (R2SO4(klon,klev))
      ALLOCATE (DENSO4(klon,klev))
      ALLOCATE (f_r_wet(klon,klev))
      ALLOCATE (decfluxaer(klon,nbtr))
      ALLOCATE (mdw(nbtr))
      ALLOCATE (budg_3D_nucl(klon,klev))
      ALLOCATE (budg_3D_cond_evap(klon,klev))
      ALLOCATE (budg_3D_ocs_to_so2(klon,klev))
      ALLOCATE (budg_3D_so2_to_h2so4(klon,klev))
      ALLOCATE (budg_3D_backgr_ocs(klon,klev))
      ALLOCATE (budg_3D_backgr_so2(klon,klev))
      ALLOCATE (OCS_lifetime(klon,klev))
      ALLOCATE (SO2_lifetime(klon,klev))
      ALLOCATE (H2SO4_lifetime(klon,klev))
      ALLOCATE (O3_clim(klon,klev))
      ALLOCATE (alpha_bin(nbands_sw_rrtm+nbands_lw_rrtm+nwave,nbtr))
      ALLOCATE (piz_bin(nbands_sw_rrtm+nbands_lw_rrtm+nwave,nbtr))
      ALLOCATE (cg_bin(nbands_sw_rrtm+nbands_lw_rrtm+nwave,nbtr))
      ALLOCATE (tau_strat_550(klon,klev))
      ALLOCATE (tau_strat_1020(klon,klev))
      ALLOCATE (tausum_strat(klon,3))
      ALLOCATE (budg_dep_dry_ocs(klon))
      ALLOCATE (budg_dep_wet_ocs(klon))
      ALLOCATE (budg_dep_dry_so2(klon))
      ALLOCATE (budg_dep_wet_so2(klon))
      ALLOCATE (budg_dep_dry_h2so4(klon))
      ALLOCATE (budg_dep_wet_h2so4(klon))
      ALLOCATE (budg_dep_dry_part(klon))
      ALLOCATE (budg_dep_wet_part(klon))
      ALLOCATE (budg_emi_ocs(klon))
      ALLOCATE (budg_emi_so2(klon))
      ALLOCATE (budg_emi_h2so4(klon))
      ALLOCATE (budg_emi_part(klon))
      ALLOCATE (budg_ocs_to_so2(klon))
      ALLOCATE (budg_so2_to_h2so4(klon))
      ALLOCATE (budg_h2so4_to_part(klon))
      ALLOCATE (budg_sed_part(klon))
      ALLOCATE (surf_PM25_sulf(klon))
      ALLOCATE (vsed_aer(klon,klev))
#endif

END SUBROUTINE phys_local_var_init

!======================================================================
SUBROUTINE phys_local_var_end
USE dimphy
USE indice_sol_mod
IMPLICIT NONE
      DEALLOCATE(t_seri,q_seri,ql_seri,qs_seri, qbs_seri,qx_seri)
      DEALLOCATE(u_seri,v_seri)
      DEALLOCATE(l_mixmin,l_mix,wprime)
      DEALLOCATE(tke_shear,tke_buoy,tke_trans)
      DEALLOCATE(pbl_eps)
      DEALLOCATE(rhcl)
      DEALLOCATE(tr_seri)
      DEALLOCATE(d_t_dyn,d_q_dyn)
      DEALLOCATE(d_ql_dyn,d_qs_dyn, d_qbs_dyn)
      DEALLOCATE(d_q_dyn2d,d_ql_dyn2d,d_qs_dyn2d, d_qbs_dyn2d)
      DEALLOCATE(d_u_dyn,d_v_dyn)
      DEALLOCATE(d_tr_dyn)                      !RomP
      DEALLOCATE(d_t_con,d_q_con,d_q_con_zmasse)
      DEALLOCATE(d_u_con,d_v_con)
      DEALLOCATE(d_t_wake,d_q_wake)
      DEALLOCATE(d_t_lsc,d_q_lsc)
      DEALLOCATE(d_t_lwr,d_t_lw0)
      DEALLOCATE(d_t_swr,d_t_sw0)
      DEALLOCATE(d_ql_lsc,d_qi_lsc)
      DEALLOCATE(d_t_ajsb,d_q_ajsb)
      DEALLOCATE(d_t_ajs,d_q_ajs)
!nrlmd<
      DEALLOCATE(d_t_ajs_w,d_q_ajs_w)
      DEALLOCATE(d_t_ajs_x,d_q_ajs_x)
!>nrlmd
      DEALLOCATE(d_u_ajs,d_v_ajs)
      DEALLOCATE(d_t_eva,d_q_eva)
      DEALLOCATE(d_qx_eva)
      DEALLOCATE(d_ql_eva,d_qi_eva)
      DEALLOCATE(d_t_lscst,d_q_lscst)
      DEALLOCATE(d_t_lscth,d_q_lscth)
      DEALLOCATE(plul_st,plul_th)
      DEALLOCATE(d_t_vdf,d_q_vdf,d_t_diss)
      DEALLOCATE(d_qbs_vdf)
      DEALLOCATE(d_t_bsss,d_q_bsss,d_qbs_bsss)
#ifdef ISO
      deallocate(xt_seri,xtl_seri,xts_seri,xtbs_seri)
      DEALLOCATE(d_xtl_eva,d_xti_eva)
      deallocate(d_xt_dyn,d_xtl_dyn,d_xts_dyn,d_xtbs_dyn)
      deallocate(d_xt_con)
      deallocate(d_xt_wake)
      deallocate(d_xt_lsc)
      deallocate(d_xtl_lsc,d_xti_lsc)
      deallocate(d_xt_ajsb)
      deallocate(d_xt_ajs)
      deallocate(d_xt_ajs_w,d_xt_ajs_x)
      deallocate(d_xt_eva)
      deallocate(d_xtl_eva)
      deallocate(d_xti_eva)
      deallocate(d_xt_vdf)
      deallocate(d_xt_vdf_w,d_xt_vdf_x)
      deallocate(d_xt_ch4)
      deallocate(d_xt_prod_nucl)
      deallocate(d_xt_cosmo)
      deallocate(d_xt_decroiss)
#endif

      DEALLOCATE(d_u_vdf,d_v_vdf)
      DEALLOCATE(d_t_oli,d_t_oro)
      DEALLOCATE(d_u_oli,d_v_oli)
      DEALLOCATE(d_u_oro,d_v_oro)
      DEALLOCATE(d_t_oro_gw)
      DEALLOCATE(d_u_oro_gw,d_v_oro_gw)
      DEALLOCATE(d_t_lif,d_t_ec)
      DEALLOCATE(d_u_lif,d_v_lif)
      DEALLOCATE(d_ts, d_tr)
      DEALLOCATE(topswad_aero,solswad_aero)
      DEALLOCATE(topswai_aero,solswai_aero)
      DEALLOCATE(topswad0_aero,solswad0_aero)
      DEALLOCATE(toplwad_aero,sollwad_aero)
      DEALLOCATE(toplwai_aero,sollwai_aero)
      DEALLOCATE(toplwad0_aero,sollwad0_aero)
      DEALLOCATE(topsw_aero,solsw_aero)
      DEALLOCATE(topsw0_aero,solsw0_aero)
      DEALLOCATE(topswcf_aero,solswcf_aero)
      DEALLOCATE(stratomask) 
      DEALLOCATE(tausum_aero) 
      DEALLOCATE(drytausum_aero) 
      DEALLOCATE(tau3d_aero) 
      DEALLOCATE(dNovrN)
      DEALLOCATE(zfice)
      DEALLOCATE(od443aer)
      DEALLOCATE(od550aer)
      DEALLOCATE(od865aer)
      DEALLOCATE(dryod550aer)
      DEALLOCATE(abs550aer)
      DEALLOCATE(ec550aer)
      DEALLOCATE(od550lt1aer)
      DEALLOCATE(sconcso4) 
      DEALLOCATE(sconcno3) 
      DEALLOCATE(sconcoa) 
      DEALLOCATE(sconcbc) 
      DEALLOCATE(sconcss) 
      DEALLOCATE(sconcdust) 
      DEALLOCATE(concso4) 
      DEALLOCATE(concno3) 
      DEALLOCATE(concoa) 
      DEALLOCATE(concbc) 
      DEALLOCATE(concss) 
      DEALLOCATE(concdust) 
      DEALLOCATE(loadso4) 
      DEALLOCATE(loadoa) 
      DEALLOCATE(loadbc) 
      DEALLOCATE(loadss) 
      DEALLOCATE(loaddust) 
      DEALLOCATE(loadno3) 
      DEALLOCATE(load_tmp1)
      DEALLOCATE(load_tmp2)
      DEALLOCATE(load_tmp3)
      DEALLOCATE(load_tmp4)
      DEALLOCATE(load_tmp5)
      DEALLOCATE(load_tmp6)
      DEALLOCATE(load_tmp7)
      DEALLOCATE(load_tmp8)
      DEALLOCATE(load_tmp9)
      DEALLOCATE(load_tmp10)
      DEALLOCATE(du_gwd_hines,dv_gwd_hines,d_t_hin)
      DEALLOCATE(d_q_ch4)
      DEALLOCATE(dv_gwd_rando,dv_gwd_front)
      DEALLOCATE(east_gwstress,west_gwstress)

!IM ajout variables CFMIP2/CMIP5
      DEALLOCATE(topswad_aerop, solswad_aerop)
      DEALLOCATE(topswai_aerop, solswai_aerop)
      DEALLOCATE(topswad0_aerop, solswad0_aerop)
      DEALLOCATE(topsw_aerop, topsw0_aerop)
      DEALLOCATE(solsw_aerop, solsw0_aerop)
      DEALLOCATE(topswcf_aerop, solswcf_aerop)
!AI Aerosols
      DEALLOCATE(m_allaer)
!CK LW diagnostics
      DEALLOCATE(toplwad_aerop, sollwad_aerop)
      DEALLOCATE(toplwai_aerop, sollwai_aerop)
      DEALLOCATE(toplwad0_aerop, sollwad0_aerop)

!AI Ajout pour Ecrad (3Deffect)
      DEALLOCATE(topswad_aero_s2, solswad_aero_s2)
      DEALLOCATE(topswai_aero_s2, solswai_aero_s2)
      DEALLOCATE(topswad0_aero_s2, solswad0_aero_s2)
      DEALLOCATE(topsw_aero_s2, topsw0_aero_s2)
      DEALLOCATE(solsw_aero_s2, solsw0_aero_s2)
      DEALLOCATE(topswcf_aero_s2, solswcf_aero_s2)
!CK LW diagnostics
      DEALLOCATE(toplwad_aero_s2, sollwad_aero_s2)
      DEALLOCATE(toplwai_aero_s2, sollwai_aero_s2)
      DEALLOCATE(toplwad0_aero_s2, sollwad0_aero_s2)      

! FH Ajout de celles necessaires au phys_output_write_mod
      DEALLOCATE(tal1, pal1, pab1, pab2)
      DEALLOCATE(ptstar, pt0, slp)
!
      DEALLOCATE(alp_wake)
      DEALLOCATE(wake_h,wake_k)
      DEALLOCATE(wake_omg)
      DEALLOCATE(d_deltat_wk, d_deltaq_wk)
      DEALLOCATE(d_s_wk, d_dens_a_wk, d_dens_wk)
      DEALLOCATE(d_deltat_wk_gw, d_deltaq_wk_gw)
      DEALLOCATE(d_deltat_vdf, d_deltaq_vdf)
!!      DEALLOCATE( d_s_vdf, d_dens_vdf)
      DEALLOCATE(d_deltat_the, d_deltaq_the)
!!      DEALLOCATE( d_s_the, d_dens_the)
      DEALLOCATE(d_deltat_ajs_cv, d_deltaq_ajs_cv)
#ifdef ISO
      DEALLOCATE(d_deltaxt_wk)
      DEALLOCATE(d_deltaxt_wk_gw)
      DEALLOCATE(d_deltaxt_ajs_cv)
      DEALLOCATE(d_deltaxt_vdf)
#endif
!
      DEALLOCATE(bils)
      DEALLOCATE(cdragm, cdragh, cldh, cldl)
      DEALLOCATE(cldm, cldq, cldt, qsat2m)
      DEALLOCATE(JrNt)
      DEALLOCATE(dthmin, evap, snowerosion, fder, plcl, plfc)
      DEALLOCATE(prw, prlw, prsw, prbsw, water_budget, zustar, zu10m, zv10m, rh2m, s_lcl)
      DEALLOCATE(s_pblh, s_pblt, s_therm)
!
!nrlmd+jyg<
      DEALLOCATE(s_pblh_x, s_pblh_w)
      DEALLOCATE(s_lcl_x, s_lcl_w)
!>nrlmd+jyg
!
      DEALLOCATE(slab_wfbils, tpot, tpote, ue)
      DEALLOCATE(uq, ve, vq, zxffonte)
      DEALLOCATE(uwat, vwat)
      DEALLOCATE(zxfqcalving, zxfluxlat)
      DEALLOCATE(zxrunofflic)
      DEALLOCATE(zxustartlic, zxrhoslic, zxqsaltlic)
      DEALLOCATE(zxtsol, snow_lsc, zxfqfonte, zxqsurf)
      DEALLOCATE(rain_lsc)
      DEALLOCATE(rain_num)
      DEALLOCATE(qlth, qith, qsith, wiceth)
!
      DEALLOCATE(sens_x, sens_w)
      DEALLOCATE(zxfluxlat_x, zxfluxlat_w)
      DEALLOCATE(delta_qsurf)
!jyg<
!!      DEALLOCATE(t_x, t_w)
!!      DEALLOCATE(q_x, q_w)
!>jyg
      DEALLOCATE(d_t_vdf_x, d_t_vdf_w)
      DEALLOCATE(d_q_vdf_x, d_q_vdf_w)
      DEALLOCATE(pbl_tke_input)
      DEALLOCATE(t_therm, q_therm, u_therm, v_therm)
      DEALLOCATE(cdragh_x, cdragh_w)
      DEALLOCATE(cdragm_x, cdragm_w)
      DEALLOCATE(kh, kh_x, kh_w)
#ifdef ISO
      DEALLOCATE(xtevap,xtprw)
      DEALLOCATE(zxfxtcalving)
      DEALLOCATE(zxxtrunofflic)
      DEALLOCATE(xtsnow_lsc, zxfxtfonte)
      DEALLOCATE(xtrain_lsc)
      DEALLOCATE(dxtvdf_x, dxtvdf_w)
      DEALLOCATE(xt_therm)
      DEALLOCATE(h1_diag,runoff_diag,xtrunoff_diag)
#endif
!
      DEALLOCATE(ptconv)
      DEALLOCATE(ratqsc)
!
      DEALLOCATE(wbeff, convoccur, zmax_th)
      DEALLOCATE(zq2m, zt2m, weak_inversion)
      DEALLOCATE(zt2m_min_mon, zt2m_max_mon)
      DEALLOCATE(t2m_min_mon, t2m_max_mon)
      DEALLOCATE(sens, flwp, fiwp)
      DEALLOCATE(alp_bl_conv,alp_bl_det)
      DEALLOCATE(alp_bl_fluct_m,alp_bl_fluct_tke)
      DEALLOCATE(alp_bl_stat, n2, s2, strig, zcong, zlcl_th)
      DEALLOCATE(proba_notrig, random_notrig)
!FC
      DEALLOCATE(zxfluxq,zxfluxt)

      DEALLOCATE(dnwd0)
!      DEALLOCATE(upwd, omega, coefh)
      DEALLOCATE(omega)
      DEALLOCATE(epmax_diag)
!      DEALLOCATE(coefm, lambda_th, cldemi)
      DEALLOCATE(lambda_th, cldemi)
      DEALLOCATE(cldfra, cldtau, fiwc)
      DEALLOCATE(fl, re, flwc)
      DEALLOCATE(ref_liq, ref_ice, theta)
      DEALLOCATE(ref_liq_pi, ref_ice_pi)
      DEALLOCATE(zphi, zx_rh, zx_rhl, zx_rhi)
      DEALLOCATE(pmfd, pmfu)

      DEALLOCATE(t2m, fluxlat)
      DEALLOCATE(fsollw, evap_pot)
      DEALLOCATE(fsolsw, wfbils)
      DEALLOCATE(wfevap)

      DEALLOCATE(pmflxr, pmflxs)
      DEALLOCATE(wdtrainA, wdtrainS, wdtrainM)
      DEALLOCATE(upwd, dnwd)
      DEALLOCATE(ep)
      DEALLOCATE(da, mp)
      DEALLOCATE(phi)
      DEALLOCATE(wght_cvfd)
      DEALLOCATE(phi2)
      DEALLOCATE(d1a, dam)
      DEALLOCATE(ev)
      DEALLOCATE(elij)
      DEALLOCATE(qtaa)
      DEALLOCATE(clw)
      DEALLOCATE(epmlmMm, eplaMm)
      DEALLOCATE(sij)
#ifdef ISO
      DEALLOCATE(xtwdtrainA)
      DEALLOCATE(xttaa )
      DEALLOCATE(xtclw )
      DEALLOCATE(xtev )
#ifdef DIAGISO
      DEALLOCATE(qlp)
      DEALLOCATE(qvp)
      DEALLOCATE(fq_detrainement)
      DEALLOCATE(fq_ddft)
      DEALLOCATE(fq_fluxmasse)
      DEALLOCATE(fq_evapprecip)
      DEALLOCATE(f_detrainement,q_detrainement)
      DEALLOCATE(xtlp)
      DEALLOCATE(xtvp)
      DEALLOCATE(q_the,xt_the)
      DEALLOCATE(fxt_detrainement)
      DEALLOCATE(fxt_ddft)
      DEALLOCATE(fxt_fluxmasse)
      DEALLOCATE(fxt_evapprecip)
      DEALLOCATE(xt_detrainement)
#endif
#endif


      DEALLOCATE(prfl, psfl, bsfl, fraca, Vprecip)
      DEALLOCATE(zw2)

      DEALLOCATE(fluxu, fluxv)
      DEALLOCATE(fluxt)

      DEALLOCATE(uwriteSTD, vwriteSTD)
      DEALLOCATE(wwriteSTD, phiwriteSTD)
      DEALLOCATE(qwriteSTD, twriteSTD, rhwriteSTD)

! ug et d'autres encore:
      DEALLOCATE(beta_prec)
      DEALLOCATE(rneb)
      DEALLOCATE(pfraclr,pfracld)
      DEALLOCATE(cldfraliq)
      DEALLOCATE(sigma2_icefracturb)
      DEALLOCATE(mean_icefracturb)
      DEALLOCATE (zxsnow,snowhgt,qsnow,to_ice,sissnow,runoff,albsol3_lic)
      DEALLOCATE(distcltop)
      DEALLOCATE(temp_cltop)
#ifdef ISO
      DEALLOCATE (zxxtsnow,xtVprecip,xtVprecipi,pxtrfl,pxtsfl)
#endif

      DEALLOCATE (p_tropopause)
      DEALLOCATE (z_tropopause)
      DEALLOCATE (t_tropopause)
      DEALLOCATE(zn2mout)

! Supersaturation
      DEALLOCATE(rneb_seri)
      DEALLOCATE(d_rneb_dyn)
      DEALLOCATE(qclr, qcld, qss, qvc)
      DEALLOCATE(rnebclr, rnebss, gamma_ss)
      DEALLOCATE(N1_ss, N2_ss)
      DEALLOCATE(drneb_sub, drneb_con, drneb_tur, drneb_avi)
      DEALLOCATE(zqsatl, zqsats)
      DEALLOCATE(Tcontr, qcontr, qcontr2, fcontrN, fcontrP)

!--POPRECIP variables
      DEALLOCATE(qraindiag, qsnowdiag)
      DEALLOCATE(dqreva, dqssub)
      DEALLOCATE(dqrauto, dqrcol, dqrmelt, dqrfreez)
      DEALLOCATE(dqsauto, dqsagg, dqsrim, dqsmelt, dqsfreez)

#ifdef CPP_StratAer
! variables for strat. aerosol CK
      DEALLOCATE (d_q_emiss)
      DEALLOCATE (R2SO4)
      DEALLOCATE (DENSO4)
      DEALLOCATE (f_r_wet)
      DEALLOCATE (decfluxaer)
      DEALLOCATE (mdw)
      DEALLOCATE (SO2_lifetime)
      DEALLOCATE (OCS_lifetime)
      DEALLOCATE (H2SO4_lifetime)
      DEALLOCATE (O3_clim)
      DEALLOCATE (alpha_bin)
      DEALLOCATE (piz_bin)
      DEALLOCATE (cg_bin)
      DEALLOCATE (tau_strat_550)
      DEALLOCATE (tau_strat_1020)
      DEALLOCATE (tausum_strat)
      DEALLOCATE (surf_PM25_sulf)
      DEALLOCATE (vsed_aer)
      DEALLOCATE (budg_3D_ocs_to_so2)
      DEALLOCATE (budg_3D_so2_to_h2so4)
      DEALLOCATE (budg_3D_backgr_ocs)
      DEALLOCATE (budg_3D_backgr_so2)
      DEALLOCATE (budg_3D_nucl)
      DEALLOCATE (budg_3D_cond_evap)
      DEALLOCATE (budg_dep_dry_ocs)
      DEALLOCATE (budg_dep_wet_ocs)
      DEALLOCATE (budg_dep_dry_so2)
      DEALLOCATE (budg_dep_wet_so2)
      DEALLOCATE (budg_dep_dry_h2so4)
      DEALLOCATE (budg_dep_wet_h2so4)
      DEALLOCATE (budg_dep_dry_part)
      DEALLOCATE (budg_dep_wet_part)
      DEALLOCATE (budg_emi_ocs)
      DEALLOCATE (budg_emi_so2)
      DEALLOCATE (budg_emi_h2so4)
      DEALLOCATE (budg_emi_part)
      DEALLOCATE (budg_ocs_to_so2)
      DEALLOCATE (budg_so2_to_h2so4)
      DEALLOCATE (budg_h2so4_to_part)
      DEALLOCATE (budg_sed_part)
#endif

END SUBROUTINE phys_local_var_end

END MODULE phys_local_var_mod 
