! ---------------------------------------------
! This module serves as a wrapper around netcdf.
! It serves two primary functions:
!  1) Turn netcdf into a "real" fortran module, without the INCLUDE call
!  2) Handle the NC_DOUBLE CPP key. This key should ONLY be used here.
! Ideally, the "real" netcdf module/headers should ONLY be called here. (WIP) TODO
! ---------------------------------------------
! TODO check all uses of `use netcdf` + netcdf.inc

MODULE lmdz_netcdf
  USE, INTRINSIC :: ISO_FORTRAN_ENV, ONLY : REAL64, REAL32
  USE netcdf
  IMPLICIT NONE
  ! Note: as we want to expose netcdf through this module, we don't make all PRIVATE by default as usual
  ! Instead, explicitely make PRIVATE the relevant items.

  INCLUDE 'netcdf.inc'

#ifdef NC_DOUBLE
  INTEGER, PARAMETER :: NF90_FORMAT = NF90_DOUBLE
#else
  INTEGER, PARAMETER :: NF90_FORMAT = NF90_FLOAT
#endif
END MODULE lmdz_netcdf