! ---------------------------------------------
! This module serves as a wrapper around netcdf.
! It serves two primary functions:
!  1) Turn netcdf into a "real" fortran module, without the INCLUDE call
!  2) Handle the NC_DOUBLE CPP key. Ideally, this key should ONLY appear here (WIP). TODO
! Ideally, the "real" netcdf module/headers should ONLY be called here. (WIP) TODO
! ---------------------------------------------
! TODO check that none of the wrapped functions remain elsewhere
! TODO check all uses of `use netcdf` + netcdf.inc

MODULE lmdz_netcdf
  USE, INTRINSIC :: ISO_FORTRAN_ENV, ONLY : REAL64, REAL32
  USE netcdf
  IMPLICIT NONE
  ! Note: as we want to expose netcdf through this module, we don't make all PRIVATE by default as usual
  ! Instead, explicitely make PRIVATE the relevant items.
  PRIVATE CPP_NC_DOUBLE

  INCLUDE 'netcdf.inc'

#ifdef NC_DOUBLE
  LOGICAL, PARAMETER :: CPP_NC_DOUBLE = .TRUE.  ! Define a variable to reduce use of preprocessor ahead
  INTEGER, PARAMETER :: NF90_FORMAT = NF90_DOUBLE
  INTEGER, PARAMETER :: REAL_FORMAT = REAL64
#else
  LOGICAL, PARAMETER :: CPP_NC_DOUBLE = .FALSE.
  INTEGER, PARAMETER :: NF90_FORMAT = NF90_FLOAT
  INTEGER, PARAMETER :: REAL_FORMAT = REAL32
#endif
CONTAINS

END MODULE lmdz_netcdf