! ---------------------------------------------
! This module serves as a wrapper around netcdf.
! It serves two primary functions:
!  1) Turn netcdf into a "real" fortran module, without the INCLUDE call
!  2) Handle the NC_DOUBLE CPP key
! ---------------------------------------------

MODULE lmdz_netcdf
  USE, INTRINSIC :: ISO_FORTRAN_ENV, ONLY : REAL64, REAL32
  USE netcdf
  IMPLICIT NONE
  ! Note: as we want to expose netcdf through this module, we don't make all PRIVATE by default as usual
  ! Instead, explicitely make PRIVATE the relevant items.

  INCLUDE 'netcdf.inc'

#ifdef NC_DOUBLE
  INTEGER, PARAMETER :: NF90_FORMAT = NF90_DOUBLE
  INTEGER, PARAMETER :: REAL_FORMAT = REAL64
#else
  INTEGER, PARAMETER :: NF90_FORMAT = NF90_FLOAT
  INTEGER, PARAMETER :: REAL_FORMAT = REAL32
#endif
CONTAINS

  ! We'd like to use "nf_put_var", but it already exists as a legacy nc4 function
  INTEGER FUNCTION nf_put_var_rd(ncid, varid, vals)
    INTEGER, INTENT(IN) :: ncid, varid
    REAl(REAL_FORMAT), INTENT(IN) :: vals(*)  ! (*) as declared in netcdf lib
#ifdef NC_DOUBLE
    nf_put_var_rd = nf_put_var_double(ncid, varid, vals)
#else
    nf_put_var_rd = nf_put_var_real(ncid, varid, vals)
#endif
  END FUNCTION nf_put_var_rd

  INTEGER FUNCTION nf_put_vara_rd(ncid, varid, start, counts, vals)
    INTEGER, INTENT(IN) :: ncid, varid
    INTEGER, INTENT(IN) :: start(*), counts(*)
    REAl(REAL_FORMAT), INTENT(IN) :: vals(*)  ! (*) as declared in netcdf lib
#ifdef NC_DOUBLE
    nf_put_vara_rd = nf_put_vara_double(ncid, varid, vals)
#else
    nf_put_vara_rd = nf_put_vara_real(ncid, varid, vals)
#endif
  END FUNCTION nf_put_vara_rd

END MODULE lmdz_netcdf

! TODO check that none of the wrapped functions remain elsewhere
! TODO check all uses of `use netcdf`