
##############################################################
# Gestion des modules
##############################################################

if grep -q "Adastra" /etc/motd; then
  hostname="adastra"
else
  hostname=$(hostname)
fi
echo "Setting up lmdz_env on $hostname"

# Platform-specific
case ${hostname:0:5} in
  jean-)
    ARCH="X64_JEANZAY"
    module purge
    compilo=19.0.4 # available 2013.0, 2017.2
    module load intel-compilers/$compilo
    #module load intel-mpi/$compilo
    module load intel-mkl/$compilo
    module load hdf5/1.10.5-mpi
    module load netcdf/4.7.2-mpi
    module load netcdf-fortran/4.5.2-mpi
    module load subversion/1.9.7
    #Pour module gcc, voir : https://trac.lmd.jussieu.fr/LMDZ/wiki/PortageJeanZay
    #module load gcc/6.5.0
    module load nco
    module load cdo
    # Imputation de la consommation sur le groupe (projet) actif par defaut,
    #   idrproj indique le groupe (projet) actif par defaut
    #   idrproj -d newproj   redefinit "newproj" en tant que  projet actif,
    #        alors $STORE, $WORK etc vont designer les espaces de "newproj")
    account=$(idrproj | grep active | awk '{ print $1}')
    SUBMITCMD="sbatch -A $account@cpu "
    RUNCMD="srun --label -n"
    # Espaces suivants definis par defaut en fonction du groupe actif,
    #  par exemple : SCRATCHD=$SCRATCH is /gpfsstore/rech/$groupe/$login
                #    * On peut aussi ne pas installer les scripts a la racine de STORE,
                #        mais dans STORED=$STORE/your_folder
    SIMRUNBASEDIR="$SCRATCH/LMDZ_Setup"
    LMDZD=$WORK
    NB_MPI_MAX=2000
    NB_OMP_MAX=20
    #LMDZ_Init sur le $STORE du $groupe
    LMDZ_INIT=$STORE/LMDZ_Init
    ;;
  spiri)
    module purge
    module load subversion/1.13.0
    module load gcc/11.2.0
    module load openmpi/4.0.7

    root_dir=~/"LMDZ_SETUP_ROOT/LMDZ_Setup";
    ARCH="X64_MESOIPSL-GNU"
    SIMRUNBASEDIR="$SCRATCH/"
    LMDZD="$root_dir/LMDZD"
    LMDZ_INIT="$root_dir/LMDZ_Init"
    NB_MPI_MAX=20
    NB_OMP_MAX=1
    RUNCMD="srun --label -n"
    SUBMITCMD="sbatch"
    ;;
  adast)
    module purge
#    module load PrgEnv-gnu
#    module load cray-hdf5-parallel
#    module load netcdf-hdf5parallel/gnu/10.3

    account=$(/usr/sbin/my_project.py -l 2>&1 | head -1 | cut -d " " -f 3- | cut -c 5-)
    root_dir="$WORKDIR/LMDZ_Setup";
    ARCH="X64_ADASTRA-GNU"
    SIMRUNBASEDIR="$SCRATCHDIR/"
    LMDZD="$root_dir/LMDZD"
    LMDZ_INIT="$root_dir/LMDZ_Init"
    NB_MPI_MAX=20  # TODO 2000 in JZ
    NB_OMP_MAX=2  # TODO 20 in JZ
    RUNCMD="srun --label --account=$account -n"
    SUBMITCMD="sbatch --account=$account"
    ;;
  *) echo "WARNING: RUNNING THIS SCRIPT ON A LOCAL COMPUTER IS DISCOURAGED (lacklusted cpus and memory)"
    root_dir="/home/abarral/PycharmProjects/installLMDZ/LMDZ_Setup"; # Where LMDZ_Setup is extracted. Can't use $(pwd) since this script gets copied and ran from several locations
    ARCH="local-gfortran-parallel"
    SIMRUNBASEDIR="/tmp/SCRATCH/"  # Where the simulations will be executed ($SIMRUNBASEDIR/LMDZ_Setup/...)
    LMDZD="$root_dir/LMDZD"  # Where the sources will be downloaded and compiled
    LMDZ_INIT="$root_dir/LMDZ_Init"  # Where to store shared files used for initialisation
    NB_MPI_MAX=2  # Max number of MPI cores
    NB_OMP_MAX=1  # Max number of OMP threads
    RUNCMD="mpirun -np" # command to run a job, as $runcmd <nprocs> <script>
    SUBMITCMD="."  # command to sumbit a job, as $submitcmd <script>
    ;;
esac

if [[ ! (-d $root_dir && -f $root_dir/lmdz_env.sh) ]]; then
  echo "STOP: root_dir $root_dir not found, either you are running on an unsupported cluster, or you haven't edited lmdz_env.sh properly"; exit 1
fi
