
##############################################################
# Gestion des modules
##############################################################

hostname=$(hostname)
echo "Setting up lmdz_env on $hostname"

# Platform-specific
case ${hostname:0:5} in
  jean-)
    ARCH="X64_JEANZAY"
    module purge
    compilo=19.0.4 # available 2013.0, 2017.2
    module load intel-compilers/$compilo
    #module load intel-mpi/$compilo
    module load intel-mkl/$compilo
    module load hdf5/1.10.5-mpi
    module load netcdf/4.7.2-mpi
    module load netcdf-fortran/4.5.2-mpi
    module load subversion/1.9.7
    #Pour module gcc, voir : https://trac.lmd.jussieu.fr/LMDZ/wiki/PortageJeanZay
    #module load gcc/6.5.0
    module load nco
    module load cdo
    # Imputation de la consommation sur le groupe (projet) actif par defaut,
    #   idrproj indique le groupe (projet) actif par defaut
    #   idrproj -d newproj   redefinit "newproj" en tant que  projet actif,
    #        alors $STORE, $WORK etc vont designer les espaces de "newproj")
    GROUPE=$(idrproj | grep active | awk '{ print $1}')
    SUBMITCMD="sbatch -A $GROUPE@cpu "
    RUNCMD="srun --label -n"
    # Espaces suivants definis par defaut en fonction du groupe actif,
    #  par exemple : SCRATCHD=$SCRATCH is /gpfsstore/rech/$groupe/$login
                #    * On peut aussi ne pas installer les scripts a la racine de STORE,
                #        mais dans STORED=$STORE/your_folder
    SIMRESDIR=$STORE
    SIMRUNTOPDIR="$SCRATCH/LMDZ_Setup"
    LMDZD=$WORK
    NB_MPI_MAX=2000
    NB_OMP_MAX=20
    #LMDZ_Init sur le $STORE du $groupe
    LMDZ_INIT=$STORE/LMDZ_Init

    JOB_HEADER="#SBATCH -A $groupe@cpu
    #@TESTQ#SBATCH --qos=qos_cpu-dev"

    ;;
  *)  # TODO mettre clairement dans ce paragraphe une doc de chaque param
    ARCH="local-gfortran-parallel"
#    submit=". "
#    run="mpirun -np "
    SIMRUNTOPDIR="/tmp/SCRATCH/LMDZ_Setup/"  # Where the simulations will be executed  # TODO Change name if it's actually the SIMRUNDIR
    SIMRESDIR=~"/TMP/LMDZ_Setup"  # Where to store the relevant outputs of the simulations
    LMDZD="$(pwd)/LMDZD"  # Where the sources will be downloaded and compiled
    LMDZ_INIT="$(pwd)/LMDZ_Init"  # Where to store shared files used for initialisation
    NB_MPI_MAX=999999  # Max number of MPI cores
    NB_OMP_MAX=999999  # Max number of OMP threads
    GROUPE=""  # the group to execute the job as
    RUNCMD="mpirun -n" # command to run a job, as $runcmd <nprocs> <script>
    SUBMITCMD="mpirun"  # command to sumbit a job, as $submitcmd <script>
esac


#echo LMDZ_Init dans lmdz_env $LMDZ_Init
