

Last update : 2023-07-05

Complementary information and FAQ (in French) :
https://docs.google.com/document/d/1OLZG6e-86NiXuv5-aALxKIh-QPkp4BdCwWtiBFot-6c

I. What this working environment does and does not
==================================================

This setup can only be used on jean-zay computer at idris so far.
    However, extension to ciclad or irene will be done soon.

It proposes a light automatic setup of LMDZ long chained climate simulations
   including installation of the model itself.

It consists in running LMDZ coupled to Orchidee for land surface (optional)
   but with imposed sea surface temperature.

The basic default configuration makes use of the IPSL-CM6A grid configuration
   and tuning, and runs a multi annual simulation on "climatological"
   amip sea surface temperature (with a mean annual cycle) using
   a calendar with 360 days.

Optionally: the configuration includes the ability to use interannually
   varying SST and to activate "nudgning" by reanalysis.
   In both cases, the calendar is then a real one.
   When nudging is activated, the simulation must be run on a monthly
   basis, while otherwise, it can be either monthly or yearly.

Since the tutorial automatically generates its own initial files, it
   can be run with zoom configurations by only changing the number
   of grid points ("resol" in main.sh) and the DEF/gcm.def file (see bellow).

Aerosols can be read for the year 2000 (weighted average  over 1999-2001 cf Lurton et al 2020),
  and instantaneous forcing with respect to 1850 can be computed as well.
  NEW (end 2020) :
	tutorial_prod can also run LMDZ coupled with the SPLA model
	(SimPLe Aerosol, activated with option aerosols=spla in setup.sh). 
	Emissions of dust and sea salt are then computed interactively.
        2021-05 : tutorial_prod OK, code LMDZ-SPLA OK, 
		regridding SPLA input files : work in progress

A configuration with isotopes is also available since 2023-04.
   
II. Files and scripts
===================================================================
----------------------------------------------------------------

CAREFUL: these scripts MUST be run from $STORE !!!!!

  untar the tutorial_prod.tar file in your $STORE;
  rename the TEST_PROD directory if you want to;
  then run everything from this newly created directory

     EXPERT :
     If the login groupe and computing allocation groupe are different :
       choose on which STORE space you work (login vs computing allocation);
       edit lmdz_env.sh, and set "groupe", "SCRATCHD" etc. accordingly.
     If you want to install the package in a dedicated folder instead of the root of $STORE:
       set STORED=$STORE/your_folder in lmdz_env.sh 
----------------------------------------------------------------

main.sh : a script written to pass options to the main script setup.sh

setup.sh : sets up one (series of) simulation(s) by editing the "job" script_SIMU
    When run with -init 1 options, creates INIT and LIMIT directories
    Run ./setup.sh -h   for options
    RECOMMENDATION: do not run it directly, but use main.sh to drive it
    
script_SIMU : script that is the basis for the job to run the simulations
    Automatically edited by setup.sh

reb.sh : to rebuild splitted outputfiles (parallelism with IOISPL)
    automatically run by script_SIMU

era2gcm_tuto.sh : to interpolate reanalysis onto the GCM grid, for nudging.
   To be run manually after the first use of main.sh

era2gcm_uv10m.nc : for option "aerosols=spla" only : 
     to interpolate reanalysis 10m-winds onto the GCM grid, for sea-salt (and dust) emissions.
        To be run manually after the first use of main.sh.

season.sh : computing seasonal means and daily time series

interp_aerosols.sh : interpolating aerosols on the GCM grid.
    Automatically run by setup.sh

post_season.sh : post processing a series of simulations with season.sh

test_ERAfiles_JeanZay.sh : script to test the availability of ERA* files sur Jean-Zay
    In case of nudging, one may use it before running era2gcm.sh		

DEF: .def files for simulations
   Some of them are changed by setup.sh or script_SIMU depending on chosen options
   Some others need to be chosen and customized BEFORE RUNNING the scripts (main.sh or setup.sh):
     DEF/config.def (versions *.def_* available): output files, frequencies, levels (see lines phys_out_file*)
     DEF/gcm.def (versions *.def_* available): grid (and grid-related) parameters
     DEF/guide.def : nudging parameters 

III. Known problems
===================

Running zoomed or coarse grid simulations
    May cause problems with routing and aerosols
    Suggesting to put in DEF/config.def
    ok_cdnc=n
    ok_ade=n
    ok_aie=n
    flag_aerosol=0
    and in DEF/orchidee*.def
    RIVER_ROUTING=n : because of this, it is set to n by default
    Be carefull, depending on the version of orchidee used, the job will
       choose the corresponding version of DEF/orchidee_6.*.def

IV. Updates (reverse chronological order)
=========================================

2023-07 (AS-FH-LF) : mise sous svn du repertoire TEST_PROD, renommé en "LMDZ_config"

2023-06 (AS) : Ajout de l'option "veget=7994", pour ORCHIDEE trunk correspondant à la config libIGCM LMDZOR_6.4work 
      	Le routage (méthode = simple) est désactivé par défaut ; 
      	il peut être activé comme décrit dans la section "ORCHIDEE-routage". 
	Le routage n’a pas été testé avec zoom.

2023-05 (AS) : optimisation du functionnement de l'option isotopes : tout géré par phys=lmdiso

2023-04 (S Nguyen) : introducing the option of running with isotopes)
	
2021-10 (AS): introducing the option of using the new snow scheme INLANDSIS (setup.sh)
	Option not active yet, E Vignon will take care of that.

2020 (AS): introducing the possibility to run with SPLA aerosol model 

24/03/2020 (FH): corrections for use with AMIP SSTs and monthly freq

V. TBD
======
See documentation (link of the shared google doc in the beginning of this Readme)


