!
! $Id: minmaxqfi.F90 4912 2024-04-19 13:32:15Z lebasn $
!
SUBROUTINE minmaxqfi(zq,qmin,qmax,comment)
  USE dimphy
  USE print_control_mod, ONLY: prt_level
  IMPLICIT NONE

! Entrees
  REAL,DIMENSION(klon,klev), INTENT(IN)   :: zq
  REAL,INTENT(IN)                         :: qmin,qmax
  CHARACTER(LEN=*),INTENT(IN)             :: comment

! Local  
  INTEGER,DIMENSION(klon)     :: jadrs 
  INTEGER                     :: i, jbad, k

  DO k = 1, klev
     jbad = 0
     DO i = 1, klon
        IF (zq(i,k).GT.qmax .OR. zq(i,k).LT.qmin) THEN
           jbad = jbad + 1
           jadrs(jbad) = i
        ENDIF
     ENDDO
     IF (jbad.GT.0) THEN
        WRITE(*,*)comment, "  k = ", k, "jbad > 0"
        if (prt_level >= 1) then
           DO i = 1, jbad
              WRITE(*,*) "i,q=", jadrs(i), zq(jadrs(i),k)
           ENDDO
        end if
     ENDIF
  ENDDO
  
END SUBROUTINE minmaxqfi
