#!/bin/bash

###
### This script (get_ERA.sh) extracts the data (u, v, ta, r, etc; see $VARS below) 
### from ERA5 reanalyses for a given date on your actual directory
### on spirit2 or spirit1, at IDRIS or on your PC (host=spirit2/IDRIS/local)
###
### Author : Ionela MUSAT, 1st April 2022

ana=$1
host=$2
mesologin=$3
resol=$4
freq=$5
ddt=$6
suf=$7
ndpd=$8
yr=$9
mth=${10}
day=${11}
hr=${12}
var=${13}

echo $var

if [ "${host}" == "ciclad" ] || [ "${host}" == "spirit2" ] || [ "${host}" == "spirit1 ]; then
din=/bdd/${ana}/NETCDF/${resol}/${freq}/${ddt}/${yr}
elif [ "${host}" == "IDRIS" ]; then
din=/gpfsstore/rech/psl/rpsl376/${ana}/NETCDF/${resol}/${freq}/${ddt}/${yr}
else
din=/bdd/${ana}/NETCDF/${resol}/${freq}/${ddt}/${yr}
fi

fin=${var}.${yr}${mth}.${suf}.${resol}.nc
fout=${var}.nc

let "nt = (${day} - 1)*${ndpd} + ${hr}/6 + 1"
echo $nt

if [ "${host}" == "ciclad" ] || [ "${host}" == "IDRIS" ] || [ "${host}" == "spirit2" ] || [ "${host}" == "spirit1 ]; then
  if [ ! -f ${fout} ]; then
    echo ncks -O -F -d time,${nt} ${din}/${fin} ${fout} 
    ncks -O -F -d time,${nt} ${din}/${fin} ${fout} 
  fi
else
  if [ "${mesologin}" != "" ]; then
    if [ ! -f ${fout} ]; then
      scp ${mesologin}@spirit2.ipsl.fr:${din}/${fin} .
      echo ncks -O -F -d time,${nt} ${fin} ${fout} 
      ncks -O -F -d time,${nt} ${fin} ${fout} 
    fi
  else
    echo
    echo Have to give your meso-center login as mesologin in 
    echo the get_ERA.sh script in order to be able 
    echo to get ERA5 data from IPSL meso-centre
    echo
    exit
  fi
fi

exit
