MODULE RADIATION_SETUP

! RADIATION_SETUP - Setting up modular radiation scheme
!
! AUTHOR
! ------
!   Robin Hogan, ECMWF
!   Original: 2015-09-16
!
! MODIFICATIONS
! -------------
!   Abderrahmane Idelkadi LMD, juillet 2023
!
!-----------------------------------------------------------------------

  USE PARKIND1,         ONLY : JPRB
  USE radiation_config, ONLY : config_type, &
       &                       ISolverMcICA, ISolverSpartacus, &
       &                       ILiquidModelSlingo, ILiquidModelSOCRATES, &
       &                       IIceModelFu, IIceModelBaran, IGasModelECCKD, &
       &                       IGasModelIFSRRTMG, IOverlapExponentialRandom

  USE radiation_interface,      ONLY : setup_radiation
  USE setup_config_from_lmdz,   ONLY : driver_config_type

  IMPLICIT NONE


  ! Ultraviolet weightings
  INTEGER         :: NWEIGHT_UV
  INTEGER         :: IBAND_UV(100)
  REAL(KIND=JPRB) :: WEIGHT_UV(100)
  ! Photosynthetically active radiation weightings
  INTEGER         :: NWEIGHT_PAR
  INTEGER         :: IBAND_PAR(100)
  REAL(KIND=JPRB) :: WEIGHT_PAR(100)

  ! Background aerosol is specified in an ugly way: using the old
  ! Tegen fields that are in terms of optical depth, and converted to
  ! mass mixing ratio via the relevant mass-extinction coefficient
  INTEGER, PARAMETER :: ITYPE_TROP_BG_AER = 8 ! hydrophobic organic
  INTEGER, PARAMETER :: ITYPE_STRAT_BG_AER=12 ! non-absorbing sulphate
  REAL(KIND=JPRB)    :: TROP_BG_AER_MASS_EXT
  REAL(KIND=JPRB)    :: STRAT_BG_AER_MASS_EXT

CONTAINS

  ! This routine copies information between the LMDZ radiation
  ! configuration (stored in global variables) and the radiation
  ! configuration of the modular radiation scheme (stored in
  ! rad_config).  The optional input logical LOUTPUT controls whether
  ! to print lots of information during the setup stage (default is
  ! no).
! AI At the end of the routine, the parameters are read in namelist
!    
  SUBROUTINE SETUP_RADIATION_SCHEME(LOUTPUT,file_name,rad_config,driver_config)

!    USE radiation_config, ONLY : config_type, &
!        &                       ISolverMcICA, ISolverSpartacus, &
!        &                       ILiquidModelSlingo, ILiquidModelSOCRATES, &
!        &                       IIceModelFu, IIceModelBaran, &
!        &                       IOverlapExponentialRandom
    USE mod_phys_lmdz_para
      
    USE YOMHOOK,  ONLY : LHOOK, DR_HOOK
    USE YOMLUN,   ONLY : NULOUT, NULERR
    USE YOESRTWN, ONLY : NMPSRTM

 !   USE radiation_interface,      ONLY : setup_radiation
 !   USE setup_config_from_lmdz,   ONLY : driver_config_type

    ! Whether or not to provide information on the radiation scheme
    ! configuration
    LOGICAL, INTENT(IN), OPTIONAL :: LOUTPUT

    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    character(len=512) :: file_name

    logical :: lprint_setp=.TRUE.

    ! Store configuration information for the radiation scheme in a
    ! global variable
    type(config_type) :: rad_config
    type(driver_config_type) :: driver_config

    IF (LHOOK) CALL DR_HOOK('RADIATION_SETUP:SETUP_RADIATION_SCHEME',0,ZHOOK_HANDLE)

    ! *** GENERAL SETUP ***

    ! Configure verbosity of setup of radiation scheme
 
    print*,'********** Dans radiation_setup *****************'

! AI ATTENTION (parameters read in namelist file)
!    file_name="namelist_ecrad"
    call rad_config%read(file_name=file_name)
    call driver_config%read(file_name)

    ! Use configuration data to set-up radiation scheme, including
    ! reading scattering datafiles
    CALL setup_radiation(rad_config)

    ! Populate the mapping between the 14 RRTM shortwave bands and the
    ! 6 albedo inputs. The mapping according to the stated wavelength
    ! ranges of the 6-band model does not match the hard-wired mapping
    ! in NMPSRTM, but only the hard-wired values produce sensible
    ! results...
    ! Note that NMPSRTM(:)=(/  6, 6, 5, 5, 5, 5, 5, 4, 4, 3, 2, 2, 1, 6 /)
! AI (6 albedo SW bands) 
    call rad_config%define_sw_albedo_intervals(6, &
       &  [0.25e-6_jprb, 0.44e-6_jprb, 0.69e-6_jprb, &
       &   1.19e-6_jprb, 2.38e-6_jprb], [1,2,3,4,5,6])
    ! Likewise between the 16 RRTM longwave bands and the 2 emissivity
    ! inputs (info taken from rrtm_ecrt_140gp_mcica.F90) representing
    ! outside and inside the window region of the spectrum
!     rad_config%i_emiss_from_band_lw = (/ 1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1 /)
! AI ATTENTION ?????
!!    call rad_config%define_lw_emiss_intervals(3, &
!!         &  (/ 8.0e-6_jprb,13.0e-6_jprb /),  (/ 1,2,1 /))

!    ! Get spectral weightings for UV and PAR
    call rad_config%get_sw_weights(0.2e-6_jprb, 0.4415e-6_jprb, &
         &  NWEIGHT_UV, IBAND_UV, WEIGHT_UV, 'ultraviolet')
    call rad_config%get_sw_weights(0.4e-6_jprb, 0.7e-6_jprb, &
         &  NWEIGHT_PAR, IBAND_PAR, WEIGHT_PAR, &
         &  'photosynthetically active radiation, PAR')

     rad_config%i_aerosol_type_map(1:13) = (/ &
           &  -1, & 
           &  -2, & 
           &  -3, & 
           &  -4, & 
           &  -5, & 
           &  -6, &
           &  -7, &
           &   1, &
           &   2, &
           &   3, &
           &  -8, &
           &  -9, &
           &   4 /)
!   rad_config%aerosol_optics_override_file_name = 'aerosol_optics_lmdz.nc'


    IF (LHOOK) CALL DR_HOOK('RADIATION_SETUP:SETUP_RADIATION_SCHEME',1,ZHOOK_HANDLE)

  END SUBROUTINE SETUP_RADIATION_SCHEME

END MODULE RADIATION_SETUP
