MODULE lmdz_thermcell_ini

IMPLICIT NONE

save


integer, protected :: dvdq=1,dqimpl=-1,prt_level=0,lunout
real   , protected :: RG,RD,RCPD,RKAPPA,RLVTT,RLvCp,RETV

!$OMP THREADPRIVATE(dvdq,dqimpl,prt_level,lunout)
!$OMP THREADPRIVATE(RG,RD,RCPD,RKAPPA,RLVTT,RLvCp)


! Parameters that can be modified directly by a getin call
real,    protected :: r_aspect_thermals=2.       ! Aspect ratio for thermal celles
real,    protected :: tau_thermals = 0.          ! relaxation time constant
real,    protected :: fact_thermals_ed_dz = 0.1  ! bouyancy computed with a delta
real,    protected :: betalpha=0.9               !
real,    protected :: afact=2./3.                !
real,    protected :: fact_shell=1.              !
real,    protected :: detr_min=1.e-5             !
real,    protected :: entr_min=1.e-5             !
real,    protected :: detr_q_coef=0.012          !
real,    protected :: detr_q_power=0.5           !
real,    protected :: mix0=0.                    !
integer, protected :: iflag_thermals_ed = 0      !
integer, protected :: iflag_thermals_optflux = 0 !
integer, protected :: iflag_thermals_closure = 1 !
integer, protected :: iflag_thermals_down = 0    !
real, protected    :: fact_thermals_down = 0.5   !
integer, protected :: thermals_flag_alim=0       !
integer, protected :: iflag_thermals_tenv=0      ! 

   ! WARNING !!! fact_epsilon is not protected. It can be modified in thermcell_plume*
   ! depending on other flags.

   real               :: fact_epsilon=0.002

!$OMP THREADPRIVATE(r_aspect_thermals,tau_thermals,fact_thermals_ed_dz)
!$OMP THREADPRIVATE(iflag_thermals_ed,iflag_thermals_optflux,iflag_thermals_closure)
!$OMP THREADPRIVATE(iflag_thermals_down)
!$OMP THREADPRIVATE(fact_thermals_down)
!$OMP THREADPRIVATE(fact_epsilon, betalpha, afact, fact_shell)
!$OMP THREADPRIVATE(detr_min, entr_min, detr_q_coef, detr_q_power)
!$OMP THREADPRIVATE( mix0, thermals_flag_alim)
!$OMP THREADPRIVATE(iflag_thermals_tenv)


CONTAINS

SUBROUTINE thermcell_ini(iflag_thermals,prt_level_in,tau_thermals_in,lunout_in, &
   &    RG_in,RD_in,RCPD_in,RKAPPA_in,RLVTT_in,RETV_in)

   USE ioipsl_getin_p_mod, ONLY : getin_p

integer, intent(in) :: iflag_thermals,prt_level_in,lunout_in
real, intent(in) :: RG_in,RD_in,RCPD_in,RKAPPA_in,RLVTT_in,RETV_in,tau_thermals_in

print*,'thermcell_ini'
      if (iflag_thermals==15.or.iflag_thermals==16) then
         dvdq=0
         dqimpl=-1
      else
         dvdq=1
         dqimpl=1
      endif
   prt_level=prt_level_in
   RG=RG_in
   RD=RD_in
   RCPD=RCPD_in
   RKAPPA=RKAPPA_in
   RLVTT=RLVTT_in
   RLvCp = RLVTT/RCPD
   RETV=RETV_in
   tau_thermals=tau_thermals_in
   lunout=lunout_in


!=====================================================================
! a la fois les vieilles param et thermcell_main :
!=====================================================================

   CALL getin_p('r_aspect_thermals',r_aspect_thermals)
   CALL getin_p('tau_thermals',tau_thermals)
   CALL getin_p('fact_thermals_ed_dz',fact_thermals_ed_dz)
   CALL getin_p('iflag_thermals_ed',iflag_thermals_ed)
   CALL getin_p('iflag_thermals_optflux',iflag_thermals_optflux)
   CALL getin_p('iflag_thermals_closure',iflag_thermals_closure)
   CALL getin_p('iflag_thermals_down',iflag_thermals_down)
   CALL getin_p('fact_thermals_down',fact_thermals_down)
   CALL getin_p('thermals_fact_epsilon',fact_epsilon)
   CALL getin_p('thermals_betalpha',betalpha)
   CALL getin_p('thermals_afact',afact)
   CALL getin_p('thermals_fact_shell',fact_shell)
   CALL getin_p('thermals_detr_min',detr_min)
   CALL getin_p('thermals_entr_min',entr_min)
   CALL getin_p('thermals_detr_q_coef',detr_q_coef)
   CALL getin_p('thermals_detr_q_power',detr_q_power)
   CALL getin_p('thermals_mix0',mix0)
   CALL getin_p('thermals_flag_alim',thermals_flag_alim)
   CALL getin_p('iflag_thermals_tenv',iflag_thermals_tenv)



write(lunout,*) 'thermcell_ini ,prt_level                =',  prt_level                   
write(lunout,*) 'thermcell_ini ,RG                       =',  RG                      
write(lunout,*) 'thermcell_ini ,RD                       =',  RD                       
write(lunout,*) 'thermcell_ini ,RCPD                     =',  RCPD                    
write(lunout,*) 'thermcell_ini ,RKAPPA                   =',  RKAPPA                  
write(lunout,*) 'thermcell_ini ,RLVTT                    =',  RLVTT                   
write(lunout,*) 'thermcell_ini ,RLvCp                    =',  RLvCp                   
write(lunout,*) 'thermcell_ini ,RETV                     =',  RETV                    
write(lunout,*) 'thermcell_ini ,tau_thermals             =',  tau_thermals            
write(lunout,*) 'thermcell_ini ,lunout                   =',  lunout                  
write(lunout,*) 'thermcell_ini ,r_aspect_thermals        =',  r_aspect_thermals       
write(lunout,*) 'thermcell_ini ,tau_thermals             =',  tau_thermals            
write(lunout,*) 'thermcell_ini ,fact_thermals_ed_dz      =',  fact_thermals_ed_dz
write(lunout,*) 'thermcell_ini ,fact_thermals_ed_dz      =',  fact_thermals_ed_dz
write(lunout,*) 'thermcell_ini ,iflag_thermals_ed        =',  iflag_thermals_ed       
write(lunout,*) 'thermcell_ini ,iflag_thermals_optflux   =',  iflag_thermals_optflux
write(lunout,*) 'thermcell_ini ,iflag_thermals_closure   =',  iflag_thermals_closure
write(lunout,*) 'thermcell_ini ,iflag_thermals_down      =',  iflag_thermals_down
write(lunout,*) 'thermcell_ini ,fact_thermals_down       =',  fact_thermals_down
write(lunout,*) 'thermcell_ini ,fact_epsilon             =',  fact_epsilon            
write(lunout,*) 'thermcell_ini ,betalpha                 =',  betalpha                
write(lunout,*) 'thermcell_ini ,afact                    =',  afact                   
write(lunout,*) 'thermcell_ini ,fact_shell               =',  fact_shell              
write(lunout,*) 'thermcell_ini ,detr_min                 =',  detr_min                
write(lunout,*) 'thermcell_ini ,entr_min                 =',  entr_min                
write(lunout,*) 'thermcell_ini ,detr_q_coef              =',  detr_q_coef             
write(lunout,*) 'thermcell_ini ,detr_q_power             =',  detr_q_power            
write(lunout,*) 'thermcell_ini ,mix0                     =',  mix0                    
write(lunout,*) 'thermcell_ini ,thermals_flag_alim       =',  thermals_flag_alim
write(lunout,*) 'thermcell_ini ,iflag_thermals_tenv      =',  iflag_thermals_tenv

 RETURN

END SUBROUTINE thermcell_ini
END MODULE lmdz_thermcell_ini
