!
! $Id: minmaxqfi.F90 4795 2024-02-01 15:53:24Z nfevrier $
!
SUBROUTINE minmaxqfi(zq,qmin,qmax,comment,it)
  USE dimphy
  USE print_control_mod, ONLY: prt_level
  USE infotrac_phy, ONLY: nbtr, type_trac, conv_flg, solsym
  IMPLICIT NONE

! Entrees
  REAL,DIMENSION(klon,klev), INTENT(IN)   :: zq
  REAL,INTENT(IN)                         :: qmin,qmax
  CHARACTER(LEN=*),INTENT(IN)             :: comment
  INTEGER,INTENT(IN)                      :: it

! Local  
  INTEGER,DIMENSION(klon)     :: jadrs 
  INTEGER                     :: i, jbad, k

  DO k = 1, klev
     jbad = 0
     DO i = 1, klon
        IF (zq(i,k).GT.qmax .OR. zq(i,k).LT.qmin) THEN
           jbad = jbad + 1
           jadrs(jbad) = i
        ENDIF
     ENDDO
     IF ((jbad.GT.0) .AND. ((TRIM(solsym(it))=='AIBCM') .OR. (TRIM(solsym(it))=='ASBCM'))) THEN ! Nicolas Février : alerte seulement si le BC est concerné
        WRITE(*,*)comment, "k = ", k, "jbad > 0"
        if (prt_level >= 1) then ! Nicolas Février on print tout
           DO i = 1, jbad
              WRITE(*,*) "i,q=", jadrs(i), zq(jadrs(i),k)
           ENDDO
        end if
     ENDIF
  ENDDO

END SUBROUTINE minmaxqfi
