#!/bin/bash

################################################################
# Complément d'installation Ubuntu22
# Frédéric Hourdin.
#
# Developpe et utilise a fins personnelles et pour les PCs
# enseignement.
# Permet de faire tourner entre autres LMDZ et les outils HighTune
################################################################

base=1
compilation=1
hightune=1
bureautique=1
latex=1
graphique=1
ferret=1
system=1
son=0
acroread=1
workspace_matrix=0
miniconda=1
panoply=1
cours_m2=1

install="sudo apt install -y"
sudo apt update
sudo apt upgrade

#===============================================================================
if [ $base = 1 ] ; then
    # Base :
    # ======
    $install locate
    $install ncftp vim nfs-common
    # keychain semble etre devenu obsolete.
    # ksh et csh inutile ?
    for file in /home/*/.bashrc ; do
        cat >> $file <<........eod
        alias rm='rm -i'
        alias cp='cp -i'
        alias mv='mv -i'
........eod
    done
fi
#===============================================================================
if [ $compilation = 1 ] ; then
    # Pour compilation dont LMDZ
    # ==========================
    $install cdo nco netcdf-bin libnetcdf-dev libnetcdff-dev ncview   # netcdf
    $install gfortran g++ libblas-dev subversion git git-lfs   # fortran et svn
    $install openmpi-common libopenmpi-dev openmpi-bin # openmpi
    $install make cmake
fi
#===============================================================================
if [ $hightune = 1 ] ; then
    # Pour HitghTune
    # ==============
    $install r-base
    $install pip
    $install python3-pip
fi
#===============================================================================
if [ $bureautique = 1 ] ; then
    # bureautique
    # ===========
    $install xournal
    $install unoconv # conversion associee a libreoffice
    $install dos2unix
    $install qpdfview # un visualiseur remplissant mieux les pdf
    $install pdftk # Autre package de concatenation de pdf
    $install chromium-browser
    $install pandoc # markdown
fi
#===============================================================================
if [ $latex = 1 ] ; then
    # LaTeX dont pdfjam
    # =================
    $install texlive-base texlive-latex-extra texlive-lang-french latexdiff  texlive-publishers
    $install latexmk texlive-science
    $install latex2html
    $install texlive-extra-utils texlive-font-utils # pdfjam
fi
#===============================================================================
if [ $graphique = 1 ] ; then
    # graphique / video
    # =================
    $install xfig grads imagemagick gv grace           # graphique
    $install inkscape gimp                             # dessin
    $install gifsicle
    $install ffmpeg
    $install winff  # autre convertisseur video
fi
#===============================================================================
if [ $ferret = 1 ] ; then
    $install ferret-vis ferret-datasets
    # Finalisation de l'installation de ferret-vis
    # ============================================
    # Active le bon environnement pour ferret
    # Attention, pour que ca fonctionne completement (notamment le trace
    # des frontieres) il manque des données.
    # Pour le moment, on va chercher ces données dans le répertoire de
    # l'installation conda. On a donc une double installation
    for file in /home/*/.bashrc ; do
        sed -i'' -e '/ferret-vis/d' $file
        cat <<........eod>> $file
        . /usr/share/ferret-vis/bin/ferret_paths # ferret-vis
        alias ferret=ferret_c
        export FER_DATA=". \$FER_DATA"
........eod
    done
    cd /tmp
    wget http://www.lmd.jussieu.fr/~lmdz/data_ferret.tar
    cd /usr/share/ferret-vis
    sudo tar xvf /tmp/data_ferret.tar
fi
#===============================================================================
if [ $system = 1 ] ; then
    # Outils systeme / collaboratifs
    # ==============================
    $install traceroute # aide systeme
    $install synaptic gdebi                            # install paquets
    $install tmate
fi
#===============================================================================
if [ $son = 1 ] ; then
    # Son
    #=====
    $install audacity
fi
#===============================================================================
if [ $acroread = 1 ] ; then
    # Acroread
    # ========
    sudo dpkg --add-architecture i386
    $install libxml2:i386 libcanberra-gtk-module:i386 gtk2-engines-murrine:i386
    $install libatk-adaptor:i386 libgdk-pixbuf2.0-0:i386
    wget -O /tmp/adobe.deb ftp://ftp.adobe.com/pub/adobe/reader/unix/9.x/9.5.5/enu/AdbeRdr9.5.5-1_i386linux_enu.deb
    sudo dpkg -i /tmp/adobe.deb
fi
#===============================================================================
if [ $workspace_matrix = 1 ] ; then 
    # Firefox
    # =======
    # Reinstallation d’une version de firefox pour permettre le multigrille
    # https://ubuntuhandbook.org/index.php/2022/04/install-firefox-deb-ubuntu-22-04/
    sudo snap remove firefox
    sudo apt remove firefox
    sudo add-apt-repository ppa:mozillateam/ppa
    sudo cat <<....eod> /tmp/mozillateamppa
    Package: firefox*
    Pin: release o=LP-PPA-mozillateam
    Pin-Priority: 501
....eod
    sudo cp /tmp/mozillateamppa /etc/apt/preferences.d/
    sudo apt install -y chrome-gnome-shell
    sudo apt install -y firefox
    
    echo Run firefox https://extensions.gnome.org/extension/1485/workspace-matrix/
    echo first clicks in the top frame, install gnome extension, or so.
    echo then reload browser
    echo then click on the OFF button
fi

#===============================================================================
if [ $miniconda = 1 ] ; then 
   cd /tmp
   wget https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh
   cd
   # Option -b pour installer sans repondre aux droits
   bash /tmp/Miniconda3-latest-Linux-x86_64.sh -b
   export PATH=~/miniconda3/bin:$PATH
   conda activater ; conda init ; conda deactivate
   #conda init --reverse bash
   conda create -n FERRET -c conda-forge pyferret ferret_datasets --yes
   \rm -f Miniconda3-latest-Linux-x86_64.sh
   wget http://www.lmd.jussieu.fr/~hourdin/COURS/UTILS/environment.yaml
   if [ $cours_m2 ] ; then
      conda env create -f environment.yaml
      \rm -f environment.yaml
   fi
fi

#===============================================================================
if [ $panoply = 1 ] ; then 
    cd
    sudo apt-get install openjdk-11-jre
    wget https://www.giss.nasa.gov/tools/panoply/download/PanoplyJ-5.3.0.tgz
    tar xvzf PanoplyJ-5.3.0.tgz
    \rm -f PanoplyJ-5.3.0.tgz
    cd PanoplyJ/
    # ./panoply.sh devrait ouvrir la fenêtre Panoply
fi
