# Script pour tester la presence de fichiers de guidage ERA* sur Jean-Zay
# 2021/04/15 
# A. Sima (adriana.sima@lmd.ipsl.fr)


#####################################################################
# A choisir par l'utilisateur :
#####################################################################

# Guidage en vent(u&v) et/ou temperature, humidite
guide_uv=y
guide_t=y
guide_q=y

an=2000
mois=01
#
# Choix des "rea"nalyses : ERA5, ERAI, OPERA
rea=ERA5


#####################################################################
# Lien avec les fichiers netcdf contenant les d0 ECMWF 
#####################################################################
   echo -------- liens de telechargement a actualiser ----
   if [ "$rea" = "ERA5" ] ; then
     if [ $an -le 2021 ] ; then 
      ANA_DIR='/gpfsstore/rech/psl/rpsl376/ergon/ERA5/NETCDF/GLOBAL_025/4xdaily'
      suf="aphe5.GLOBAL_025"
     else
      ANA_DIR='/gpfsstore/rech/psl/rpsl376/ergon/ERA5/NETCDF/GLOBAL_025/hourly'
      suf="ap1e5.GLOBAL_025"
     fi 
   elif [ "$rea" = "ERAI" ] ; then
      #ANA_DIR='http://prodn.idris.fr/thredds/dodsC/ipsl_private/rpsl376/ERAI/NETCDF/GLOBAL_1125/4xdaily'
      ANA_DIR='/gpfsstore/rech/psl/rpsl376/ergon/ERAI/NETCDF/GLOBAL_1125/4xdaily'
      #/gpfsstore/rech/psl/rpsl376/ergon/ERAI/NETCDF/GLOBAL_075/4xdaily/AN_PL/2006/u.200601.aphei.GLOBAL_075.nc 
      suf="aphei.GLOBAL_1125"
   else  #OPERA
      #ANA_DIR='http://prodn.idris.fr/thredds/dodsC/ipsl_private/rpsl376/OPERA/NETCDF/4xdaily'
      ANA_DIR='/gpfsstore/rech/psl/rpsl376/ergon/OPERA/NETCDF/4xdaily'
      suf="aph.GLOBAL_1125"
   fi

varu=u
varv=v
vart=ta # peut etre parfois juste "t"
varq=q
#varp=msl

if [ "$rea" = "ERAI" ] ; then
  # variables en format "short" doivent etre transformees en "float" via NCO 
  # This is done here with ncap2 ; also possible: "ncpdq --overwrite --unpack fin.nc fout.nc"
  fushort="$ANA_DIR/AN_PL/$an/u.$an$mois.$suf.nc"
  fvshort="$ANA_DIR/AN_PL/$an/v.$an$mois.$suf.nc"
  ftshort="$ANA_DIR/AN_PL/$an/ta.$an$mois.$suf.nc"
  fileu="$SCRATCH/u.$an$mois.$suf.nc"
  filev="$SCRATCH/v.$an$mois.$suf.nc"
  filet="$SCRATCH/ta.$an$mois.$suf.nc"
  ncap2 -s 'u=float(u)' $fushort $fileu
  ncap2 -s 'v=float(v)' $fvshort $filev
  ncap2 -s 'ta=float(ta)' $ftshort $filet
  #fileq pas teste ; a faire pour fileq aussi ?
  fileq="$ANA_DIR/AN_PL/$an/r.$an$mois.$suf.nc"
elif [ "$rea" = "ERA5" -a $an -ge 2022 ] ; then
  fu1h="$ANA_DIR/AN_PL/$an/u.$an$mois.$suf.nc"
  fv1h="$ANA_DIR/AN_PL/$an/v.$an$mois.$suf.nc"
  ft1h="$ANA_DIR/AN_PL/$an/ta.$an$mois.$suf.nc"
  fq1h="$ANA_DIR/AN_PL/$an/r.$an$mois.$suf.nc"
  fileu="$SCRATCH/u.$an$mois.$suf.nc"
  filev="$SCRATCH/v.$an$mois.$suf.nc"
  filet="$SCRATCH/ta.$an$mois.$suf.nc"
  fileq="$SCRATCH/r.$an$mois.$suf.nc"
  cdo selhour,0,6,12,18 $fu1h $fileu
  cdo selhour,0,6,12,18 $fv1h $filev
  cdo selhour,0,6,12,18 $ft1h $filet
  cdo selhour,0,6,12,18 $fq1h $fileq
else
 fileu="$ANA_DIR/AN_PL/$an/u.$an$mois.$suf.nc"
 filev="$ANA_DIR/AN_PL/$an/v.$an$mois.$suf.nc"
 filet="$ANA_DIR/AN_PL/$an/ta.$an$mois.$suf.nc"
 fileq="$ANA_DIR/AN_PL/$an/r.$an$mois.$suf.nc"
fi

# verifier disponibilite des fichiers
if [ "$guide_uv" = "y" ] ; then  ls $fileu ; ls $filev ; fi
if [ "$guide_t" = "y" ] ; then  ls $filet ; fi
if [ "$guide_q" = "y" ] ; then  ls $fileq ; fi
