#!/bin/bash -vx
# Par exemple:
# ./make_axe4.sh V6.5AIS8

local=`pwd`
source ${local}/env_Multi_atlas_axe4.sh
# -----------------------------------------------------------------

if [ $# -ne 1 ]
then
  echo "Example: ./make_axe4.sh V6.5AIS8"
exit
fi

# -----------------------------------------------------------------
# Based on /home/fabric/LMDZ/UTILS/config.sh

comp=$1

COMP_D=$MULTIDIR/$comp
runstxt=${local}/runs.txt
if [ ! -d $COMP_D ] ; then echo "$COMP_D not found" && exit ; fi

# Liste des simulations de la comparasion $comp
# -----------------------------------------------------------------
liste_sim=""
DEF_FILE=$COMP_D/def.txt
for s in `awk ' {print $1} ' $DEF_FILE` ; do liste_sim="$liste_sim $s" ; done

# -----------------------------------------------------------------
# Comparaison to CloudSat precipitation rates over Antarctica
# -----------------------------------------------------------------

outputdir=$COMP_D/AXE4/PRECIP/PNG
if [ ! -d $outputdir ]
then
  mkdir -pv $outputdir
else
  echo "$outputdir has been found."
fi

# PLOT OBSERVED PRECIP
cmdtmp="${local}/AXE4/make_axe4-map-precip-obs.py -o $outputdir"
echo $cmdtmp
$cmdtmp

# PLOT SIMULATION RESULTS
if [ 0 = 0 ] ; then
for sim in  $liste_sim ; do
  years=`grep '^'$sim' ' $DEF_FILE | awk ' { print $2 }'`
  echo FICHIERS POUR LA SIMULATION $sim annees $years
  simdir=`grep -w "^$sim "  $runstxt | awk ' { print $2 } '`
  run=`basename $simdir `
  input=$SEORIG/${run}_SE_${years}_1M_histmth.nc
  if [ -e $input ]
  then
    cmdtmp="${local}/AXE4/make_axe4-map-precip.py -i $input -o $outputdir"
    echo $cmdtmp 
    $cmdtmp
    cmdtmp="${local}/AXE4/make_axe4-map-precip_newcoord.py -i $input -o $outputdir"
    echo $cmdtmp 
    $cmdtmp
  else
    echo $input' file not found'
  fi
# -----------------------------------------------------------------
done
fi
 

# -----------------------------------------------------------------
# Comparaison to Dome C temperatures (40m mast)
# -----------------------------------------------------------------

outputdir=$COMP_D/AXE4/TZ1DC/PNG
if [ ! -d $outputdir ]
then
  mkdir -pv $outputdir
else
  echo "$outputdir has been found."
fi

# PLOT SIMULATION RESULTS
for sim in  $liste_sim ; do
  years=`grep '^'$sim' ' $DEF_FILE | awk ' { print $2 }'`
  echo FICHIERS POUR LA SIMULATION $sim annees $years
  simdir=`grep -w "^$sim "  $runstxt | awk ' { print $2 } '`
  run=`basename $simdir ` 
  input=$SEORIG/${run}_SE_${years}_1M_histmth.nc
  if [ -e $input ]
  then
    cmdtmp="${local}/AXE4/make_axe4-temp-DC-mast.py -i $input -o $outputdir"
    echo $cmdtmp 
    $cmdtmp
    cd ${local}/AXE4/ETIENNE3/
    echo ./plot.sh -i $input -o $outputdir 
    ./plot.sh -i $input -o $outputdir 
    cd ${local}
  else
    echo $input' file not found'
  fi
# -----------------------------------------------------------------
done

