c******************************************************
      SUBROUTINE   interp_vert(varo,varn,lmo,lmn,sigmo,sigmn,Nhoriz)
c
c interpolation lineaire pour passer
c a une nouvelle discretisation verticale pour
c les variables de GCM
c Francois Forget (01/1995)
c**********************************************************

      IMPLICIT NONE

c   Declarations:
c ==============
c
c  ARGUMENTS
c  """""""""

       integer lmo ! dimensions ancienne couches (input)
       integer lmn ! dimensions nouvelle couches (input)

       real sigmo(lmo) ! niveau des variables dans les anciennes coord
       real sigmn(lmn) ! niveau des variables dans les nouvelles coord

       integer Nhoriz ! nombre de point horizontale (input)

       real varo(Nhoriz,lmo) ! var dans l'ancienne grille (input)
       real varn(Nhoriz,lmn) ! var dans la nouvelle grille (output)

c Autres variables
c """"""""""""""""
       integer n, ln ,lo 
       real coef

c run
c ====
      do ln=1,lmn
        if (sigmn(ln).ge.sigmo(1))then
           do n=1,Nhoriz
             varn(n,ln) =  varo(n,1)  
           end do  
        else if (sigmn(ln).le.sigmo(lmo)) then
           do n=1,Nhoriz
             varn(n,ln) =  varo(n,lmo)
           end do
        else
           do lo =1,lmo-1 
             if ( (sigmn(ln).le.sigmo(lo)).and.
     &          (sigmn(ln).gt.sigmo(lo+1)) )then
               coef = (sigmn(ln)-sigmo(lo))/(sigmo(lo+1)-sigmo(lo))
               do n=1,Nhoriz
                 varn(n,ln)=varo(n,lo) +coef*(varo(n,lo+1)-varo(n,lo))
               end do
             end if
           end do           
        end if
      end do
      return
      end    
