      SUBROUTINE adv_hor(h,pbaru,pbarv,dh,lfiltre)
      IMPLICIT NONE

c=======================================================================
c
c   Auteur:  P. Le Van
c   -------
c
c   ********************************************************************
c   .... calcul du terme de convergence horizontale du flux d'enthalpie
c        potentielle   ......
c   ********************************************************************
c     h,pbaru et pbarv sont des arguments d'entree  pour le s-pg ....
c     dh 	       sont des arguments de sortie pour le s-pg ....
c
c=======================================================================


#include "dimensions.h"
#include "paramet.h"
#include "logic.h"

      REAL h( ip1jmp1,llm ),pbaru( ip1jmp1,llm ),pbarv( ip1jm,llm)
      REAL dh( ip1jmp1,llm )
      INTEGER   l,ij

      REAL hbyv( ip1jm,llm ), hbxu( ip1jmp1,llm )

      EXTERNAL     convflu
      EXTERNAL     filtreg
      LOGICAL lfiltre


      DO l = 1,llm
         DO ij = iip2, ip1jm - 1
            hbxu(ij,l) = pbaru(ij,l) * 0.5 * ( h(ij,l) + h(ij+1,l) )
         ENDDO
         DO ij=1,ip1jm
            hbyv(ij,l)=pbarv(ij,l)*0.5*(h(ij, l)+h(ij+iip1,l))
         ENDDO
      ENDDO

c    .... correction pour  hbxu(iip1,j,l)  .....
c    ....   hbxu(iip1,j,l)= hbxu(1,j,l) ....
      CALL SCOPY(jjp1*llm,hbxu(iip1+iip1,1),iip1,hbxu(iip1+1,1),iip1)

      CALL  convflu ( hbxu, hbyv, llm, dh )

      IF (lfiltre) CALL filtreg(dh,jjp1,llm,2,2,.true.,1)

      RETURN
      END
