MODULE lmdz_cloud_optics_prop_ini
  IMPLICIT NONE

  SAVE

  INTEGER, PROTECTED :: prt_level, lunout
  INTEGER, PROTECTED :: flag_aerosol
  INTEGER, PROTECTED :: iflag_t_glace=0
  LOGICAL, PROTECTED ::ok_cdnc
  REAL, PROTECTED :: bl95_b0, bl95_b1 ! Parameter in B&L 95-Formula
  REAL, ALLOCATABLE :: latitude_deg(:)
  !$OMP THREADPRIVATE(latitude_deg)
  REAL, PROTECTED :: cdnc_max=-1.
  REAL, PROTECTED :: cdnc_max_m3=-1.
  REAL, PROTECTED :: cdnc_min=-1.
  REAL, PROTECTED :: cdnc_min_m3=-1.
  
CONTAINS

  SUBROUTINE cloud_optics_prop_ini(klon, prt_level_in, lunout_in, flag_aerosol_in, &
       & ok_cdnc_in, bl95_b0_in, &
       & bl95_b1_in, latitude_deg_in)

    USE ioipsl_getin_p_mod, ONLY : getin_p

    IMPLICIT NONE
    INTEGER, INTENT(IN) :: klon
    INTEGER, INTENT(IN) :: prt_level_in, lunout_in
    INTEGER, INTENT(IN) :: flag_aerosol_in
    LOGICAL, INTENT(IN) :: ok_cdnc_in
    REAL, INTENT(IN) :: bl95_b0_in, bl95_b1_in
    REAL, INTENT(IN) :: latitude_deg_in(klon)

    ALLOCATE(latitude_deg(klon))

    prt_level = prt_level_in
    lunout = lunout_in
    flag_aerosol = flag_aerosol_in
    ok_cdnc = ok_cdnc_in
    bl95_b0 = bl95_b0_in
    bl95_b1 = bl95_b1_in
    latitude_deg(:) = latitude_deg_in(:)
    call getin_p('cdnc_min',cdnc_min)
    cdnc_min_m3=cdnc_min*1.E6
    IF (cdnc_min_m3<0.) cdnc_min_m3=20.E6 ! astuce pour retrocompatibilite
    write(lunout,*)'cdnc_min=', cdnc_min_m3/1.E6
    call getin_p('cdnc_max',cdnc_max)
    cdnc_max_m3=cdnc_max*1.E6
    IF (cdnc_max_m3<0.) cdnc_max_m3=1000.E6 ! astuce pour retrocompatibilite
    write(lunout,*)'cdnc_max=', cdnc_max_m3/1.E6
    CALL getin_p('iflag_t_glace',iflag_t_glace)      
    write(lunout,*)'iflag_t_glace= ',iflag_t_glace
    
  END SUBROUTINE cloud_optics_prop_ini

END MODULE lmdz_cloud_optics_prop_ini
