! $Id: physiq.F 1565 2011-08-31 12:53:29Z jghattas $
MODULE physiqex_mod

IMPLICIT NONE

CONTAINS

      SUBROUTINE physiqex (nlon,nlev, &
     &            debut,lafin,pdtphys, &
     &            paprs,pplay,pphi,pphis,presnivs, &
     &            u,v,rot,temp,qx, &
     &            flxmass_w, &
     &            d_u, d_v, d_t, d_qx, d_ps)


USE dimphy, only : klon,klev
USE infotrac_phy, only : nqtot
USE geometry_mod, only : latitude
USE ioipsl, only : ymds2ju
USE phys_state_var_mod, only : phys_state_var_init
USE phyetat0_mod, only: phyetat0
USE output_physiqex_mod, ONLY: output_physiqex
use vdif_ini, only : vdif_ini_
USE lmdz_thermcell_ini, ONLY : thermcell_ini
USE ioipsl_getin_p_mod, ONLY : getin_p
USE wxios, ONLY: missing_val, using_xios
USE lscp_mod, ONLY : lscp
USE lscp_ini_mod, ONLY : lscp_ini
USE add_phys_tend_mod, ONLY : add_phys_tend


      IMPLICIT none

include "YOETHF.h"




!
! Routine argument:
!

      integer,intent(in) :: nlon ! number of atmospheric colums
      integer,intent(in) :: nlev ! number of vertical levels (should be =klev)
      logical,intent(in) :: debut ! signals first call to physics
      logical,intent(in) :: lafin ! signals last call to physics
      real,intent(in) :: pdtphys ! physics time step (s)
      real,dimension(klon,klev+1),intent(in) :: paprs ! interlayer pressure (Pa)
      real,dimension(klon,klev),intent(in) :: pplay ! mid-layer pressure (Pa)
      real,dimension(klon,klev),intent(in) :: pphi ! geopotential at mid-layer
      real,dimension(klon),intent(in) :: pphis ! surface geopotential
      real,dimension(klev),intent(in) :: presnivs ! pseudo-pressure (Pa) of mid-layers
      real,dimension(klon,klev),intent(in) :: u ! eastward zonal wind (m/s)
      real,dimension(klon,klev),intent(in) :: v ! northward meridional wind (m/s)
      real,dimension(klon,klev),intent(in) :: rot ! northward meridional wind (m/s)
      real,dimension(klon,klev),intent(in) :: temp ! temperature (K)
      real,dimension(klon,klev,nqtot),intent(in) :: qx  ! tracers (.../kg_air)
      real,dimension(klon,klev),intent(in) :: flxmass_w ! vertical mass flux
      real,dimension(klon,klev),intent(out) :: d_u ! physics tendency on u (m/s/s)
      real,dimension(klon,klev),intent(out) :: d_v ! physics tendency on v (m/s/s)
      real,dimension(klon,klev),intent(out) :: d_t ! physics tendency on t (K/s)
      real,dimension(klon,klev,nqtot),intent(out) :: d_qx ! physics tendency on tracers
      real,dimension(klon),intent(out) :: d_ps ! physics tendency on surface pressure

      real, dimension(klon,klev) :: u_loc
      real, dimension(klon,klev) :: v_loc
      real, dimension(klon,klev) :: t_loc
      real, dimension(klon,klev) :: h_loc
      real, dimension(klon,klev) :: d_u_loc,d_v_loc,d_t_loc,d_h_loc

      real, dimension(klon,klev) :: d_u_dyn,d_v_dyn,d_t_dyn
      real, dimension(klon,klev,nqtot) :: d_q_dyn
      real, allocatable, dimension(:,:), save :: u_prev,v_prev,t_prev
      real, allocatable, dimension(:,:,:), save :: q_prev
!$OMP THREADPRIVATE(u_prev,v_prev,t_prev,q_prev)



      real, dimension(klon,klev) :: d_u_vdif,d_v_vdif,d_t_vdif,d_h_vdif
      real, dimension(klon,klev) :: d_u_the,d_v_the,d_t_the
      real, dimension(klon,klev,nqtot) :: q_loc,d_q_loc,d_q_vdif,d_q_the

real, dimension(klon) :: capcal,z0m,z0h,dtsrf,emis,fluxsrf,cdh,cdv,tsrf_
real, dimension(klon,klev) :: zzlay,masse,zpopsk
real, dimension(klon,klev+1) :: zzlev,kz_v,kz_h,richardson

real, save, allocatable, dimension(:) :: tsrf,f0,zmax0
real, save, allocatable, dimension(:,:) :: q2
!$OMP THREADPRIVATE(tsrf,q2,f0,zmax0)

    real,save :: ratqsbas=0.002,ratqshaut=0.3,ratqsp0=50000.,ratqsdp=20000.
    !$OMP THREADPRIVATE(ratqsbas,ratqshaut,ratqsp0,ratqsdp)


real :: z1,z2,tau_thermals
logical :: lwrite
integer :: iflag_replay

integer :: iflag_thermals=18

!--------------------------------------------------------------
! Declaration lscp
!--------------------------------------------------------------
  INTEGER                         :: iflag_cld_th    ! flag that determines the distribution of convective clouds    ! IN
  INTEGER                         :: iflag_ice_thermo! flag to activate the ice thermodynamics                       ! IN
  LOGICAL                         :: ok_ice_sursat   ! flag to determine if ice sursaturation is activated           ! IN
  LOGICAL, DIMENSION(klon,klev)   :: ptconv          ! grid points where deep convection scheme is active            ! IN
  REAL, DIMENSION(klon,klev)      :: ztv             ! virtual potential temperature [K]                             ! IN
  REAL, DIMENSION(klon,klev)      :: zqta            ! specific humidity within thermals [kg/kg]                     ! IN
  REAL, DIMENSION(klon,klev+1)      :: frac_the,fm_the
  REAL, DIMENSION(klon,klev)      :: zpspsk          ! exner potential (p/100000)**(R/cp)                            ! IN
  REAL, DIMENSION(klon,klev)      :: ztla            ! liquid temperature within thermals [K]                        ! IN
  REAL, DIMENSION(klon,klev)         :: zthl         ! liquid potential temperature [K]                              ! INOUT
  REAL, DIMENSION(klon,klev)      :: ratqs            ! function of pressure that sets the large-scale               ! INOUT
  REAL, DIMENSION(klon,klev)      :: beta             ! conversion rate of condensed water                           ! INOUT
  REAL, DIMENSION(klon,klev)      :: rneb_seri        ! fraction nuageuse en memoire                                 ! INOUT
  REAL, DIMENSION(klon,klev)      :: d_t_lscp         ! temperature increment [K]                                    ! OUT
  REAL, DIMENSION(klon,klev)      :: d_q_lscp         ! specific humidity increment [kg/kg]                          ! OUT
  REAL, DIMENSION(klon,klev)      :: d_ql_lscp        ! liquid water increment [kg/kg]                               ! OUT
  REAL, DIMENSION(klon,klev)      :: d_qi_lscp        ! cloud ice mass increment [kg/kg]                             ! OUT
  REAL, DIMENSION(klon,klev)      :: rneb             ! cloud fraction [-]                                           ! OUT
  REAL, DIMENSION(klon,klev)      :: rneblsvol        ! cloud fraction per unit volume [-]                           ! OUT
  REAL, DIMENSION(klon,klev)      :: pfraclr          ! precip fraction clear-sky part [-]                           ! OUT
  REAL, DIMENSION(klon,klev)      :: pfracld          ! precip fraction cloudy part [-]                              ! OUT
  REAL, DIMENSION(klon,klev)      :: radocond         ! condensed water used in the radiation scheme [kg/kg]         ! OUT
  REAL, DIMENSION(klon,klev)      :: radicefrac       ! ice fraction of condensed water for radiation scheme         ! OUT
  REAL, DIMENSION(klon,klev)      :: rhcl             ! clear-sky relative humidity [-]                              ! OUT
  REAL, DIMENSION(klon)           :: rain             ! surface large-scale rainfall [kg/s/m2]                       ! OUT
  REAL, DIMENSION(klon)           :: snow             ! surface large-scale snowfall [kg/s/m2]                       ! OUT
  REAL, DIMENSION(klon,klev)      :: qsatl            ! saturation specific humidity wrt liquid [kg/kg]              ! OUT
  REAL, DIMENSION(klon,klev)      :: qsats            ! saturation specific humidity wrt ice [kg/kg]                 ! OUT
  REAL, DIMENSION(klon,klev+1)    :: prfl             ! large-scale rainfall flux in the column [kg/s/m2]            ! OUT
  REAL, DIMENSION(klon,klev+1)    :: psfl             ! large-scale snowfall flux in the column [kg/s/m2]            ! OUT
  REAL, DIMENSION(klon,klev)      :: distcltop        ! distance to cloud top [m]                                    ! OUT
  REAL, DIMENSION(klon,klev)      :: temp_cltop       ! temperature of cloud top [K]                                 ! OUT
  REAL, DIMENSION(klon,klev)      :: frac_impa        ! scavenging fraction due tu impaction [-]                     ! OUT
  REAL, DIMENSION(klon,klev)      :: frac_nucl        ! scavenging fraction due tu nucleation [-]                    ! OUT
  REAL, DIMENSION(klon,klev)      :: qclr             ! specific total water content in clear sky region [kg/kg]     ! OUT
  REAL, DIMENSION(klon,klev)      :: qcld             ! specific total water content in cloudy region [kg/kg]        ! OUT
  REAL, DIMENSION(klon,klev)      :: qss              ! specific total water content in supersat region [kg/kg]      ! OUT
  REAL, DIMENSION(klon,klev)      :: qvc              ! specific vapor content in clouds [kg/kg]                     ! OUT
  REAL, DIMENSION(klon,klev)      :: rnebclr          ! mesh fraction of clear sky [-]                               ! OUT
  REAL, DIMENSION(klon,klev)      :: rnebss           ! mesh fraction of ISSR [-]                                    ! OUT
  REAL, DIMENSION(klon,klev)      :: gamma_ss         ! coefficient governing the ice nucleation RHi threshold [-]   ! OUT   
  REAL, DIMENSION(klon,klev)      :: Tcontr           ! threshold temperature for contrail formation [K]             ! OUT
  REAL, DIMENSION(klon,klev)      :: qcontr           ! threshold humidity for contrail formation [kg/kg]            ! OUT
  REAL, DIMENSION(klon,klev)      :: qcontr2          ! // (2nd expression more consistent with LMDZ expression of q)! OUT          
  REAL, DIMENSION(klon,klev)      :: fcontrN          ! fraction of grid favourable to non-persistent contrails      ! OUT
  REAL, DIMENSION(klon,klev)      :: fcontrP          ! fraction of grid favourable to persistent contrails          ! OUT
!--------------------------------------------------------------

  REAL, DIMENSION(klon,klev)      :: d_t_eva,d_q_eva,d_ql_eva,d_qi_eva
include "YOMCST.h"

!    include "clesphys.h"
    INTEGER        length
    PARAMETER    ( length = 100 )
    REAL tabcntr0( length       )
    INTEGER, PARAMETER :: longcles=20
    REAL, SAVE :: clesphy0(longcles)
    !$OMP THREADPRIVATE(clesphy0)


real,dimension(klon,klev) :: temp_newton
integer :: i,k,iq
INTEGER, SAVE :: itap=0
!$OMP THREADPRIVATE(itap)
INTEGER, SAVE :: abortphy=0   ! Reprere si on doit arreter en fin de phys
!$OMP THREADPRIVATE(abortphy)

integer, save :: iflag_reevap=1,iflag_newton=0,iflag_vdif=1,iflag_lscp=1,iflag_cloudth_vert=3,iflag_ratqs=4
!$OMP THREADPRIVATE(iflag_reevap,iflag_newton,iflag_vdif,iflag_lscp,iflag_cloudth_vert,iflag_ratqs)

logical, save :: first=.true.
!$OMP THREADPRIVATE(first)

! For I/Os
integer :: itau0
real :: zjulian
real,dimension(klon,klev) :: du0,dv0,dqbs0
real,dimension(klon,klev) :: cloudth_sth,cloudth_senv,cloudth_sigmath,cloudth_sigmaenv


!------------------------------------------------------------
! Initialisations de la physique au premier pas de temps
!------------------------------------------------------------

print*,'Debut physiqex',debut
! initializations
if (debut) then ! Things to do only for the first call to physics 
print*,'Debut physiqex IN'

! load initial conditions for physics (including the grid)
  call phys_state_var_init(1) ! some initializations, required before calling phyetat0
  call phyetat0("startphy.nc", clesphy0, tabcntr0)

! Initialize outputs:
  itau0=0
  ! compute zjulian for annee0=1979 and month=1 dayref=1 and hour=0.0
  !CALL ymds2ju(annee0, month, dayref, hour, zjulian)
  call ymds2ju(1979, 1, 1, 0.0, zjulian)

#ifndef CPP_IOIPSL_NO_OUTPUT
  ! Initialize IOIPSL output file
#endif
call suphel
call vdif_ini_(klon,RCPD,RD,RG,RKAPPA)
! Pourquoi ce tau_thermals en argument ??? AFAIRE
tau_thermals=0.
call getin_p('iflag_thermals',iflag_thermals)

call getin_p('iflag_newton',iflag_newton)
call getin_p('iflag_reevap',iflag_reevap)
call getin_p('iflag_cloudth_vert',iflag_cloudth_vert)
call getin_p('iflag_ratqs',iflag_ratqs)
call getin_p('iflag_vdif',iflag_vdif)
call getin_p('iflag_lscp',iflag_lscp)
call getin_p('ratqsbas',ratqsbas)
call getin_p('ratqshaut',ratqshaut)
call getin_p('ratqsp0',ratqsp0)
call getin_p('ratqsdp',ratqsdp)
CALL thermcell_ini(iflag_thermals,0,tau_thermals,6, &
   &    RG,RD,RCPD,RKAPPA,RLVTT,RETV)
CALL lscp_ini(pdtphys,.false.,iflag_ratqs, RCPD, RLSTT, RLVTT, RLMLT, RVTMP2, RTT,RD,RG)



allocate(tsrf(klon),q2(klon,klev+1),f0(klon),zmax0(klon))
allocate(u_prev(klon,klev),v_prev(klon,klev),t_prev(klon,klev),q_prev(klon,klev,nqtot))

u_prev(:,:)=u(:,:)
v_prev(:,:)=v(:,:)
t_prev(:,:)=temp(:,:)
q_prev(:,:,:)=qx(:,:,:)

q2=1.e-10
tsrf=temp(:,1)
f0=0.
zmax0=0.

iflag_replay=0
call getin_p('iflag_replay',iflag_replay)
if ( iflag_replay >= 0 ) CALL iophys_ini(pdtphys)


endif ! of if (debut)

!------------------------------------------------------------
! Initialisations a chaque pas de temps
!------------------------------------------------------------

d_u_dyn(:,:)=(u(:,:)-u_prev(:,:))/pdtphys
d_v_dyn(:,:)=(v(:,:)-v_prev(:,:))/pdtphys
d_t_dyn(:,:)=(temp(:,:)-t_prev(:,:))/pdtphys
d_q_dyn(:,:,:)=(qx(:,:,:)-q_prev(:,:,:))/pdtphys

! set all tendencies to zero
d_u(1:klon,1:klev)=0.
d_v(1:klon,1:klev)=0.
d_t(1:klon,1:klev)=0.
d_qx(1:klon,1:klev,1:nqtot)=0.
d_ps(1:klon)=0.

u_loc(1:klon,1:klev)=u(1:klon,1:klev)
v_loc(1:klon,1:klev)=v(1:klon,1:klev)
t_loc(1:klon,1:klev)=temp(1:klon,1:klev)
d_u_loc(1:klon,1:klev)=0.
d_v_loc(1:klon,1:klev)=0.
d_t_loc(1:klon,1:klev)=0.
do iq=1,nqtot
   do k=1,klev
      do i=1,klon
         q_loc(i,k,iq)=qx(i,k,iq)
      enddo
   enddo
enddo

du0(1:klon,1:klev)=0.
dv0(1:klon,1:klev)=0.
dqbs0(1:klon,1:klev)=0.



!------------------------------------------------------------
! Calculs
!------------------------------------------------------------

!------------------------------------------------------------
! Rappel en temperature et frottement dans la premiere chouche
!------------------------------------------------------------

if ( iflag_newton == 1 ) then
    ! compute tendencies to return to the dynamics:
    ! "friction" on the first layer
    d_u(1:klon,1)=-u(1:klon,1)/86400.
    d_v(1:klon,1)=-v(1:klon,1)/86400.
    ! newtonian relaxation towards temp_newton()
    do k=1,klev
       temp_newton(1:klon,k)=280.+cos(latitude(1:klon))*40.-pphi(1:klon,k)/rg*6.e-3
       d_t(1:klon,k)=(temp_newton(1:klon,k)-temp(1:klon,k))/5.e5
    enddo
else
   temp_newton(:,:)=0.
endif


!------------------------------------------------------------
! Reevaporation de la pluie
!------------------------------------------------------------

iflag_ice_thermo=1
if ( iflag_reevap == 1 ) then
      CALL reevap (klon,klev,iflag_ice_thermo,t_loc,q_loc(:,:,1),q_loc(:,:,2),q_loc(:,:,3), &
&                  d_t_eva,d_q_eva,d_ql_eva,d_qi_eva)
     do k=1,klev
        do i=1,klon
           t_loc(i,k)=t_loc(i,k)+d_t_eva(i,k)
           q_loc(i,k,1)=q_loc(i,k,1)+d_q_eva(i,k)
           q_loc(i,k,2)=q_loc(i,k,2)+d_ql_eva(i,k)
           q_loc(i,k,3)=q_loc(i,k,3)+d_qi_eva(i,k)
           q_loc(i,k,2)=0.
           q_loc(i,k,3)=0.
        enddo
     enddo
else
     d_t_eva(:,:)=0.
     d_q_eva(:,:)=0.
     d_ql_eva(:,:)=0.
     d_qi_eva(:,:)=0.
endif



!-----------------------------------------------------------------------
! Variables intermédiaires (altitudes, temperature potentielle ...)
!-----------------------------------------------------------------------

DO k=1,klev
   DO i=1,klon
      zzlay(i,k)=pphi(i,k)/rg
   ENDDO
ENDDO
DO i=1,klon
   zzlev(i,1)=0.
ENDDO
DO k=2,klev
   DO i=1,klon
      z1=(pplay(i,k-1)+paprs(i,k))/(pplay(i,k-1)-paprs(i,k))
      z2=(paprs(i,k)+pplay(i,k))/(paprs(i,k)-pplay(i,k))
      zzlev(i,k)=(z1*zzlay(i,k-1)+z2*zzlay(i,k))/(z1+z2)
   ENDDO
ENDDO

!   Transformation de la temperature en temperature potentielle
DO k=1,klev
   DO i=1,klon
      zpopsk(i,k)=(pplay(i,k)/paprs(i,1))**rkappa
      masse(i,k)=(paprs(i,k)-paprs(i,k+1))/rg
   ENDDO
ENDDO
DO k=1,klev
   DO i=1,klon
      h_loc(i,k)=t_loc(i,k)/zpopsk(i,k)
      d_h_loc(i,k)=d_t_loc(i,k)/zpopsk(i,k)
      d_q_loc(i,k,1)=0.
   ENDDO
ENDDO

!-----------------------------------------------------------------------
! Diffusion verticale
!-----------------------------------------------------------------------

if ( iflag_vdif == 1 ) then
      emis(:)=1.
      !tsrf=300.
      z0m=0.035
      z0h=0.035
      capcal=1e2
      lwrite=.false.
      print*,'lwrite ',lwrite
            call vdif(klon,klev,                                               &
     &                pdtphys,capcal,z0m,z0h,                                  &
     &                pplay,paprs,zzlay,zzlev,                                 &
     &                u_loc,v_loc,t_loc,h_loc,q_loc,tsrf,emis,                 &
     &                d_u_loc,d_v_loc,d_h_loc,d_q_loc,fluxsrf,                 &
     &                d_u_vdif,d_v_vdif,d_h_vdif,d_q_vdif,dtsrf,q2,kz_v,kz_h,  &
     &                richardson,cdv,cdh,                                      &
     &                lwrite)
      do k=1,klev
         do i=1,klon
            d_t_vdif(i,k)=d_h_vdif(i,k)*zpopsk(i,k)
            t_loc(i,k)=t_loc(i,k)+d_t_vdif(i,k)*pdtphys
            u_loc(i,k)=u_loc(i,k)+d_u_vdif(i,k)*pdtphys
            v_loc(i,k)=v_loc(i,k)+d_v_vdif(i,k)*pdtphys
            q_loc(i,k,1)=q_loc(i,k,1)+d_q_vdif(i,k,1)*pdtphys
         enddo
      enddo
      do i=1,klon
         tsrf(i)=tsrf(i)+dtsrf(i)*pdtphys
      enddo
else
      d_u_vdif(:,:)=0.
      d_v_vdif(:,:)=0.
      d_t_vdif(:,:)=0.
      d_h_vdif(:,:)=0.
      d_q_vdif(:,:,1)=0.
      kz_v(:,:)=0.
      kz_h(:,:)=0.
      richardson(:,:)=0.
endif

!-----------------------------------------------------------------------
! Thermiques
!-----------------------------------------------------------------------

do k=1,klev
   do i=1,klon
      d_u_the(i,k)=0.
      d_v_the(i,k)=0.
      d_t_the(i,k)=0.
      d_q_the(i,k,1)=0.
   enddo
enddo

if ( iflag_thermals > 0 ) then


          zqta(:,:)=q_loc(:,:,1)
          call caltherm(pdtphys                            &
         &      ,pplay,paprs,pphi                          &
         &      ,u_loc,v_loc,t_loc,q_loc,debut             &
         &      ,f0,zmax0,d_u_the,d_v_the,d_t_the,d_q_the  &
         &     ,frac_the,fm_the,zqta,ztv,zpspsk,ztla,zthl  &
         &   )
    
          do k=1,klev
             do i=1,klon
                t_loc(i,k)=t_loc(i,k)+d_t_the(i,k)
                u_loc(i,k)=u_loc(i,k)+d_u_the(i,k)
                v_loc(i,k)=v_loc(i,k)+d_v_the(i,k)
                q_loc(i,k,1)=q_loc(i,k,1)+d_q_the(i,k,1)
             enddo
          enddo

else
          frac_the(:,:)=0.
          fm_the(:,:)=0.
          ztv(:,:)=t_loc(:,:)
          zqta(:,:)=q_loc(:,:,1)
          ztla(:,:)=0.
          zthl(:,:)=0.
          zpspsk(:,:)=(pplay(:,:)/100000.)**RKAPPA
 
endif

!-----------------------------------------------------------------------
! Condensation grande échelle
!-----------------------------------------------------------------------

iflag_cld_th=5
ok_ice_sursat=.false.
ptconv(:,:)=.false.
distcltop=0.
temp_cltop=0.
beta(:,:)=1.
rneb_seri(:,:)=0.
do k=1,klev
  ratqs(:,k)=ratqsbas+0.5*(ratqshaut-ratqsbas) &
  *( tanh( (ratqsp0-pplay(:,k))/ratqsdp) + 1.)
enddo


if ( iflag_lscp == 1 ) then

    call lscp(klon,klev,pdtphys,missing_val,            &
     paprs,pplay,t_loc,q_loc,ptconv,ratqs,                      &
     d_t_lscp, d_q_lscp, d_ql_lscp, d_qi_lscp, rneb, rneblsvol, rneb_seri,  &
     pfraclr,pfracld,                                   &
     radocond, radicefrac, rain, snow,                  &
     frac_impa, frac_nucl, beta,                        &
     prfl, psfl, rhcl, zqta, frac_the,                     &
     ztv, zpspsk, ztla, zthl, iflag_cld_th,             &
     iflag_ice_thermo, ok_ice_sursat, qsatl, qsats,     &
     distcltop,temp_cltop,                               &
     qclr, qcld, qss, qvc, rnebclr, rnebss, gamma_ss,   &
     Tcontr, qcontr, qcontr2, fcontrN, fcontrP, &
     cloudth_sth,cloudth_senv,cloudth_sigmath,cloudth_sigmaenv)


          do k=1,klev
             do i=1,klon
                t_loc(i,k)=t_loc(i,k)+d_t_lscp(i,k)
                q_loc(i,k,1)=q_loc(i,k,1)+d_q_lscp(i,k)
                q_loc(i,k,2)=q_loc(i,k,2)+d_ql_lscp(i,k)
                q_loc(i,k,3)=q_loc(i,k,3)+d_qi_lscp(i,k)
             enddo
          enddo

else
     d_t_lscp(:,:)=0.
     d_q_lscp(:,:)=0.
     d_ql_lscp(:,:)=0.
     d_qi_lscp(:,:)=0.
     rneb(:,:)=0.
     rneblsvol(:,:)=0.
     pfraclr(:,:)=0.
     pfracld(:,:)=0.
     radocond(:,:)=0.
     rain(:)=0.
     snow(:)=0.
     radicefrac(:,:)=0.
     rhcl      (:,:)=0.
     qsatl     (:,:)=0.
     qsats     (:,:)=0.
     prfl      (:,:)=0.
     psfl      (:,:)=0.
     distcltop (:,:)=0.
     temp_cltop(:,:)=0.
     frac_impa (:,:)=0.
     frac_nucl (:,:)=0.
     qclr      (:,:)=0.
     qcld      (:,:)=0.
     qss       (:,:)=0.
     qvc       (:,:)=0.
     rnebclr   (:,:)=0.
     rnebss    (:,:)=0.
     gamma_ss  (:,:)=0.
     Tcontr    (:,:)=0.
     qcontr    (:,:)=0.
     qcontr2   (:,:)=0.
     fcontrN   (:,:)=0.
     fcontrP   (:,:)=0.
endif


d_u(:,:)=(u_loc(:,:)-u(:,:))/pdtphys
d_v(:,:)=(v_loc(:,:)-v(:,:))/pdtphys
d_t(:,:)=(t_loc(:,:)-temp(:,:))/pdtphys
d_qx(:,:,:)=(q_loc(:,:,:)-qx(:,:,:))/pdtphys

!------------------------------------------------------------
! Entrees sorties
!------------------------------------------------------------


tsrf_(:)=tsrf(:)
if ( iflag_replay == -1 ) then
   call output_physiqex(debut,zjulian,pdtphys,presnivs,paprs,u,v,temp,qx,0.*u,0.*u,0.*u,0.*u,q2,0.*u)
else if (iflag_replay == 0 ) then
     ! En mode replay, on sort aussi les variables de base
! Les lignes qui suivent ont été générées automatiquement avec :
! ( for i in `grep -i 'real.*::' physiqex_mod.F90 | sed -e '/^!/d' | grep '(klon,klev' | cut -d: -f3 | cut -d! -f1 | sed -e 's/,/ /g' -e '/rot/d'` ; do echo ' call iophys_ecrit("'$i'",klev,"","",'$i')' ; done ) > physiqex_out.h
! ( for i in `grep -i 'real.*::' physiqex_mod.F90 | sed -e '/^!/d' | grep '(klon)' | cut -d: -f3 | cut -d! -f1 | sed -e 's/,/ /g' -e '/rot/d'` ; do echo ' call iophys_ecrit("'$i'",1,"","",'$i')' ; done ) >> physiqex_out.h
include "physiqex_out.h"

endif


! if lastcall, then it is time to write "restartphy.nc" file
if (lafin) then
  call phyredem("restartphy.nc")
endif

print*,'Fin physiqex'

end subroutine physiqex

END MODULE physiqex_mod
