# Script pour tester la presence de fichiers de guidage ERA* sur Jean-Zay
# 2021/04/15 
# A. Sima (adriana.sima@lmd.ipsl.fr)


#####################################################################
# A choisir par l'utilisateur :
#####################################################################

# Guidage en vent(u&v) et/ou temperature, humidite
guide_uv=y
guide_t=y
guide_q=y

an=2000
mois=01
#
# Choix des "rea"nalyses : ERA5, ERAI, OPERA
rea=ERAI


#####################################################################
# Lien avec les fichiers netcdf contenant les d0 ECMWF 
#####################################################################
   echo -------- liens de telechargement a actualiser ----
   if [ "$rea" = "ERA5" ] ; then
      ANA_DIR='/gpfsstore/rech/psl/rpsl376/ergon/ERA5/NETCDF/GLOBAL_025/4xdaily'
      suf="e5.GLOBAL_025"
   elif [ "$rea" = "ERAI" ] ; then
      #ANA_DIR='http://prodn.idris.fr/thredds/dodsC/ipsl_private/rpsl376/ERAI/NETCDF/GLOBAL_1125/4xdaily'
      ANA_DIR='/gpfsstore/rech/psl/rpsl376/ergon/ERAI/NETCDF/GLOBAL_1125/4xdaily'
      #/gpfsstore/rech/psl/rpsl376/ergon/ERAI/NETCDF/GLOBAL_075/4xdaily/AN_PL/2006/u.200601.aphei.GLOBAL_075.nc 
      suf="ei.GLOBAL_1125"
   else  #OPERA
      #ANA_DIR='http://prodn.idris.fr/thredds/dodsC/ipsl_private/rpsl376/OPERA/NETCDF/4xdaily'
      ANA_DIR='/gpfsstore/rech/psl/rpsl376/ergon/OPERA/NETCDF/4xdaily'
      suf=".GLOBAL_1125"
   fi

varu=u
varv=v
vart=ta # peut etre parfois juste "t"
varq=q
#varp=msl

if [ "$rea" = "ERAI" ] ; then
  # variables en format "short" doivent etre transformees en "float" via NCO 
  fushort="$ANA_DIR/AN_PL/$an/u.$an$mois.aph$suf.nc"
  fvshort="$ANA_DIR/AN_PL/$an/v.$an$mois.aph$suf.nc"
  fileu="$SCRATCH/u.$an$mois.aph$suf.nc"
  filev="$SCRATCH/v.$an$mois.aph$suf.nc"
  ncap2 -s 'u=float(u)' $fushort $fileu
  ncap2 -s 'v=float(v)' $fvshort $filev
else
 fileu="$ANA_DIR/AN_PL/$an/u.$an$mois.aph$suf.nc"
 filev="$ANA_DIR/AN_PL/$an/v.$an$mois.aph$suf.nc"
fi
filet="$ANA_DIR/AN_PL/$an/ta.$an$mois.aph$suf.nc"
fileq="$ANA_DIR/AN_PL/$an/r.$an$mois.aph$suf.nc"

# verifier disponibilite des fichiers
if [ "$guide_uv" = "y" ] ; then  ls $fileu ; ls $filev ; fi
if [ "$guide_t" = "y" ] ; then  ls $filet ; fi
if [ "$guide_q" = "y" ] ; then  ls $fileq ; fi
