module setup_config_from_lmdz

  use parkind1, only : jprb

  implicit none

  public

  type driver_config_type
     real(jprb) :: high_inv_effective_size   = -1.0_jprb ! m-1
     real(jprb) :: middle_inv_effective_size = -1.0_jprb ! m-1
     real(jprb) :: low_inv_effective_size    = -1.0_jprb ! m-1
     real(jprb) :: cloud_inhom_separation_factor  = 1.0_jprb
     real(jprb) :: cloud_separation_scale_surface = -1.0_jprb
     real(jprb) :: cloud_separation_scale_toa     = -1.0_jprb
     real(jprb) :: cloud_separation_scale_power   = -1.0_jprb
     real(jprb) :: frac_std = 0.75_jprb
     real(jprb) :: overlap_decorr_length = 2000.0_jprb


 contains
 procedure :: read => read_config_from_namelist

  end type driver_config_type

contains

  !---------------------------------------------------------------------
  subroutine read_config_from_namelist(this, file_name, is_success)

    use radiation_io, only : nulerr, radiation_abort       

    class(driver_config_type), intent(inout) :: this
    character(*), intent(in)          :: file_name
    logical, intent(out), optional    :: is_success
    integer :: iosopen ! Status after calling open
    real(jprb) :: high_inv_effective_size 
    real(jprb) :: middle_inv_effective_size
    real(jprb) :: low_inv_effective_size
    real(jprb) :: cloud_inhom_separation_factor 
    real(jprb) :: cloud_separation_scale_surface
    real(jprb) :: cloud_separation_scale_toa
    real(jprb) :: cloud_separation_scale_power
    real(jprb) :: frac_std
    real(jprb) :: overlap_decorr_length

    namelist /radiation_driver/ frac_std, overlap_decorr_length, &
         &  high_inv_effective_size, middle_inv_effective_size, low_inv_effective_size, &
         &  cloud_inhom_separation_factor, cloud_separation_scale_surface, &
         &  cloud_separation_scale_toa, cloud_separation_scale_power 

    ! Open the namelist file and read the radiation_driver namelist
    open(unit=10, iostat=iosopen, file=trim(file_name))
    if (iosopen /= 0) then
      ! An error occurred
      if (present(is_success)) then
        is_success = .false.
        ! We now continue the subroutine so that the default values
        ! are placed in the config structure
      else
        write(nulerr,'(a,a,a)') '*** Error: namelist file "', &
             &                trim(file_name), '" not found'
        call radiation_abort('Driver configuration error')
      end if
    else
      ! Read the radiation_driver namelist, noting that it is not an
      ! error if this namelist is not present, provided all the required
      ! variables are present in the NetCDF data file instead
      read(unit=10, nml=radiation_driver)
      close(unit=10)
    end if

    ! Copy namelist data into configuration object
    this%frac_std = frac_std
    this%overlap_decorr_length = overlap_decorr_length
    this%cloud_inhom_separation_factor = cloud_inhom_separation_factor
    this%cloud_separation_scale_surface = cloud_separation_scale_surface
    this%cloud_separation_scale_toa = cloud_separation_scale_toa
    this%cloud_separation_scale_power = cloud_separation_scale_power
    this%high_inv_effective_size = high_inv_effective_size
    this%middle_inv_effective_size = middle_inv_effective_size
    this%low_inv_effective_size = low_inv_effective_size

  end subroutine read_config_from_namelist          

end module setup_config_from_lmdz
