module blowing_snow_ini_mod

implicit none

save
   integer :: prt_level=0,lunout
   real RCPD, RLSTT, RLVTT, RLMLT, RVTMP2, RTT,RD,RG
   real coef_eva_bs, expo_eva_bs, fallv_bs, zeta_bs
   real prt_bs, pbst_bs, qbst_bs
   integer :: niter_bs, iflag_saltation_bs

   !$OMP THREADPRIVATE(prt_level, lunout)
   !$OMP THREADPRIVATE(RCPD, RLSTT, RLVTT, RLMLT, RVTMP2, RTT,RD,RG)
   !$OMP THREADPRIVATE(coef_eva_bs, expo_eva_bs, fallv_bs, zeta_bs)
   !$OMP THREADPRIVATE(pbst_bs, prt_bs, qbst_bs)
   !$OMP THREADPRIVATE(niter_bs, iflag_saltation_bs)

      contains

      subroutine blowing_snow_ini(prt_level_in,lunout_in, &
                                  RCPD_in, RLSTT_in, RLVTT_in, RLMLT_in,&
                                  RVTMP2_in, RTT_in,RD_in,RG_in)

         USE ioipsl_getin_p_mod, ONLY : getin_p

         integer, intent(in) :: prt_level_in,lunout_in
         real, intent(in) :: RCPD_in, RLSTT_in, RLVTT_in, RLMLT_in
         real, intent(in) ::  RVTMP2_in, RTT_in, RD_in, RG_in


         prt_level=prt_level_in
         RG=RG_in
         RD=RD_in
         RCPD=RCPD_in
         RLVTT=RLVTT_in
         RLSTT=RLSTT_in
         RLMLT=RLMLT_in
         RTT=RTT_in
         RG=RG_in
         RVTMP2=RVTMP2_in
         lunout=lunout_in


         qbst_bs= 0.001
         CALL getin_p('qbst_bs',qbst_bs)

         pbst_bs= 0.01
         CALL getin_p('pbst_bs',pbst_bs)

         prt_bs= 0.0003
         CALL getin_p('prt_bs',prt_bs)


         zeta_bs= 3.
         CALL getin_p('zeta_bs',zeta_bs)

         fallv_bs = 0.1
         CALL getin_p('fallv_bs',fallv_bs)

         coef_eva_bs =  2.e-5 
         CALL getin_p('coef_eva_bs',coef_eva_bs)

         expo_eva_bs = 0.5
         CALL getin_p('expo_eva_bs',expo_eva_bs)

         niter_bs = 5
         CALL getin_p('niter_bs',niter_bs)

         iflag_saltation_bs=0
         CALL getin_p('iflag_saltation_bs',iflag_saltation_bs)


      end subroutine blowing_snow_ini

end module blowing_snow_ini_mod
