MODULE atke_turbulence_ini_mod

implicit none

save

  integer :: iflag_atke
  !$OMP THREADPRIVATE(iflag_atke)
  real :: kappa = 0.4 ! Von Karman constant
  !$OMP THREADPRIVATE(kappa)
  real :: l0, ric, ri0, cn, cinf, cepsilon, pr_slope, pr_asym
  !$OMP THREADPRIVATE(l0, ric, cn, cinf, cepsilon, pr_slope, pr_asym)
  integer :: lunout,prt_level
  !$OMP THREADPRIVATE(lunout,prt_level)
  real :: rg, rd, rpi
  !$OMP THREADPRIVATE(rg, rd, rpi)


CONTAINS

SUBROUTINE atke_ini(prt_level_in, lunout_in, rg_in, rd_in, rpi_in)

   USE ioipsl_getin_p_mod, ONLY : getin_p

  integer, intent(in) :: lunout_in,prt_level_in
  real, intent(in) :: rg_in, rd_in, rpi_in


  lunout=lunout_in
  prt_level=prt_level_in
  rd=rd_in
  rg=rg_in
  rpi=rpi_in

  ! flag that controls options in atke_compute_km_kh
  iflag_atke=0
  CALL getin_p('iflag_atke',iflag_atke)

  ! asymptotic mixing length [m]
  l0=150.0 
  CALL getin_p('atke_l0',l0)

  ! critical Richardson number 
  ric=0.25
  CALL getin_p('atke_ric',ric)

  ! value of Sm stability function for neutral conditions (Ri=0) 
  cn=1.0
  CALL getin_p('atke_cn',cn)

  ! asymptotic value of Sm for Ri=-Inf
  cinf=1.5
  CALL getin_p('atke_cinf',cinf)

  ! constant for tke dissipation calculation
  cepsilon=16.6 ! default value as in yamada4
  CALL getin_p('atke_cepsilon',cepsilon)

  ! slope of Pr=f(Ri) for stable conditions
  pr_slope=5.0 ! default value from Zilitinkevich et al. 2005
  CALL getin_p('atke_pr_slope',pr_slope)

  ! asymptotic turbulent prandt number value for Ri=-Inf
  pr_asym=0.4
  CALL getin_p('atke_pr_asym',pr_asym)

   
 RETURN

END SUBROUTINE atke_ini

END MODULE  atke_turbulence_ini_mod
