MODULE thermcell_ini_mod
IMPLICIT NONE

save

   integer :: dvdq=1,dqimpl=-1,prt_level=0,lunout
   real RG,RD,RCPD,RKAPPA,RLVTT,RLvCp,RETV
   real           :: r_aspect_thermals,tau_thermals,fact_thermals_ed_dz
   integer        :: iflag_thermals_ed,iflag_thermals_optflux,iflag_thermals_closure
   integer        :: iflag_thermals_down
   real           :: fact_thermals_down

!$OMP THREADPRIVATE(dvdq,dqimpl,prt_level,lunout)
!$OMP THREADPRIVATE(RG,RD,RCPD,RKAPPA,RLVTT,RLvCp)
!$OMP THREADPRIVATE(r_aspect_thermals,tau_thermals,fact_thermals_ed_dz)
!$OMP THREADPRIVATE(iflag_thermals_ed,iflag_thermals_optflux,iflag_thermals_closure)
!$OMP THREADPRIVATE(iflag_thermals_down)
!$OMP THREADPRIVATE(fact_thermals_down)


   REAL, SAVE :: fact_epsilon=0.002
   REAL, SAVE :: betalpha=0.9
   REAL, SAVE :: afact=2./3.
   REAL, SAVE :: fact_shell=1.
   REAL,SAVE :: detr_min=1.e-5
   REAL,SAVE :: entr_min=1.e-5
   REAL,SAVE :: detr_q_coef=0.012
   REAL,SAVE :: detr_q_power=0.5
   REAL,SAVE :: mix0=0.
   INTEGER,SAVE :: thermals_flag_alim=0

!$OMP THREADPRIVATE(fact_epsilon, betalpha, afact, fact_shell)
!$OMP THREADPRIVATE(detr_min, entr_min, detr_q_coef, detr_q_power)
!$OMP THREADPRIVATE( mix0, thermals_flag_alim)


CONTAINS

SUBROUTINE thermcell_ini(iflag_thermals,prt_level_in,tau_thermals_in,lunout_in, &
   &    RG_in,RD_in,RCPD_in,RKAPPA_in,RLVTT_in,RETV_in)

   USE ioipsl_getin_p_mod, ONLY : getin_p

integer, intent(in) :: iflag_thermals,prt_level_in,lunout_in
real, intent(in) :: RG_in,RD_in,RCPD_in,RKAPPA_in,RLVTT_in,RETV_in,tau_thermals_in

print*,'thermcell_ini'
      if (iflag_thermals==15.or.iflag_thermals==16) then
         dvdq=0
         dqimpl=-1
      else
         dvdq=1
         dqimpl=1
      endif
   prt_level=prt_level_in
   RG=RG_in
   RD=RD_in
   RCPD=RCPD_in
   RKAPPA=RKAPPA_in
   RLVTT=RLVTT_in
   RLvCp = RLVTT/RCPD
   RETV=RETV_in
   tau_thermals=tau_thermals_in
   lunout=lunout_in


!=====================================================================
! a la fois les vieilles param et thermcell_main :
!=====================================================================

   r_aspect_thermals=2.
   CALL getin_p('r_aspect_thermals',r_aspect_thermals)
   
   tau_thermals = 0.
   CALL getin_p('tau_thermals',tau_thermals)
   
   fact_thermals_ed_dz = 0.1
   CALL getin_p('fact_thermals_ed_dz',fact_thermals_ed_dz)
   
   fact_thermals_ed_dz = 0.1
   CALL getin_p('fact_thermals_ed_dz',fact_thermals_ed_dz)
   
   iflag_thermals_ed = 0
   CALL getin_p('iflag_thermals_ed',iflag_thermals_ed)
   
   iflag_thermals_optflux = 0
   CALL getin_p('iflag_thermals_optflux',iflag_thermals_optflux)
   
   iflag_thermals_closure = 1
   CALL getin_p('iflag_thermals_closure',iflag_thermals_closure)

   iflag_thermals_down = 0
   CALL getin_p('iflag_thermals_down',iflag_thermals_down)

   fact_thermals_down = 0.5
   CALL getin_p('fact_thermals_down',fact_thermals_down)

     CALL getin_p('thermals_fact_epsilon',fact_epsilon)
     CALL getin_p('thermals_betalpha',betalpha)
     CALL getin_p('thermals_afact',afact)
     CALL getin_p('thermals_fact_shell',fact_shell)
     CALL getin_p('thermals_detr_min',detr_min)
     CALL getin_p('thermals_entr_min',entr_min)
     CALL getin_p('thermals_detr_q_coef',detr_q_coef)
     CALL getin_p('thermals_detr_q_power',detr_q_power)
     CALL getin_p('thermals_mix0',mix0)
     CALL getin_p('thermals_flag_alim',thermals_flag_alim)


 RETURN

END SUBROUTINE thermcell_ini
END MODULE thermcell_ini_mod
