#!/bin/bash

################################################################
# Complément d'installation Ubuntu22
################################################################

workspace_matrix=0

install="sudo apt install -y"
sudo apt update
sudo apt upgrade

# Base :
# ======
$install locate
$install ncftp vim nfs-common
# keychain semble Ãªtre devenu obsolÃ¨te.
# ksh et csh inutile ?

# Pour compilation dont LMDZ
# ==========================
$install cdo nco netcdf-bin libnetcdf-dev ncview   # netcdf
$install gfortran g++ libblas-dev subversion git   # fortran et svn
$install openmpi-common libopenmpi-dev openmpi-bin # openmpi
$install make cmake


# Pour HitghTune
# ==============
$install r-base
$install pip
$install python3-pip

# bureautique
# ===========
$install xournal
$install unoconv # conversion associee a libreoffice
$install dos2unix
$install qpdfview # un visualiseur remplissant mieux les pdf
$install pdftk # Autre package de concatenation de pdf
$install chromium-browser

# LaTeX dont pdfjam
# =================
$install texlive-base texlive-latex-extra texlive-lang-french latexdiff  texlive-publishers
$install latexmk texlive-science
$install latex2html
$install texlive-extra-utils texlive-font-utils # pdfjam

# graphique / video
# =================
$install xfig grads imagemagick gv grace           # graphique
$install ferret-vis
$install inkscape gimp                             # dessin
$install gifsicle
$install ffmpeg
$install winff  # autre convertisseur video

# Finalisation de l'installation de ferret-vis
# ============================================
# Active le bon environnement pour ferret
# Attention, pour que ca fonctionne completement (notamment le trace
# des frontieres) il manque des données.
# Pour le moment, on va chercher ces données dans le répertoire de
# l'installation conda. On a donc une double installation
sed -i'' -e '/ferret-vis/d' ~/.bashrc
cat <<eod>> ~/.bashrc
. /usr/share/ferret-vis/bin/ferret_paths # ferret-vis
alias ferret=ferret_c
export FER_DATA=". \$FER_DATA /home/util1/miniconda3/pkgs/ferret_datasets-7.4-1/share/fer_dsets/data" # ferret-vis
eod




# Outils systeme / collaboratifs
# ==============================
$install traceroute # aide systeme
$install synaptic gdebi                            # install paquets
$install tmate

# Son
#=====
# $install audacity

# Acroread
# ========
sudo dpkg --add-architecture i386
$install libxml2:i386 libcanberra-gtk-module:i386 gtk2-engines-murrine:i386
$install libatk-adaptor:i386 libgdk-pixbuf2.0-0:i386
wget -O /tmp/adobe.deb ftp://ftp.adobe.com/pub/adobe/reader/unix/9.x/9.5.5/enu/AdbeRdr9.5.5-1_i386linux_enu.deb
sudo dpkg -i /tmp/adobe.deb


if [ $workspace_matrix = 1 ] ; then 

# Firefox
# =======
# Reinstallation d’une version de firefox pour permettre le multigrille
# https://ubuntuhandbook.org/index.php/2022/04/install-firefox-deb-ubuntu-22-04/
sudo snap remove firefox
sudo apt remove firefox
sudo add-apt-repository ppa:mozillateam/ppa
sudo cat <<eod> /tmp/mozillateamppa
Package: firefox*
Pin: release o=LP-PPA-mozillateam
Pin-Priority: 501
eod
sudo cp /tmp/mozillateamppa /etc/apt/preferences.d/
sudo apt install -y chrome-gnome-shell
sudo apt install -y firefox

echo Run firefox https://extensions.gnome.org/extension/1485/workspace-matrix/
echo first clicks in the top frame, install gnome extension, or so.
echo then reload browser
echo then click on the OFF button

fi
