#!/bin/bash

cat <<eod
Ce script installe miniconda puis la version conda de ferret.

Rm :
1) Il faut répondre aux questions de l'installation conda.
2) Tout à la fin, il commente les lignes rajoutées automatiquement dans
le .bashrc pour éviter que conda soit actif par défaut.
3) On fait une rétroinstallation de ferret qui sans ça ne marche pas
sur certains ordis.
eod
sleep 12

# Installation de miniconda (notamment pour ferret)
=======================================

wget https://repo.continuum.io/miniconda/Miniconda3-latest-Linux-x86_64.sh
bash Miniconda3-latest-Linux-x86_64.sh
# desactiver conda par defaut
cd $HOME/miniconda3/bin
./conda config --set auto_activate_base false

./conda create --name python2 python=2.7
./conda create --name python3 python=3.7
./conda install -y netcdf4 h5py jinja2 pip sqlalchemy basemap matplotlib numpy scipy


# Installation de ferret via conda
=========================

# Il faut installer une ancienne version d’abord à cause d’un bug
# cf. https://www.pmel.noaa.gov/maillists/tmap/ferret_users/fu_2019/msg01061.html
./conda install -y -c "conda-forge/label/cf202003" pyferret
./conda create -n FERRET -c conda-forge/label/cf202003 pyferret ferret_datasets --yes


# Installation basemap
=================
https://github.com/conda-forge/basemap-feedstock/issues/45
#suggère pour un des problèmes rencontrés de faire une install comme suit
conda create -n basemap python=3.7 basemap proj4=5.2.0
conda activate basemap
python -c "from mpl_toolkits.basemap import Basemap"

#PB identifiés avec le nouveau compilateur
#  INTEGER(KIND=JPIM), PARAMETER :: IVAR=0 !Z"3FFFFFFF"



