#!/bin/bash 
#########################################################################
# Script to automatically install the HDF5 1.10.5, NetCDF 4.3.3.1 C library
#  and the NetCDF 4.4.2 Fortran library
#########################################################################
# Defaults
#########################################################################
install_dir=$(pwd)
compiler_suite=gnu
#########################################################################
#  Options 
#########################################################################
while (($# > 0))
   do
   case $1 in
     "-h") cat <<........fin
    $0 [ -prefix path ]       where (path) to install
                              (default: $install_dir)
       [ -compiler gnu | intel ] compiler suite (Fortran, C, C++) to use
                              (default: $compiler_suite)
........fin
     exit ;;
     "-prefix") install_dir=$2 ; shift ; shift ;;
     "-compiler") compiler_suite=$2 ; shift ; shift ;;
     *) echo "Error, bad argument $1" ; $0 -h ; exit
   esac
done

# Install directory (get full path)
mkdir -p $install_dir
install_dir=$(cd $install_dir ; pwd -P )

# Install location for packages
mkdir -p $install_dir/src


if [[ ${compiler_suite} == "gnu" ]] ; then
  f_compiler="gfortran"
  c_compiler="gcc"
  cxx_compiler="g++"
elif [[ ${compiler_suite} == "intel" ]] ; then
  f_compiler="ifort"
  c_compiler="icc"
  cxx_compiler="icpc"
else
  echo "unknown compiler family $compiler_suite"
  echo "might as well stop here"
  exit
fi

export FC=$f_compiler
export F90=$f_compiler
export CC=$c_compiler
export CXX=$cxx_compiler
allow_arg_mismatch=""
if [[ ${f_compiler} == "gfortran" ]] ; then
  if [ `gfortran -dumpversion | cut -d. -f1` -ge 11 ] ; then 
    allow_arg_mismatch="-fallow-argument-mismatch" 
  fi
  export FFLAGS=" -O2 -fPIC $allow_arg_mismatch"
  export FCFLAGS="-O2 -ffree-form -fPIC $allow_arg_mismatch"
  export CPPFLAGS="-I${install_dir}/include"
  export CFLAGS="-O2 -fPIC"
  export CXXFLAGS="-O2 -fPIC"
elif [[ ${f_compiler} == "ifort" ]] ; then
  export CPP="icc -E"
  export FFLAGS="-O2 -ip -fpic"
  export FCFLAGS="-O2 -ip -fpic"
  export CPPFLAGS="-I${install_dir}/include"
  export CFLAGS="-O2 -ip -fpic"
  export CXXFLAGS="-O2 -ip -fpic"
else
  echo "unknown compiler $f_compiler"
  echo "might as well stop here"
  exit
fi

#---------------------------------------------------------------------------
function myget() {
\rm -f ${1}*
wget -nv --no-check-certificate https://lmdz.lmd.jussieu.fr/Distrib/$1.tar.gz
tar xvf $1.tar.gz
}
#---------------------------------------------------------------------------


# CURL
APP=curl-7.26.0
CURL_PATH=$install_dir/$APP
rm -rf $CURL_PATH 
cd $install_dir/src 
#wget ftp://ftp.unidata.ucar.edu/pub/netcdf/netcdf-4/curl-7.26.0.tar.gz
myget curl-7.26.0
cd    curl-7.26.0
export CC=$c_compiler
./configure \
--prefix=$install_dir | tee $APP.config.log
make 2>&1 | tee $APP.make.log
make install 2>&1 | tee $APP.install.log

# ZLIB
APP=zlib-1.2.8
ZLIB_PATH=$install_dir/$APP 
rm -rf $ZLIB_PATH 
cd $install_dir/src 
#wget ftp://ftp.unidata.ucar.edu/pub/netcdf/netcdf-4/zlib-1.2.8.tar.gz
myget zlib-1.2.8
cd    zlib-1.2.8
export CC=$c_compiler
export FC=$f_compiler
export CXX=$cxx_compiler 
./configure \
--prefix=$install_dir | tee $APP.config.log
make 2>&1 | tee $APP.make.log
make check 2>&1 | tee $APP.make_check.log
make install 2>&1 | tee $APP.install.log


# HDF5
APP=hdf5-1.10.5
HDF5_PATH=$install_dir/$APP 
rm -rf $HDF5_PATH 
cd $install_dir/src 
rm -rf hdf5-1.10.5* 
#wget ftp://ftp.unidata.ucar.edu/pub/netcdf/netcdf-4/hdf5-1.8.13.tar.gz
#wget http://www.lmd.jussieu.fr/~lmdz/Distrib/hdf5-1.8.13.tar.gz
wget -nv --no-check-certificate https://support.hdfgroup.org/ftp/HDF5/releases/hdf5-1.10/hdf5-1.10.5/src/hdf5-1.10.5.tar.gz
tar xzf hdf5-1.10.5.tar.gz ; cd hdf5-1.10.5
export CC=$c_compiler
export FC=$f_compiler
export CXX=$cxx_compiler 
./configure \
--prefix=$install_dir \
--enable-fortran \
--with-zlib=$install_dir  \
--with-pic 2>&1 | tee $APP.config.log
make 2>&1 | tee $APP.make.log
#make check 2>&1 | tee $APP.make_check.log
make install 2>&1 | tee $APP.install.log

# NetCDF4
APP=netcdf-4.3.3.1
NETCDF4_PATH=$install_dir/$APP
rm -rf $NETCDF4_PATH 
cd $install_dir/src 
myget netcdf-4.3.3.1 
cd    netcdf-4.3.3.1
export LDFLAGS="-L${install_dir}/lib"
export CFLAGS="-I${install_dir}/include/curl -I${install_dir}/include"
export LD_LIBRARY_PATH="${install_dir}/lib:${LD_LIBRARY_PATH}"
./configure \
--prefix=${install_dir} \
--enable-static \
--enable-shared \
--enable-netcdf4 \
--enable-dap \
--with-pic 2>&1 | tee $APP.config.log
make 2>&1 | tee $APP.make.log
make check 2>&1 | tee $APP.make_check.log
make install 2>&1 | tee $APP.install.log

# NetCDF4-Fortran
APP=netcdf-fortran-4.4.2
NETCDF4_FORTRAN_PATH=${install_dir}/$APP
rm -rf $NETCDF4_FORTRAN_PATH
cd ${install_dir}/src 
#wget ftp://ftp.unidata.ucar.edu/pub/netcdf/netcdf-fortran-4.4.2.tar.gz
myget netcdf-fortran-4.4.2
cd    netcdf-fortran-4.4.2
export LDFLAGS=-L${install_dir}/lib 
./configure \
--prefix=${install_dir} 2>&1 | tee $APP.config.log
make 2>&1 | tee $APP.make.log
make check 2>&1 | tee $APP.make_check.log
make install 2>&1 | tee $APP.install.log


if [[ -f $install_dir/bin/nf-config ]] ; then
  echo "successfully installed the netcdf library in $install_dir"
fi
