#!/bin/bash

routine=wake # Nom par défaut de la subroutine rejouee. 
             # Est écrasé par l'argument $1 si fourni

if [ $# -ge 1 ] ; then routine=$1 ; fi

#------------------------------------------------------------------------------------------
# Détection automatique des répertoires contenant le modèle et de la physique (libf/phylmd$pys)
#------------------------------------------------------------------------------------------
simdir=`pwd | sed -e 's/^.*EXEC.//' -e 's:/.*$::'`
if [ "`echo $simdir | grep lmd`" = "" ] ; then phys=lmd ; else phys=`echo $simdir | sed -e 's/^.*lmd/lmd/'` ; fi
LMDZdir=`pwd | sed -e 's/.1D.*$//'`


#------------------------------------------------------------------------------------------
# Preparation des fichieers fortran
#------------------------------------------------------------------------------------------
cd $LMDZdir/modipsl/modeles/LMDZ/libf/phy$phys
replay_clean.sh
replay_equip.sh $routine
cd -

#------------------------------------------------------------------------------------------
# Compilation et execution
#------------------------------------------------------------------------------------------
\rm lmdz1d.e replay1d.e
# Compilation de lmdz1d
./compile.sh
# Compilation de replay1d
./compile.sh replay1d
# Execution de lmdz1d.e
./lmdz1d.e
# Sauvegarde du fichier phys.nc
\mv -f phys.nc phys0.nc
# Renomage du fichier binaire contenant les variables de l'interface, pour la lecture en replay
\mv -f dump_param_out.bin dump_param_in.bin
# Lancement du replay
./replay1d.e
