   SUBROUTINE thermcell_down(ngrid,nlay,po,pt,pu,pv,pplay,  &
     &           pplev,lmax,fup,eup,dup)

!--------------------------------------------------------------
!thermcell_env: calcule les caracteristiques de l environnement
!necessaires au calcul des proprietes dans le thermique
!--------------------------------------------------------------


   USE thermcell_ini_mod, ONLY : prt_level,RLvCp,RKAPPA,RETV
   IMPLICIT NONE

! arguments

   integer,intent(in) :: ngrid,nlay
   real,intent(in), dimension(ngrid,nlay) :: po,pt,pu,pv,pplay,eup,dup
   real,intent(in), dimension(ngrid,nlay+1) :: pplev,fup
   integer, intent(out), dimension(ngrid) :: lmax


   
! Local

   real, dimension(ngrid,nlay) :: edn,ddn
   real, dimension(ngrid,nlay+1) :: fdn

   integer ig,ilay
   real dqsat_dT
   logical mask(ngrid,nlay)

   edn(:,:)=0.
   ddn(:,:)=0.
   fdn(:,:)=0.

   ! lmax : indice de la derniere couche ou les thermiques sont actifs
   
   ! Convention de flux : fdn négatif vers le bas
   ! Pas évident qu'on veuille conserver ce choix

   do ilay=nlay+1,1,-1
      do ig=1,ngrid
         if (ilay.le.lmax(ig)) then
            edn(ig,ilay)=0.5*dup(ig,ilay)
            ddn(ig,ilay)=0.
            fdn(ig,ilay)=-(-fdn(ig,ilay+1)+edn(ig,ilay)-ddn(ig,ilay))
         endif
      enddo 
   enddo

   ! Suite du travail :
   ! Ecrire la conservervation de theta_l dans le panache descendant
   ! Eventuellement faire la transformation theta_l -> theta_v
   ! Si l'air est sec (et qu'on oublie le côté theta_v) on peut
   ! se contenter de conserver theta.
   !
   ! Connaissant thetadn, on peut calculer la flotabilité.
   ! Connaissant la flotabilité, on peut calculer w de proche en proche
   ! On peut calculer le detrainement de facon à garder alpha*rho = cste
   ! On en déduit l'entrainement latéral
   ! C'est le modèle des mini-projets.

!^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
! Initialisations :
!------------------


!
 RETURN
   END
