###########################################################################
# Environnement
local=`pwd -P`

../env_ciclad.sh

module list
which python
ulimit -s unlimited
ATLAS_DIR=${DODSDIR}/${login}/lmdz/atlas/Atlas$$ ; mkdir -p $ATLAS_DIR
STORAGE=${DODSDIR}/${login}/lmdz/STORE
dirpng=${DODSDIR}/${login}/lmdz/VLR

export PYTHONPATH=$PYTHONPATH:/home/fabric/users/denvil/climaf
export PATH=$PATH:/home/fabric/users/denvil/climaf/bin

\rm -rf $DODSDIR/$login/climafCache$$
mkdir -p $DODSDIR/$login/climafCache$$
export CLIMAF_CACHE=$DODSDIR/$login/climafCache$$
echo CLIMAF_CACHE $DODSDIR/$login/climafCache$$
###########################################################################
vars=""
vars="sst"
#runstxt=/home/fabric/LMDZ/multi/runs.txt

if [ $# = 1 ] ; then
   opts="`echo $1 | sed -e 's/,/ /g'`"
   for opt in $opts ; do
       echo $opt
       key=`echo $opt | cut -d= -f1`
       val=`echo $opt | cut -d= -f2`
       echo $key $val
       if [ "$key" = "RUN" ] ; then sim=$val ; fi
       if [ "$key" = "REF" ] ; then ref=$val ; fi
       if [ "$key" = "SEASON" ] ; then seas=$val ; fi
       if [ "$key" = "PROJ" ] ; then proj=$val ; fi
       if [ "$key" = "OUTDIR" ] ; then OUT_D=$val ; fi
       if [ "$key" = "RUNSTXT" ] ; then runstxt=$val ; fi
       if [ "$key" = "VARS" ] ; then vars="`echo $val | sed -e 's/+/ /g'`" ; fi
       if [ "$key" = "lonmin" ] ; then lonmin=$val ; fi
       if [ "$key" = "lonmax" ] ; then lonmax=$val ; fi
       if [ "$key" = "latmin" ] ; then latmin=$val ; fi
       if [ "$key" = "latmax" ] ; then latmax=$val ; fi
       if [ "$key" = "pmin" ] ; then pmin=$val ; fi
   done
elif [ $# = 0 ] ; then
   sim=$RUN
   ref=$REF
   seas=$SEASON
   proj=$PROJ
   OUT_D=$OUTDIR
   runstxt=$RUNSTXT
   vars=`echo $VARS | sed -e 's/+/ /g'`
   lonmin=$lonmin
   lonmax=$lonmax
   latmin=$latmin
   latmax=$latmax
   pmin=$pmin
   echo lonmin=$lonmin lonmax=$lonmax
   echo latmin=$latmin latmax=$latmax
   echo pmin=$pmin
else
  echo USE
  echo Job mode :
  echo qsub -v RUN=NPv5.3_1982_1989,SEASON=YEAR,PROJ=GLOB,OUTDIR=$MULTIDIR/V5/ATLAS,VARS=pr+tas atlas.sh
  echo interactif :
  echo ./atlas.sh RUN=NPv5.3_1982_1989,SEASON=YEAR,PROJ=GLOB,OUTDIR=$MULTIDIR/V5/ATLAS,VARS=pr+tas
  exit
fi

if [ "$vars" = "" ] ; then
   vars="pr tas hurs hfls hfss albt albtcs albs rldscs rlds rlus rsdscs rsds rsuscs rsus rsutcs rsut rlut rlutcs psl prw sst pme tasmax tasmin"
fi

if [ "$sim" != "OBS" ]; then
echo sim $sim
srun=`echo $sim | sed -e 's/_[0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]//'`
echo srun $srun
simdir=`grep -w "^$srun " $runstxt | awk ' { print $2 } '`
run=`basename $simdir `
years=`echo $sim | sed -e 's/'$srun'//' | sed -e 's/_//'`
sim=${run}_${years}

echo $run $years $sim $ref
echo ENTREES : $run, $years, $seas, $vars, $ref
echo simdir $simdir

echo run $run 
echo sim $sim
echo simdir $simdir
fi

keys_strgv=$sim$seas$proj$vars$ref
keys_strg=$sim$seas$proj$ref

mkdir -p $OUT_D
if [ -f $OUT_D/$keys_strg.ENCOURS ] ; then 
   echo $OUT_D/$keys_strg.ENCOURS
   exit # Si le même atlas est deja en cours de realisation on sort
else
   touch $OUT_D/$keys_strg.ENCOURS
fi

if [ "$OUT_D" = "" ] ; then
   $OUT_D=$STORAGE/NPV5LRL79/$run/ATLAS/SE_$years/ATM
fi

cd $ATLAS_DIR
echo sim $sim seas $seas > atlas.sh.log

case "$proj" in
   "SH"|"NH") pyatlas="atlas_SH.py --projection $proj" ;;
   "GLOB") Var3D=,ua,va,ta,hus,hur ; pyatlas=atlas_none.py ;;
   *) Var3D=,ua,va,ta,hus,hur ; pyatlas=atlas_none.py ;;
esac

   html=index_example_"$seas"_"$sim".html
   htmlopt=index_"${proj}"_"$seas"_"$sim".html
   echo rm -f $htmlopt
#
   for var in $vars; do
   datevar=`date`
   echo Creation repertoires *MAP* et check variables 3D
   mkdir -p ${dirpng}/${seas}/${sim}/MAP
   mkdir -p ${dirpng}/${seas}/${sim}/MAP/${proj}
#
   mkdir -p ${dirpng}/${seas}/${ref}/MAP
   mkdir -p ${dirpng}/${seas}/${ref}/MAP/${proj}
#
   mkdir -p ${dirpng}/${seas}/${sim}/DMAP_${ref}
   mkdir -p ${dirpng}/${seas}/${sim}/DMAP_${ref}/${proj}

   mapok=${dirpng}/${seas}/${sim}/MAP/${proj}/${var}.pdf
   dmapok=${dirpng}/${seas}/${sim}/DMAP_${ref}/${proj}/${var}.pdf
#
    datevar=`date`
#
# for var3D check if pres exist
#   echo ~/LMDZ/check/make_check_var3D_SE.sh $dirpng $seas $sim $ref $var 
#   ~/LMDZ/check/make_check_var3D_SE.sh $dirpng $seas $sim $ref $var > out_check_var3D_SE.log

 if [ "$var" == "ua" ] || [ "$var" == "va" ] || [ "$var" == "ta" ] || [ "$var" == "hur" ] || [ "$var" == "hus" ]; then
    echo python ${local}/$pyatlas -v $var -s $sim -t $ref -p $seas -r $proj --dirpng ${dirpng} 
    python ${local}/$pyatlas -v $var -s $sim -t $ref -p $seas -r $proj --dirpng ${dirpng} 
 else
    echo python ${local}/$pyatlas -v $var -s $sim -t $ref -p $seas -r $proj --dirpng ${dirpng} --lonmin ${lonmin} --lonmax ${lonmax} --latmin ${latmin} --latmax ${latmax}
    python ${local}/$pyatlas -v $var -s $sim -t $ref -p $seas -r $proj --dirpng ${dirpng} --lonmin ${lonmin} --lonmax ${lonmax} --latmin ${latmin} --latmax ${latmax}
 fi
#
   echo Creation graphes png
   ${local}/make_pdf2png.sh $dirpng $seas $proj $sim $ref $var > out_pdf2png.log
#
   done

   if [ ! -f "$htmlopt"  -o "`wc -l $htmlopt | awk ' { print $1 } '`" = "0" ] ; then
      echo ECHEC ATLAS : $htmlopt inexistant ou vide | tee >>  atlas.sh.log
      echo ECHEC ATLAS : $htmlopt inexistant ou vide
   else
      pwd
      \cp -f $htmlopt $OUT_D/
      sed -i -e "s:thredds\/IPSLFS:thredds\/fileServer\/ipsl_thredds:g" $OUT_D/$htmlopt

      echo NOUVEL ATLAS DISPONIBLE SUR $PathHtml | tee >>  atlas.sh.log
      echo NOUVEL ATLAS DISPONIBLE SUR $PathHtml
   fi

\rm -f $OUT_D/$keys_strg.ENCOURS

\rm -rf $DODSDIR/$login/climafCache$$
