#set -vx

local=`pwd -P`
cd $local
echo REPERTOIRE LOCAL :  $local

echo '############################################################'
echo  0/ gestion des options
echo '############################################################'
pcmdi_metrics=0
tuning_metrics=1
und=0
zon=1
html=1
atlas=1
#newatlas=0
atlas_cesmep=0
get=0
cmor=1
regdyn=0
lma=0
trmm=0
axe2=0
axe4=0
esmval2=0
reflcld_histo=0
vertcld_calipso=0
stations_day=0
stations_mth=0
qsub=1
mjo=0
river=0
dataref=1

ref=OBS
echo $ref

lonmin=-180
lonmax=180
latmin=-90
latmax=90
pmin=1

# ./job_multi.sh -1D 0 -get 0 -atlas 0 -pcmdi 0 -tuning 0 -lma 0 -trmm 0
runstxt=$local/runs.txt

while test -n "${1}"; do
   case $1 in
      -1D) und=$2 ; shift ;;
      -get) get=$2 ; shift ;;
      -cmor) cmor=$2 ; shift ;;
      -zon) zon=$2 ; shift ;;
      -atlas) atlas=$2 ; shift ;;
      -atlas_cesmep) atlas_cesmep=$2 ; shift ;;
      -pcmdi) pcmdi_metrics=$2 ; shift ;;
      -tuning) tuning_metrics=$2 ; shift ;;
      -runstxt) runstxt=$2 ; shift ;;
      -lma) lma=$2 ; shift ;;
      -trmm) trmm=$2 ; shift ;;
      -axe4) axe4=$2 ; shift ;;
      -axe2) axe2=$2 ; shift ;;
      -regdyn) regdyn=$2 ; shift ;;
      -esmval2) esmval2=$2 ; shift ;; 
      -stations_day) stations_day=$2 ; shift ;; 
      -stations_mth) stations_mth=$2 ; shift ;; 
      -reflcld_histo) refld_histo=$2 ; shift ;;
      -vertcld_calipso) vertcld_calipso=$2 ; shift ;;
      -mjo) mjo=$2 ; shift ;; 
      -river) river=$2 ; shift ;;
      -dataref) dataref=$2 ; shift ;;
      -lonmin) lonmin=$2 ; shift ;;
      -lonmax) lonmax=$2 ; shift ;;
      -latmin) latmin=$2 ; shift ;;
      -latmax) latmax=$2 ; shift ;;
      -pmin) pmin=$2 ; shift ;;
      *) comp=$1 ;;
   esac
   shift
done

echo multi=$comp region: lonmin=$lonmin lonmax=$lonmax latmin=$latmin latmax=$latmax
echo multi=$comp pmin: pmin=$pmin
rm -f out.com$$
runstxt=$local/runs.txt
echo runstxt= $runstxt

echo DODSDIR : $DODSDIR
MAIN_SE=$DODSDIR/$login/lmdz/SE
TS_DA=$DODSDIR/$login/lmdz/TS_DA
TS_MO=$DODSDIR/$login/lmdz/TS_MO
MULTIDIR=$DODSDIR/$login/lmdz/MultiSimu

if [ ! -d $MULTIDIR ] ; then mkdir -p $MULTIDIR ; fi
if [ ! -d $MAIN_SE ] ; then mkdir -p $MAIN_SE ; fi
if [ ! -d $MAIN_MO ] ; then mkdir -p $MAIN_MO ; fi
if [ ! -d $MAIN_DA ] ; then mkdir -p $MAIN_DA ; fi

COMP_D=$MULTIDIR/$comp
DEF_FILE=$COMP_D/def.txt ; if [ ! -f $DEF_FILE ] ; then echo renseigner $DEF_FILE ; exit ; fi
LOGD=$COMP_D/log ; mkdir -p $LOGD
outfile=$LOGD/out$$ ; if [ -f ${outfile} ] ; then \rm -f $outfile ; fi
echo Ecriture des logs dans $outfile

###
#~/LMDZ/check/make_warning.sh $COMP_D
### nom2
listsims=""  ; for s  in `awk ' {print $1} ' $DEF_FILE | uniq`          ; do listsims="$listsims $s"    ; done
#echo listsims $listsims

listsims=""  ; for s  in `awk ' {print $1} ' $DEF_FILE | uniq`          ; do listsims="$listsims $s"    ; done
echo listsims $listsims
### nom1, simdir
for s in $listsims ; do
### simdir
simdir=`grep -w "^$s "  $runstxt | awk ' { print $2 } '`
### nom1
ss=`basename $simdir `
for year in `grep -w "^$s" $DEF_FILE | awk ' { print $2 } '` ; do
#file=${MAIN_SE}/ORIG/${s}_SE_${year}_1M_histmth.nc
file=${MAIN_SE}/ORIG/${ss}_SE_${year}_1M_histmth.nc

echo $file $year

if [ ! -f ${file} ]; then
 if [ -f ${simdir}/ATM/Analyse/SE/${ss}_SE_${year}_1M_histmth.nc ]; then
  ln -s ${simdir}/ATM/Analyse/SE/${ss}_SE_${year}_1M_histmth.nc $file
 elif [ "${ss}" == "UQLMDZ6A1000" ]; then
  echo NO need to ln -s; the *1M_histmth.nc does not exist anymore
 else
  ln -s ${simdir}/ATM/Output/MO/${ss}_${year}0101_${year}1230_1M_histmth.nc $file
 fi
fi

\rm ${MAIN_SE}/ORIG/UQLMDZ6AW1000_SE_1979_1988_1M_histmth.nc
done
done
#${local}/../check/mk_check-avail-data.sh ${comp}

echo ### On supprime dans def.txt les lignes vides ########
sed -i "/^[ \t]*$/d" $DEF_FILE

echo ### On teste d abord la coherence des noms des simulations dans def.txt et $runstxt ################
echo MULTI-ATLAS "$comp"
for s in $listsims ; do
srun=`grep -w "^$s "  $runstxt | awk ' { print $1 } '`
echo 's='"$s" '    srun='  "$srun"
if [ "$s" != "$srun" ] ; then
   #echo Meme nom de la simulation dans def.txt et $runstxt 's=' "$s" '    srun='  "$srun"
#else
   echo ATTENTION : la simulation "$s" de votre def.txt n est pas repertoriee dans $runstxt >${LOGD}/error_${comp}
   echo             ou le meme nom est attribue a plusieures simulations >> ${LOGD}/error_${comp}
   echo Il faut la rajouter dans $runstxt >> ${LOGD}/error_${comp}
   echo avec le chemin vers les SE et TS dans ciclad : /thredds/ipsl/fabric/IGCM_OUT >> ${LOGD}/error_${comp}
   echo             ou renomer votre simulation >> ${LOGD}/error_${comp}
   more ${LOGD}/error_${comp}
exit
fi
echo Checking if $s simulation is referenced many times in runs.txt
#nrun=`./how_many_times_run.sh $s`
#nrun=`./how_many_times_run.sh $srun`
nrun=1

if [ "$nrun" != "1" ]; then
 echo Simulation $s est repertoriee ${nrun} fois dans $runstxt >> ${LOGD}/error_${comp}
 echo STOPping here >> ${LOGD}/error_${comp}
 more ${LOGD}/error_${comp}
 exit
fi
done
#exit
listruns=""
listrunss=""
listrunse=""
if [ ! -d $MAIN_SE/ORIG ] ; then mkdir -p $MAIN_SE/ORIG ; fi
for s in $listsims ; do 
simdir=`grep -w "^$s "  $runstxt | awk ' { print $2 } '`
echo $simdir
( cd $MAIN_SE/ORIG ; ln -sf $simdir/ATM/Analyse/SE/*mth*nc . ) > /dev/null 2>&1
echo $simdir
ss=`basename $simdir `
listruns="$listruns $ss"
for year in `grep -w "^$s" $DEF_FILE | awk ' { print $2 } '` ; do
listrunss="$listrunss ${ss}_$year"
listrune="$listrune ${ss}_SE_$year"
done
done
#echo listruns = $listruns
#echo listrunss= $listrunss
#echo listrune= $listrune 
#ls -lrt $MAIN_SE/ORIG # Eviter de laisser des ls qui rendent la sortire illisible FH
#listsimss="" ; for ss in `awk ' {print $1"_"$2 } ' $DEF_FILE`    ; do listsimss="$listsimss $ss" ; done

ns=0
listsimss="" ; 
for ss in `awk ' {print $1"_"$2 } ' $DEF_FILE`    ; do  
if [ $dataref = 0 ] ; then
   if [ ${ns} = 0 ] ; then
      ref=$ss
      echo ref=$ref
   fi  
fi
let "ns = ${ns} + 1"
listsimss="$listsimss $ss" ; 
done
echo ref=$ref

listsimse="" ; for se in `awk ' {print $1"_SE_"$2 } ' $DEF_FILE` ; do listsimse="$listsimse $se" ; done
echo listsims $listsims
echo listsimss $listsimss
echo listsimse $listsimse

echo SIMULATIONS: $listsims

RUNS=""
RUNS=`awk ' {print $1"_"$2 } ' $DEF_FILE`
echo listrunss=$RUNS

echo '########################################################################'
echo  1/ Rapatriement des simulations manquantes
echo '########################################################################'
#### AI avril 2020 ################ Avant l acces directe aux simulations sur le dods du CCRT
# Adresses web ne sont plus a jours
# A commenter les adresses web CCRT 
# A mettre a jours les adress web IDRIS
# Rajouter d'autres machines avec rsynk, wget ou ssh ...

if [ $get = 1 ] ; then

cd $MAIN_SE
for sim in $listsimss ; do echo ./getun.sh ${sim} >> $outfile 2>&1 ; ./getun.sh ${sim} ; done
cd $TS_DA
for sim in $listsimss ; do echo ./getun.sh ${sim} >> $outfile 2>&1 ; ./getun.sh ${sim} ; done
cd $TS_MO
for sim in $listsimss ; do echo ./getun.sh ${sim} >> $outfile 2>&1 ; ./getun.sh ${sim} ; done

fi

echo '########################################################################'
echo  1.1/ Check des fichiers input et des variables demandees pour l atlas avec
echo       des exit si un des fichiers ou des variables ne sont pas accessibles
echo '########################################################################'
#IM TBC ${local}/../check/make_check_fin.sh $comp ${LOGD}/check_finput$$ 2>&1

if [ $cmor = 1 ] ; then
 cp cmor.sh $MAIN_SE/. 
 cp season.sh $MAIN_SE/.
 cd $MAIN_SE
 chmod +x cmor.sh
 chmod +x season.sh
#########################################################################
# 1.2 "Cmorisation des fichiers mensuels : traduction au format CMIP
#########################################################################
# Deux lignes suivantes modif FH 2016/11/09
# Files are taken from /thredds/ipsl/fabric/lmdz/SE/ORIG and
# results are in /thredds/ipsl/fabric/lmdz/SE/CMOR
#########################################################################

echo cmor.sh : output dans ${LOGD}/cmor$$
./cmor.sh -runsfile $runstxt $comp > ${LOGD}/cmor$$ 2>&1
if [ $? != 0 ] ; then exit ; fi # Probleme de histmth non present. On arrete tout

#########################################################################
# 1.3 Interpolate fields on a common horizontal grid (VLR) and
#########################################################################
#     average in time "YEAR", "JJA" ...
#     Results are put on
#     /thredds/ipsl/fabric/lmdz/VLR/YEAR/[SIMU_NAME]_[period]/NC
#     If wanting to rerun season.sh for observations :
#     ./season.sh -s OBS
#########################################################################

cd $MAIN_SE
echo season.sh : output dans ${LOGD}/season$$
./season.sh -comp $comp > ${LOGD}/season$$ 2>&1
cd $local

fi

echo '########################################################################'
echo  2/ Lancement des atlas manquant
echo '########################################################################'
natlas=`wc -l $COMP_D/atlas-def | awk ' { print $1 } '`
count_atlas=0

if [ $atlas = 1 ] ; then
#if [ $newatlas = 1 ]; then
#sed -e 's/COMPAR/'${comp}'/' ${local}/atlas/make_atlas.sh > ${local}/atlas/make_atlas_${comp}.sh
#$submit -v COMP=${comp},DATAREF=${dataref} ${local}/atlas/make_atlas_${comp}.sh

#./make_timecount.sh ${comp}

#else

for sim in $listsimss ; do
   il=1
   if [ ! -f $COMP_D/atlas-def ] ; then
      echo Definir les atlas a construire dans $COMP_D/atlas-def
      echo Example :
      cat $COMP_D/../CMIP5to6/atlas-def
   fi
   while [ $il -le $natlas ] ; do
      line=`sed -n -e ${il}p $COMP_D/atlas-def`
      seas=`echo $line | awk ' { print $1 } '`
      proj=`echo $line | awk ' { print $2 } '`
      vars=`echo $line | awk ' { print $3 } '`
      atlas=${sim}+${seas}+${proj}+$vars
      cd ${local}/atlas
      varg=`echo $vars | sed -e 's/,/+/g'`
      echo Atlas $atlas a creer
      if [ $qsub = 0 ] ; then
         ${local}/atlas/atlas.sh RUN=$sim,SEASON=$seas,PROJ=$proj,OUTDIR=$COMP_D/ATLAS,REF=$ref,VARS="$varg",RUNSTXT=$runstxt,lonmin=$lonmin,lonmax=$lonmax,latmin=$latmin,latmax=$latmax,pmin=$pmin >> $outfile
      else
         echo $submit -v RUN=$sim,SEASON=$seas,PROJ=$proj,OUTDIR=$COMP_D/ATLAS,REF=$ref,VARS="$varg",RUNSTXT=$runstxt,lonmin=$lonmin,lonmax=$lonmax,latmin=$latmin,latmax=$latmax,pmin=$pmin atlas.sh >> ${LOGD}/ATLAS$$ 2>&1
         $submit -v RUN=$sim,SEASON=$seas,PROJ=$proj,OUTDIR=$COMP_D/ATLAS,REF=$ref,VARS="$varg",RUNSTXT=$runstxt,lonmin=$lonmin,lonmax=$lonmax,latmin=$latmin,latmax=$latmax,pmin=$pmin atlas.sh
         if [ "$ref" != "OBS" ]; then
            echo $submit -v RUN=$sim,SEASON=$seas,PROJ=$proj,OUTDIR=$COMP_D/ATLAS,REF=OBS,VARS="$varg",RUNSTXT=$runstxt,lonmin=$lonmin,lonmax=$lonmax,latmin=$latmin,latmax=$latmax,pmin=$pmin atlas.sh >> ${LOGD}/ATLAS$$ 2>&1
            $submit -v RUN=$sim,SEASON=$seas,PROJ=$proj,OUTDIR=$COMP_D/ATLAS,REF=OBS,VARS="$varg",RUNSTXT=$runstxt,lonmin=$lonmin,lonmax=$lonmax,latmin=$latmin,latmax=$latmax,pmin=$pmin atlas.sh
         fi
      fi
      (( count_atlas = $count_atlas + 1 ))
      (( il = $il + 1 ))
   done
done
if [ $count_atlas != 0 ] ; then
    echo '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
    echo Les atlas manquant ont ete lances. Attendre leur
    echo creation pour relancer job_multi.sh
    echo '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
#   exit
fi

#fi #newatlas
fi #atlas

# atlas_cesmep : cles pour activer les nouveau atlas (C-ESM-EP)
# AI avril 2020 : Passage a la version v2 de C-ESM-EP
# FH Juin 2022 : Passage a la version v3 de C-ESM-EP (changement de prodigfs en thredds)
if [ $atlas_cesmep = 1 ] ; then
   cd ~/LMDZ/C-ESM-EP
   ./AtlasLMDZ.sh -runsfile $runstxt $comp >> ${LOGD}/CESMEP$$ 2>&1
fi # atlas_cesmep

echo '########################################################################'
echo  3/ Calcul des moyennes zonales nco
echo '#####################################################################'


#trace moy.zonale OBS + multi-simulations
if [ $zon = 1 ] ; then
   cd $local
   mkdir -p $COMP_D/ZON
   for sim in $listsimse OBS ; do
      echo make_MOY for simulation $sim, log in ${LOGD}/MOY$$
      years=`echo $sim | sed -e 's/_SE_/ /' | awk ' { print $2 } '`
      run=`echo $sim | sed -e 's/_SE_/ /' | awk ' { print $1 } '`
      ./make_MOY.sh "$years" YEAR "$run" GLOB      >> ${LOGD}/MOY$$ 2>&1
      ./make_MOY.sh "$years" YEAR "$run" ZON       >> ${LOGD}/MOY$$ 2>&1
      ./make_MOY.sh "$years" JJA "$run"  ZON       >> ${LOGD}/MOY$$ 2>&1
      ./make_MOY.sh "$years" DJF "$run"  ZON       >> ${LOGD}/MOY$$ 2>&1
      ./make_MOY.sh "$years" JJAS "$run" AMMACROSS >> ${LOGD}/MOY$$ 2>&1
      ./make_MOY.sh "$years" MAM "$run"  ZON       >> ${LOGD}/MOY$$ 2>&1
      ./make_MOY.sh "$years" SON "$run"  ZON       >> ${LOGD}/MOY$$ 2>&1
   done
   cd $local
### ajout nuages LMDZ dans la compa et doit faire des liens symbol. sur
#### les OBS calipso toujurs pour le moment
   echo mk_clouds_NOcalipso.sh, log in  ${LOGD}/calipso$$
   ./mk_clouds_NOcalipso.sh YEAR ZON       >> ${LOGD}/calipso$$ 2>&1
   ./mk_clouds_NOcalipso.sh DJF ZON        >> ${LOGD}/calipso$$ 2>&1
   ./mk_clouds_NOcalipso.sh JJA ZON        >> ${LOGD}/calipso$$ 2>&1
   ./mk_clouds_NOcalipso.sh JJAS AMMACROSS >> ${LOGD}/calipso$$ 2>&1
   ./mk_clouds_NOcalipso.sh MAM ZON        >> ${LOGD}/calipso$$ 2>&1
   ./mk_clouds_NOcalipso.sh SON ZON        >> ${LOGD}/calipso$$ 2>&1

   echo multi_ZONE.sh, log in ${LOGD}/Z$$
   ./multi_ZONE.sh YEAR $comp ZON -runsfile $runstxt >> ${LOGD}/Z$$ 2>&1
   ./multi_ZONE.sh JJA $comp ZON -runsfile $runstxt  >> ${LOGD}/Z$$ 2>&1
   ./multi_ZONE.sh DJF $comp ZON -runsfile $runstxt  >> ${LOGD}/Z$$ 2>&1
   ./multi_ZONE.sh JJAS $comp AMMACROSS -runsfile $runstxt >> ${LOGD}/Z$$ 2>&1
   ./multi_ZONE.sh MAM $comp ZON -runsfile $runstxt  >> ${LOGD}/Z$$ 2>&1
   ./multi_ZONE.sh SON $comp ZON -runsfile $runstxt  >> ${LOGD}/Z$$ 2>&1
fi

if [ ! -f $COMP_D/1D/1D.html -a $und = 1  ] ; then
echo '#####################################################################'
echo 4/ Lancement du 1D 
echo '#####################################################################'
    cd $COMP_D
    echo log in ${LOGD}/1D$$
    ~/LMDZ/1D/serie1d.sh $comp  > ${LOGD}/1D$$ 2>&1
    cd $local
fi

if [ $tuning_metrics = 1 -a ! -d $COMP_D/METRICS ] ; then
echo '#####################################################################'
echo 5.1/ Metriques LMD : $tuning_metrics
echo '#####################################################################'
   echo metrics.sh, log in ${LOGD}/METRICS$$
   cd $local/METRICS
   #./metrics.sh -runsfile $runstxt $comp
   ./metrics.sh $comp > ${LOGD}/METRICS$$ 2>&1
fi

if [ $pcmdi_metrics = 1 ] ; then
echo '#####################################################################'
echo 5.2/ Metriques PCMDI : $pcmdi_metrics
echo '#####################################################################'
cd $local
   ./make_pcmdi.sh $comp
fi

if [ $regdyn = 1 ]; then
echo '#####################################################################'
echo 6/ Sorting by dynamical regimes : $regdyn
echo '#####################################################################'
   cd ~/users/musat/regdyn/clean_regdyn
   ./mk_all_regdyn.sh $comp 0 > ${LOGD}/REGDYN$$ 2>&1
   cd $local
fi

if [ $esmval2 = 1 ]; then
echo '#####################################################################'
echo 7/ ESMvalTool : $esmval2
echo '#####################################################################'
   cd $local
   ./cvdp4atlas.sh $comp
   ./perfm4atlas.sh $comp
fi   

if [ $mjo = 1 ]; then
echo '#####################################################################'
echo 8.1/ Rainfall variability / MJO diagnostics : $mjo
echo '#####################################################################'
   cd ~/users/idelkadi/MJO
   ./make_diagnosMJO.sh $comp
fi

if [ $river = 1 ]; then 
   cd ~/users/idelkadi/AXE1/River
   ./make_diagnoRiver.sh $comp
fi  

if [ $lma = 1 ]; then
echo '#####################################################################'
echo 8.2/ Rainfall variability / LMA analysis of the MJO : $lma
echo '#####################################################################'
   #IM150722 cd $local
   #IM120722 ./make_lma.sh $comp
   cd ~/users/musat/d_AXE2_LMA/
   ./make_LMA.sh $comp >  ${LOGD}/LMA$$ 2>&1
   cd ${local}
fi

if [ $axe2 = 1 ]; then
echo '#####################################################################'
echo 8.3/ Rainfall variability / metrics
echo '#####################################################################'
   cd $local
   bash  make_axe2.sh -runstxt $runstxt $comp    >  ${LOGD}/axe2_$$ 2>&1
   echo  make_axe2.sh -runstxt $runstxt $comp '-->' ${LOGD}/axe2_$$
fi

if [ $trmm = 1 ]; then
echo '#####################################################################'
echo 8.4/ Rainfall variability / Marine Bonazzola : $trmm
echo '#####################################################################'
   cd ~/users/musat/atlas/d_AXE2
   ./Axe2_Marine.sh $comp
   cd $local
fi

if [ $river = 1 ]; then 
echo '#####################################################################'
echo 9/ River discharges
echo '#####################################################################'
   cd ~/users/idelkadi/AXE1/River
   ./make_diagnoRiver.sh $comp
fi  

if [ $axe4 = 1 ]; then
echo '#####################################################################'
echo 10/ Poles
echo '#####################################################################'
  cd $local
   ./make_axe4.sh $comp
fi

if [ "$reflcld_histo" = "1" ] ; then
echo '#####################################################################'
echo 11/ reflcld_histo : $reflcld_histo
echo '#####################################################################'
   cd ~/users/idelkadi/AXE3/CldReflCldFrac
   ./make_scatReflCld.sh $comp
   cd $local
fi

if [ $vertcld_calipso = 1 ] ; then
echo '#####################################################################'
echo 12/ Calipso : $vertcld_calipso
echo '#####################################################################'
   cd ~/users/idelkadi/AXE3/Calipso/CoupeVerticale/DJF
   ./make_VerticalMzCldCalipso.sh $comp
   cd ~/users/idelkadi/AXE3/Calipso/CoupeVerticale/JJA
   ./make_VerticalMzCldCalipso.sh $comp
   cd ~/users/idelkadi/AXE3/Calipso/CoupeVerticale/MAM
   ./make_VerticalMzCldCalipso.sh $comp
   cd ~/users/idelkadi/AXE3/Calipso/CoupeVerticale/SON
   ./make_VerticalMzCldCalipso.sh $comp
   cd ~/users/idelkadi/AXE3/Calipso/Stratos
   ./make_StratosCalipso.sh $comp
fi


if [ $stations_day = 1 ] ; then
echo '#####################################################################'
echo 13/ Stations
echo '#####################################################################'
   ~/users/Binta/bibi.sh $comp
   ~/users/cheruy/bibi.sh $comp
fi

if [ $stations_mth = 1 ] ; then
   ~/users/traore/SE_buoy.sh $comp
fi

if [ $html = 1 ] ; then
echo '#####################################################################'
echo 14/ generation des pages html
echo '#####################################################################'
   cd ${local}
   echo ./make_html_libigcm.sh --comp $comp --runstxt $runstxt
   ./make_html_libigcm.sh --comp $comp --runstxt $runstxt > ${LOGD}/html$$ 2>&1
   echo log in ${LOGD}/html$$ 
   ./html_entete.sh $comp ${dataref} >> ${LOGD}/html$$ 2>&1
   cd ${local}/html
   ./make_index_html.sh ${comp} ${dataref} >> ${LOGD}/html$$ 2>&1
   cd $local
   ./html_tuning.sh  $comp           >> ${LOGD}/html$$ 2>&1
   ./html_tuning_min.sh  $comp       >> ${LOGD}/html$$ 2>&1
   ./html_accueil.sh  $comp          >> ${LOGD}/html$$ 2>&1
   ./html_1D.sh  $comp               >> ${LOGD}/html$$ 2>&1
   ./html_lma.sh $comp               >> ${LOGD}/html_LMA$$ 2>&1
   ./html_pcmdi.sh $comp             >> ${LOGD}/html$$ 2>&1
   ./html_all.sh >| $MULTIDIR/all.html

   # html pour les métriques
#   cat $COMP_D/entete.html doc_pcmdi.html >| $COMP_D/PCMDI.html
#   ref=`echo $listsimss | awk ' { print $1 } '`
#   echo "<h1> Metrics with respect to $ref </h1>" >>  $COMP_D/PCMDI.html
#   cat $COMP_D/pcmdi_metrics.html >> $COMP_D/PCMDI.html
#   echo "<h1> Metrics with respect to AR4.00 </h1>" >>  $COMP_D/PCMDI.html
#   cat $COMP_D/metrics-AR4-as-ref.html >> $COMP_D/PCMDI.html
#   echo "<h1> Metrics with respect to CMIP5/AMIP multi model </h1>" >>  $COMP_D/PCMDI.html
#   cat $COMP_D/metrics-CMIP5-AMIP-as-ref.html >> $COMP_D/PCMDI.html
   for i in 1 2 3 4 5 6 7 ; do
        ./html_axe$i.sh  $comp >> ${LOGD}/html$$ 2>&1
   done

   echo Multi atlas, log in ${LOGD}/multiatlas$$ 
#  for proj in GLOB SH NH ; do
#  for proj in ATLTN GLOB SH NH ; do
   for proj in GLOB SH NH ; do
   for bias in BIAS MAPS ; do
       for season in YEAR DJF JJA MAM SON ; do
        ./multi_atlas.sh $comp $bias $season $proj $RUNS  >> ${LOGD}/multiatlas$$ 2>&1
       done
   done
   done
#exit
#   cd $COMP_D
#   ln -sf BIASYEAR.html  $comp.html
#   ln -sf ACCUEIL.html  $comp.html
cd $local
./webpage_multi.sh $comp
fi

echo UN NOVEL MULTI ATLAS EST DISPONIBLE sur $COMP_D/ACCUEIL.html
