
! $Id: $

MODULE infotrac_phy

   INTEGER,                 SAVE :: nqtot                       !--- Tracers nb in dynamics (incl. higher moments + H2O)
   CHARACTER(LEN=maxlen),   SAVE :: type_trac                   !--- Keyword for tracers type
   CHARACTER(LEN=maxlen),   SAVE, ALLOCATABLE :: types_trac(:)  !--- Parsed version (one or several components name(s))
!$OMP THREADPRIVATE(nqtot, type_trac, types_trac)

CONTAINS

SUBROUTINE init_infotrac_phy(nqtot_, type_trac_)
   USE strings_mod, ONLY: maxlen, strParse
   IMPLICIT NONE
   INTEGER,          INTENT(IN) :: nqtot_
   CHARACTER(LEN=*), INTENT(IN) :: type_trac_

   nqtot = nqtot_
   IF(strParse(type_trac, '|', types_trac)) CALL abort_physic(modname,'can''t parse "type_trac = '//TRIM(type_trac)//'"',1)
   type_trac = type_trac_

  END SUBROUTINE init_infotrac_phy

END MODULE infotrac_phy
