#ifdef ISO
#ifdef ISOTRAC
! $Id: $

MODULE isotrac_mod
use infotrac_phy, ONLY: niso,ntiso,ntraceurs_zone=>nzone
use isotopes_mod, only: ridicule

IMPLICIT NONE
SAVE

! contient toutes les variables traceurs isotopiques + les routines specifiquement
! traceurs isotopiques

      real ridicule_trac
      parameter (ridicule_trac=ridicule*1e4)

integer, save ::  option_traceurs 
integer, save ::  ntraceurs_zone_opt ! ntraceurs_zone propre à l'option
! on vérifie que ça correspond bien à ntraceurs_zone d'infotrac
integer, save ::  ntraceurs_zoneOR
!$OMP THREADPRIVATE(option_traceurs,ntraceurs_zone_opt,ntraceurs_zoneOR)
integer, save ::  initialisation_isotrac
                ! 1 pour idéalisé
                ! 0 pour lecture dans fichier
!$OMP THREADPRIVATE(initialisation_isotrac)

! variables spécifiques aux différentes options, mais necessaires au
! calcul du nombre de zones de traceurs
! si option=3
integer, save :: use_bassin_atlantic
!$OMP THREADPRIVATE(use_bassin_atlantic)
integer, save :: use_bassin_medit
!$OMP THREADPRIVATE(use_bassin_medit)
integer, save :: use_bassin_indian
!$OMP THREADPRIVATE(use_bassin_indian)
integer, save :: use_bassin_austral
!$OMP THREADPRIVATE(use_bassin_austral)
integer, save :: use_bassin_pacific
!$OMP THREADPRIVATE(use_bassin_pacific)
integer, save :: use_bassin_merarabie
!$OMP THREADPRIVATE(use_bassin_merarabie)
integer, save :: use_bassin_golfebengale
!$OMP THREADPRIVATE(use_bassin_golfebengale)
integer, save :: use_bassin_indiansud
!$OMP THREADPRIVATE(use_bassin_indiansud)
integer, save :: use_bassin_tropics
!$OMP THREADPRIVATE(use_bassin_tropics)
integer, save :: use_bassin_midlats
!$OMP THREADPRIVATE(use_bassin_midlats)
integer, save :: use_bassin_hauteslats
!$OMP THREADPRIVATE(use_bassin_hauteslats)
integer, save :: bassin_atlantic
!$OMP THREADPRIVATE(bassin_atlantic)
integer, save :: bassin_medit
!$OMP THREADPRIVATE(bassin_medit)
integer, save :: bassin_indian
!$OMP THREADPRIVATE(bassin_indian)
integer, save :: bassin_austral
!$OMP THREADPRIVATE(bassin_austral)
integer, save :: bassin_pacific
!$OMP THREADPRIVATE(bassin_pacific)
integer, save :: bassin_merarabie
!$OMP THREADPRIVATE(bassin_merarabie)
integer, save :: bassin_golfebengale
!$OMP THREADPRIVATE(bassin_golfebengale)
integer, save :: bassin_indiansud
!$OMP THREADPRIVATE(bassin_indiansud)
integer, save :: bassin_tropics
!$OMP THREADPRIVATE(bassin_tropics)
integer, save :: bassin_midlats
!$OMP THREADPRIVATE(bassin_midlats)
integer, save :: bassin_hauteslats
!$OMP THREADPRIVATE(bassin_hauteslats)
! si option=4
integer nzone_temp
parameter (nzone_temp=1)
real, save :: zone_temp1,zone_tempf,zone_tempa  
!$OMP THREADPRIVATE(zone_temp1,zone_tempf,zone_tempa)
! si option 14
integer nzone_lat
parameter (nzone_lat=4)
integer nzone_pres
parameter (nzone_pres=3)
real, save :: zone_pres1,zone_presf,zone_presa 
!$OMP THREADPRIVATE(zone_pres1,zone_presf,zone_presa) 
real, save :: dlattag,lattag_min
!$OMP THREADPRIVATE(dlattag,lattag_min)


! option 1: on trace evap ocean et continent séparement  
! option 2: on trace evap ocean, continent et evap precip
! option 3: on trace evap différents bassins océaniques 
!       + continents + résidu
!       attention, choisir dans ce cas les bassins océaniques
!       dans iso_traceurs_opt3F90.h 
! option 4: tracage par température minimale
!       dans ce cas, on définit des bins dans iso_traceurs_opt4.h
! option 5: pour AMMA: on taggue résidu/AEJ/flux mousson/Harmattan
! option 6: taggage des ddfts
! option 7: pour Sandrine: taggage de la vapeur à 700hPa pour omega500<-20 TODO
! option 8: pour Sandrine: taggage de la vapeur entre 950 et 800hPa, omega de 0 à 25 hPa et de l'évaoration en omega<-20. TODO
! option 9: taggage du condensat et de la revap precip
! option 10: taggage evap oce, transpiration et evaporation
! fractionante. A utiliser quand on couple avec ORCHIDEE
! option 11: comme 2, mais on trace juste revap precip et reste
! option 12: taggage evap oce, sol nu, canop et reste evap cont. 
! A utiliser quand on couple avec ORCHIDEE
! option 13: taggage température minimale + revap precip
! option 14: taggage lat et altitude de dernière saturation (niveaux de pression) + evap surf
! otion 15: taggage irrigation
! option 16: taggage precip selon saisons et fonte neige: seulement pour ORCHIDEE
! option 17: taggage température minimum de condensation directement dans la convection et la cond LS, + evap sfc, condensat et precipitation
! option 18: idem 17 mais on tague qsmin au lieu de Tmin
! option 19: on tag vap residuelle, vap residuelle dans ddfts, sfc, cond, rev
! option 20: on taggue vapeur tropicale vs vapeur extratropicale
! option 21: taggage de 2 boites 3D: extratropiques (>35°) et UT tropicale (15-15°, > 500hPa)
! option 22: tagage de la vapeur proccessée dans les zones très convectives
                
        ! ces variables sont initialisées dans traceurs_init
        
integer, ALLOCATABLE, DIMENSION(:), save :: index_iso
!$OMP THREADPRIVATE(index_iso)
integer, ALLOCATABLE, DIMENSION(:), save ::  index_zone
!$OMP THREADPRIVATE(index_zone)
integer, ALLOCATABLE, DIMENSION(:,:), save ::  itZonIso_loc ! il y a déjà un itZonIso dans infotrac: vérifier que c'est le même
!$OMP THREADPRIVATE(itZonIso_loc)
character*3, ALLOCATABLE, DIMENSION(:), save :: strtrac
!$OMP THREADPRIVATE(strtrac)
! -> tout ça passe maintenant par infotrac

integer, ALLOCATABLE, DIMENSION(:), save :: bassin_map
integer, ALLOCATABLE, DIMENSION(:,:), save :: boite_map
!$OMP THREADPRIVATE(bassin_map,boite_map)


        ! traitement recyclage et evap
integer, save :: izone_cont ! pour le recyclage continental
!$OMP THREADPRIVATE(izone_cont)
integer, save :: izone_oce ! pour l'océan
!$OMP THREADPRIVATE(izone_oce)
integer, save :: izone_poubelle ! pour les petits résidus numériques
!$OMP THREADPRIVATE(izone_poubelle)
integer, save :: izone_init ! pour l'initialisation par défaut
!$OMP THREADPRIVATE(izone_init)
integer, save :: izone_revap ! pour l'évap des gouttes
!$OMP THREADPRIVATE(izone_revap)
integer, save :: option_revap
!$OMP THREADPRIVATE(option_revap)
integer, save :: option_tmin
!$OMP THREADPRIVATE(option_tmin)
integer, save :: option_cond
!$OMP THREADPRIVATE(option_cond)
integer, save :: izone_cond
!$OMP THREADPRIVATE(izone_cond)
real evap_franche
parameter (evap_franche=1e-6) ! en kg/m2/s

! specifique à option 4:
real, save ::  zone_temp(nzone_temp-1)
!$OMP THREADPRIVATE(zone_temp)
! si option 5
integer, save :: izone_aej
!$OMP THREADPRIVATE(izone_aej)
integer, save :: izone_harmattan
!$OMP THREADPRIVATE(izone_harmattan)
integer, save :: izone_mousson
!$OMP THREADPRIVATE(izone_mousson)
! si option 6
integer, save :: izone_ddft
!$OMP THREADPRIVATE(izone_ddft)
! si option 10
integer, save :: izone_contfrac
!$OMP THREADPRIVATE(izone_contfrac)
! si option 12	
integer, save :: izone_contcanop
!$OMP THREADPRIVATE(izone_contcanop)
! specifique à option 13:
real, save ::  zone_pres(nzone_pres-1)
!$OMP THREADPRIVATE(zone_pres)
! si option 14
real, save ::  zone_lat(nzone_lat-1)
!$OMP THREADPRIVATE(zone_lat)
! si option 15
integer, save :: izone_irrig
!$OMP THREADPRIVATE(izone_irrig)
! si option 17
real, save ::  seuil_tag_tmin
!$OMP THREADPRIVATE(seuil_tag_tmin)
real, save ::  seuil_tag_tmin_ls
!$OMP THREADPRIVATE(seuil_tag_tmin_ls)
integer, save :: option_seuil_tag_tmin
!$OMP THREADPRIVATE(option_seuil_tag_tmin)
! si option 20
integer, save :: izone_trop,izone_extra
real, save ::  lim_tag20 
!$OMP THREADPRIVATE(izone_trop,izone_extra,lim_tag20)
! si option 21: on garde izone_trop,izone_extra  
! si opt 22
integer, save :: izone_conv_BT,izone_conv_UT
real, save ::  lim_precip_tag22 
!$OMP THREADPRIVATE(izone_conv_BT,izone_conv_UT,lim_precip_tag22)


CONTAINS

      subroutine iso_traceurs_init()

      use IOIPSL ! getin
      USE infotrac_phy, ONLY: itZonIso
      USE isotopes_mod, ONLY: iso_eau,ntracisoOR,initialisation_iso
      USE dimphy, only: klon,klev

        implicit none


        ! définition de quelles zones et quelles isotopes représentent
        ! les traceurs

        ! inputs, outputs
        ! ! c'est les variables dans traceurs.h qui sont modifiées

        ! locals
        integer itrac,izone,ixt,k
        integer izone_pres,izone_lat
        character*2 strz,strz_preslat
        character*1 strz_pres,strz_lat
        integer ntraceurs_zone_opt

        ! vérifier que on a bien l'eau comme traceurs
        if (iso_eau.eq.0) then
            write(*,*) 'traceurs_init 18: isotrac ne marche que si ', &
     &            'on met l''eau comme isotope'
            stop
        endif

        ! initialiser
        option_traceurs=0
        initialisation_isotrac=0

        ! allouer
        allocate (index_iso(ntiso))
        allocate (index_zone(ntiso))
        allocate (itZonIso_loc(ntraceurs_zone,niso))
        allocate (strtrac(ntraceurs_zone))
        allocate (bassin_map(klon))
        allocate (boite_map(klon,klev))

        if (initialisation_iso.eq.0) then
          call getin('initialisation_isotrac',initialisation_isotrac)
          write(*,*) 'initialisation_isotrac=',initialisation_isotrac
        endif !if (initialisation_iso.eq.0) then

        ! lire l'option de traçage
        call getin('option_traceurs',option_traceurs)
        write(*,*) 'option_traceurs=',option_traceurs

        ! cas général: pas de traceurs dans ORCHIDEE
        ntracisoOR=niso

        ! partie à éditer ! pour définir les différentes zones
        if (option_traceurs.eq.1) then
          ! on trace continents/ocean  

          ntraceurs_zone_opt=2
          izone_cont=1
          izone_oce=2          
          izone_poubelle=2 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=2 ! zone d'initialisation par défaut          
          option_revap=0
          option_tmin=0
          izone_revap=0
          option_cond=0

          strtrac(izone_cont)='con'
          strtrac(izone_oce)='oce'

        elseif (option_traceurs.eq.2) then
          ! on trace continent/ ocean/reevap des gouttes

          ntraceurs_zone_opt=3
          izone_cont=1
          izone_oce=2
          izone_poubelle=2 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=2 ! zone d'initialisation par défaut
          option_revap=1
          option_tmin=0
          izone_revap=3
          option_cond=0

          strtrac(izone_cont)='con'
          strtrac(izone_oce)='oce'
          strtrac(izone_revap)='rev'
          

        else if (option_traceurs.eq.3) then
            ! on trace des bassins océaniques + un résidu. On ne trace
            ! pas l'évap des gouttes à part
            ! le résidu est la dernère dimension
            
          ! lire les use_bassin
          call getin('use_bassin_atlantic',use_bassin_atlantic)     
          call getin('use_bassin_medit',use_bassin_medit)      
          call getin('use_bassin_indian',use_bassin_indian)     
          call getin('use_bassin_austral',use_bassin_austral)     
          call getin('use_bassin_pacific',use_bassin_pacific)     
          call getin('use_bassin_merarabie',use_bassin_merarabie)     
          call getin('use_bassin_golfebengale',use_bassin_golfebengale)     
          call getin('use_bassin_indiansud',use_bassin_indiansud)     
          call getin('use_bassin_tropics',use_bassin_tropics)     
          call getin('use_bassin_midlats',use_bassin_midlats)     
          call getin('use_bassin_hauteslats',use_bassin_hauteslats)

          write(*,*) 'use_bassin_atlantic=' ,use_bassin_atlantic  
          write(*,*) 'use_bassin_medit=' ,use_bassin_medit
          write(*,*) 'use_bassin_indian=' ,use_bassin_indian
          write(*,*) 'use_bassin_austral=' ,use_bassin_austral
          write(*,*) 'use_bassin_merarabie=' ,use_bassin_merarabie
          write(*,*) 'use_bassin_golfebengale=' ,use_bassin_golfebengale
          write(*,*) 'use_bassin_indiansud=' ,use_bassin_indiansud
          write(*,*) 'use_bassin_tropics=' ,use_bassin_tropics
          write(*,*) 'use_bassin_midlats=' ,use_bassin_midlats
          write(*,*) 'use_bassin_hauteslats=' ,use_bassin_hauteslats

        
          ntraceurs_zone_opt=2 &
     &                   +use_bassin_atlantic &
     &                   +use_bassin_medit &
     &                   +use_bassin_indian &
     &                   +use_bassin_austral &
     &                   +use_bassin_pacific &
     &                   +use_bassin_merarabie &
     &                   +use_bassin_golfebengale &
     &                   +use_bassin_indiansud &
     &                   +use_bassin_tropics &
     &                   +use_bassin_midlats &
     &                   +use_bassin_hauteslats

          izone_cont=ntraceurs_zone
          izone_oce=0 ! pas de sens car séparée en bassins          
          izone_poubelle=ntraceurs_zone-1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=ntraceurs_zone-1 ! zone d'initialisation par défaut
          option_revap=0 ! on ne trace pas les gouttes 
          option_tmin=0
          izone_revap=0 ! pas de sens car on taggue pas les gouttes séparemment  
          option_cond=0

          ! si on a use_bassin_indian, on n'a pas le découpage détaillé
          ! de l'indian:
#ifdef ISOVERIF
          if (use_bassin_indian.eq.1) then
!              call iso_verif_egalite(float(use_bassin_merarabie), &
!     &            0.0,'iso_traceurs_init 73: revoir def des bassins')
               if ((use_bassin_merarabie.ne.0).or. &
      &            (use_bassin_indiansud.ne.0).or. &
      &            (use_bassin_golfebengale.ne.0)) then
                write(*,*) 'traceurs_init 73'
                stop
               endif 
!              call iso_verif_egalite(float(use_bassin_golfebengale), &
!     &            0.0,'iso_traceurs_init 73: revoir def des bassins')
!              call iso_verif_egalite(float(use_bassin_indiansud), &
!     &            0.0,'iso_traceurs_init 73: revoir def des bassins')
          endif
#endif    
          
          bassin_atlantic= max(use_bassin_atlantic,1)
          bassin_medit=max(use_bassin_atlantic &
     &           +use_bassin_medit,1)
          bassin_indian=max(use_bassin_atlantic &
     &           +use_bassin_medit &
     &           +use_bassin_indian,1)
          bassin_austral=max(use_bassin_atlantic &
     &           +use_bassin_medit &
     &           +use_bassin_indian &
     &           +use_bassin_austral,1)
          bassin_pacific=max(use_bassin_atlantic &
     &           +use_bassin_medit &
     &           +use_bassin_indian &
     &           +use_bassin_austral &
     &           +use_bassin_pacific,1)
          bassin_merarabie=max(use_bassin_atlantic &
     &           +use_bassin_medit &
     &           +use_bassin_indian &
     &           +use_bassin_austral &
     &           +use_bassin_pacific &
     &           +use_bassin_merarabie,1)
          bassin_golfebengale=max(use_bassin_atlantic& 
     &           +use_bassin_medit &
     &           +use_bassin_indian & 
     &           +use_bassin_austral &
     &           +use_bassin_pacific &
     &           +use_bassin_merarabie &
     &           +use_bassin_golfebengale,1)
          bassin_indiansud=max(use_bassin_atlantic &
     &           +use_bassin_medit &
     &           +use_bassin_indian &
     &           +use_bassin_austral &
     &           +use_bassin_pacific &
     &           +use_bassin_merarabie &
     &           +use_bassin_golfebengale &
     &           +use_bassin_indiansud,1) 
          bassin_tropics=max(use_bassin_atlantic &
     &                       +use_bassin_medit &
     &                       +use_bassin_indian &
     &                       +use_bassin_austral &
     &                       +use_bassin_pacific &
     &                       +use_bassin_merarabie &
     &                       +use_bassin_golfebengale &
     &                       +use_bassin_indiansud, &
     &                       +use_bassin_tropics,1) 
          bassin_midlats=max(use_bassin_atlantic &
     &                       +use_bassin_medit &
     &                       +use_bassin_indian &
     &                       +use_bassin_austral &
     &                       +use_bassin_pacific &
     &                       +use_bassin_merarabie &
     &                       +use_bassin_golfebengale &
     &                       +use_bassin_indiansud &
     &                       +use_bassin_tropics &
     &                       +use_bassin_midlats,1) 
          bassin_hauteslats=max(use_bassin_atlantic & 
     &                       +use_bassin_medit &
     &                       +use_bassin_indian &
     &                       +use_bassin_austral &
     &                       +use_bassin_pacific &
     &                       +use_bassin_merarabie &
     &                       +use_bassin_golfebengale &
     &                       +use_bassin_indiansud &
     &                       +use_bassin_tropics &
     &                       +use_bassin_midlats &
     &                       +use_bassin_hauteslats,1) 

          write(*,*) 'bassin_atlantic=' ,bassin_atlantic  
          write(*,*) 'bassin_medit=' ,bassin_medit
          write(*,*) 'bassin_indian=' ,bassin_indian
          write(*,*) 'bassin_austral=' ,bassin_austral
          write(*,*) 'bassin_merarabie=' ,bassin_merarabie
          write(*,*) 'bassin_golfebengale=' ,bassin_golfebengale
          write(*,*) 'bassin_indiansud=' ,bassin_indiansud
          write(*,*) 'bassin_tropics=' ,bassin_tropics
          write(*,*) 'bassin_midlats=' ,bassin_midlats
          write(*,*) 'bassin_hauteslats=' ,bassin_hauteslats

          if (use_bassin_atlantic.eq.1) then
            strtrac(bassin_atlantic)='atl'
          endif
          if (use_bassin_medit.eq.1) then
            strtrac(bassin_medit)='med'
          endif
          if (use_bassin_indian.eq.1) then
            strtrac(bassin_indian)='ind'
          endif
          if (use_bassin_austral.eq.1) then
            strtrac(bassin_austral)='aus'
          endif
          if (use_bassin_pacific.eq.1) then
            strtrac(bassin_pacific)='pac'
          endif
          if (use_bassin_merarabie.eq.1) then
            strtrac(bassin_merarabie)='ara'
          endif
          if (use_bassin_golfebengale.eq.1) then
            strtrac(bassin_golfebengale)='ben'
          endif
          if (use_bassin_indiansud.eq.1) then
            strtrac(bassin_indiansud)='ins'
          endif
          if (use_bassin_tropics.eq.1) then
            strtrac(bassin_tropics)='tro'
          endif
          if (use_bassin_midlats.eq.1) then
            strtrac(bassin_midlats)='mid'
          endif
          if (use_bassin_hauteslats.eq.1) then
            strtrac(bassin_hauteslats)='hau'
          endif
          strtrac(ntraceurs_zone-1)='res'
          strtrac(ntraceurs_zone)='con'

        else if (option_traceurs.eq.4) then
          ! on trace les température minimales vécues
          ! comme dans article sur LdG sauf pas de revap
            
          zone_temp1=293.0 ! en K
!          zone_tempf=223.0 ! en K
          zone_tempf=243.0 ! en K
 ! courbure de la relation entre l'indice et la température: 0 pour linéaire, <0 pour plus de détal en bas

        ! zone 1: >= zone_temp1
        ! zone 2 à 4: intermédiaire, 
        ! zone 5: <zone_tempf
        
          ntraceurs_zone_opt=nzone_temp+1

          zone_tempa=-4.0 ! en K
          izone_cont=ntraceurs_zone
          izone_oce=ntraceurs_zone  
          izone_poubelle=ntraceurs_zone
          izone_init=ntraceurs_zone ! zone d'initialisation par défaut
          option_revap=0 
          option_tmin=0  
          izone_revap=0
          option_cond=0
          do izone=1,nzone_temp
            write(strz,'(i2.2)') izone
            strtrac(izone)='t'//strz
            write(*,*) 'izone,strz,strtrac=',izone,strz,strtrac(izone)
          enddo
          strtrac(izone_poubelle)='pou'

          ! initialisation des zones de tempéarture
          do izone=1,nzone_temp-1
            zone_temp(izone)=zone_temp1+float(izone-1) &
     &                      *(zone_tempa*float(izone-nzone_temp+1) &
     &                      +(zone_tempf-zone_temp1)/float(nzone_temp-2))
          enddo
          write(*,*) 'iso_trac_init 183: zone_temp=',zone_temp          

        elseif (option_traceurs.eq.5) then
          ! on trace AEJ/flux de mousson/Harmattan
!          write(*,*) 'iso_traceurs_init 129'

          ntraceurs_zone_opt=4
          izone_cont=1
          izone_oce=1
          izone_poubelle=1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_aej=2
          izone_mousson=3
          izone_harmattan=4 
          option_cond=0

          strtrac(izone_poubelle)='res'
          strtrac(izone_aej)='aej'
          strtrac(izone_mousson)='mou'
          strtrac(izone_harmattan)='sah'

        elseif (option_traceurs.eq.6) then
          ! on trace les ddfts

          ntraceurs_zone_opt=2
          izone_cont=1
          izone_oce=1
          izone_poubelle=1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_ddft=2
          option_cond=0

          strtrac(izone_poubelle)='res'
          strtrac(izone_ddft)='dft'

        elseif (option_traceurs.eq.9) then
          ! on trace le condensat

          ntraceurs_zone_opt=3
          izone_cont=1
          izone_oce=1
          izone_poubelle=1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=1
          option_tmin=0
          izone_revap=2
          izone_cond=3
          option_cond=1

          ! 1 par défaut pour colorier à la fois condensat LS et
          ! condensat convectif. Mais on peut mettre 2 si on ne veut que
          ! collorier que le condensat convectif.
          call getin('option_cond',option_cond)
          write(*,*) 'option_cond=',option_cond

          strtrac(izone_poubelle)='res'
          strtrac(izone_cond)='con'
          strtrac(izone_revap)='rev'

        elseif (option_traceurs.eq.10) then
          ! on trace l'évap venant de ocean/continent no frac/continent frac
          !  utilse seulement si couplé avec ORCHIDEE
#ifdef CPP_VEGET
#else
          write(*,*) 'iso_traceurs_init 219: option_traceurs=10 ', &
     &                      'inutile si on ne couple pas avec ORCHIDEE'
          stop
#endif          

          ntraceurs_zone_opt=3
          izone_cont=1 ! sous-entendu non fractionnant
          izone_oce=2
          izone_poubelle=2 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=2 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_contfrac=3
          izone_contcanop=3
          izone_irrig=0
          option_cond=0

          strtrac(izone_oce)='oce'
          strtrac(izone_cont)='con'  
          strtrac(izone_contfrac)='enu'  ! evap sol nu

        elseif (option_traceurs.eq.11) then
          ! on trace reevap des gouttes et le reste

          ntraceurs_zone_opt=2
          izone_cont=1
          izone_oce=1
          izone_poubelle=1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=1
          option_tmin=0
          izone_revap=2
          izone_irrig=0
          option_cond=0

          strtrac(izone_poubelle)='res'
          strtrac(izone_revap)='rev'

        elseif (option_traceurs.eq.12) then
          ! on trace evap du sol nu, evap de la canopée, reste de l'evap cont et
          ! evap oce
#ifdef CPP_VEGET
#else
          write(*,*) 'iso_traceurs_init 257: option_traceurs=10 ', &
     &                      'inutile si on ne couple pas avec ORCHIDEE'
          stop
#endif           

          ntraceurs_zone_opt=2
          izone_cont=1
          izone_oce=2
          izone_poubelle=2 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=2 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_contfrac=3
          izone_contcanop=4
          izone_irrig=0   
          option_cond=0

          strtrac(izone_oce)='oce'
          strtrac(izone_cont)='con'
          strtrac(izone_contfrac)='enu'  ! evap sol nu
          strtrac(izone_contcanop)='eca'  ! evap canop

       else if (option_traceurs.eq.13) then
          ! on trace les température minimales vécues + la revap
          ! comme dans article sur LdG
            
        zone_temp1=293.0         ! en K        
!        parameter (zone_tempf=223.0) ! en K
        zone_tempf=243.0 ! en K
        zone_tempa=-4.0 ! courbure de la relation entre l'indice et la température: 0 pour linéaire, <0 pour plus de détal en bas

        ! zone 1: >= zone_temp1
        ! zone 2 à 4: intermédiaire, 
        ! zone 5: <zone_tempf
        
          ntraceurs_zone_opt=nzone_temp+1
          
          izone_cont=1
          izone_oce=1  
          izone_poubelle=1
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=1   
          option_tmin=0
          izone_revap=ntraceurs_zone
          izone_irrig=0
          option_cond=0
          do izone=1,nzone_temp
            write(strz,'(i2.2)') izone
            strtrac(izone)='t'//strz
            write(*,*) 'izone,strz,strtrac=',izone,strz,strtrac(izone)
          enddo
          strtrac(izone_revap)='rev'

          ! initialisation des zones de tempéarture
          do izone=1,nzone_temp-1
            zone_temp(izone)=zone_temp1+float(izone-1) &
     &                      *(zone_tempa*float(izone-nzone_temp+1) &
     &                      +(zone_tempf-zone_temp1)/float(nzone_temp-2))
          enddo
          write(*,*) 'zone_temp=',zone_temp

       else if (option_traceurs.eq.14) then
          ! on trace les pres et lat de dernière saturation définies
          ! comme rh>90%
            
        zone_pres1=600.0*100.0 ! en Pa       
        zone_presf=300.0*100.0 ! en Pa
        zone_presa=0.0 ! courbure de la relation entre l'indice et la température: 0 pour linéaire, <0 pour plus de détal en bas

        lattag_min=10.0 ! en degrès
        dlattag=15.0

        ! zone 1: >= zone_pres1
        ! zone 2 à 4: intermédiaire, 
        ! zone 5: <zone_presf
        
         ntraceurs_zone_opt=nzone_pres*nzone_lat+1          
          izone_cont=ntraceurs_zone
          izone_oce=ntraceurs_zone
          izone_poubelle=ntraceurs_zone
          izone_init=ntraceurs_zone ! zone d'initialisation par défaut
          option_revap=0  
          option_tmin=0 
          izone_revap=0
          izone_irrig=0
          option_cond=0
          do izone_pres=1,nzone_pres
           do izone_lat=1,nzone_lat
            write(strz_pres,'(i1.1)') izone_pres
            write(strz_lat,'(i1.1)') izone_lat
            strz_preslat=strz_pres//strz_lat
            izone=izone_lat+(izone_pres-1)*nzone_lat
            strtrac(izone)='t'//strz_preslat
            write(*,*) 'izone_pres,izone_lat,strtrac=', &
     &                        izone_pres,izone_lat,izone,strtrac(izone)
           enddo !do izone_lat=1,nzone_lat
          enddo !do izone_pres=1,nzone_pres
          strtrac(ntraceurs_zone)='sfc'

          ! initialisation des zones de tempéarture
          do izone=1,nzone_pres-1
            zone_pres(izone)=zone_pres1+float(izone-1) &
     &                      *(zone_presa*float(izone-nzone_pres+1) &
     &                      +(zone_presf-zone_pres1)/float(nzone_pres-2))
          enddo !do izone=1,nzone_pres-1
          write(*,*) 'traceurs_init 332: zone_pres=',zone_pres
!          stop
!
       elseif (option_traceurs.eq.15) then
          ! on trace l'irrigation dans ORCHIDEE
#ifdef CPP_VEGET
#else
          write(*,*) 'iso_traceurs_init 257: option_traceurs=15 ', &
     &                      'inutile si on ne couple pas avec ORCHIDEE'
          stop
#endif

          ntraceurs_zone_opt=1
          izone_cont=1
          izone_oce=1
          izone_poubelle=1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_contfrac=0
          izone_contcanop=0 
          izone_irrig=2 
          option_cond=0
          
          strtrac(izone_poubelle)='res'
          strtrac(izone_irrig)='irrig'

          ! dans ce cas particulier, il y a des traceurs dans ORCHIDEE
          ntracisoOR=ntiso

        else if ((option_traceurs.eq.17).or. &
     &           (option_traceurs.eq.18)) then
          ! on trace les température minimales vécues
          ! comme dans article sur LdG sauf pas de revap
            
        zone_temp1=12.0e-3 ! en kg/kg        
        zone_tempf=0.2e-3 ! en kg/kg
        zone_tempa=1.2e-3 ! courbure de la relation entre l'indice et la température: 0 pour linéaire, <0 pour plus de détail en bas

!	parameter (zone_temp1=14.0e-3) ! en kg/kg        
!   	parameter (zone_tempf=0.2e-3) ! en kg/kg
!	parameter (zone_tempa=0.5e-3)       

!        parameter (zone_temp1=10.0e-3) ! en kg/kg
!   	parameter (zone_tempf=0.5e-3) ! en kg/kg
!	parameter (zone_tempa=0.5e-3)

        ! zone 1: >= zone_temp1
        ! zone 2 à 4: intermédiaire, 
        ! zone 5: <zone_tempf
        
        ntraceurs_zone_opt=nzone_temp+3
        
          izone_cont=nzone_temp+1
          izone_oce=nzone_temp+1 
          izone_poubelle=nzone_temp+1
          izone_init=nzone_temp+1 ! zone d'initialisation par défaut
          option_revap=1  
          option_tmin=1 
          option_cond=1

          izone_revap=nzone_temp+3
          izone_cond=nzone_temp+2
          do izone=1,nzone_temp
            write(strz,'(i2.2)') izone
            strtrac(izone)='t'//strz
            write(*,*) 'izone,strz,strtrac=',izone,strz,strtrac(izone)
          enddo !do izone=1,nzone_temp
          strtrac(izone_poubelle)='sfc'
          strtrac(izone_cond)='con'
          strtrac(izone_revap)='rev'

          ! initialisation des zones de tempéarture
          do izone=1,nzone_temp-1
            zone_temp(izone)=zone_temp1+float(izone-1) &
     &                      *(zone_tempa*float(izone-nzone_temp+1) &
     &             +(zone_tempf-zone_temp1)/float(nzone_temp-2))
          enddo
         write(*,*) 'zone_temp1,zone_tempf,zone_tempa=', &
     &              zone_temp1,zone_tempf,zone_tempa
          write(*,*) 'zone_temp=',zone_temp
!          stop          

        else if (option_traceurs.eq.19) then

        zone_temp1=12.0e-3 ! en kg/kg        
        zone_tempf=0.2e-3 ! en kg/kg
        zone_tempa=1.2e-3 ! courbure de la relation entre l'indice et la température: 0 pour linéaire, <0 pour plus de détail en bas

!	parameter (zone_temp1=14.0e-3) ! en kg/kg        
!   	parameter (zone_tempf=0.2e-3) ! en kg/kg
!	parameter (zone_tempa=0.5e-3)       

!        parameter (zone_temp1=10.0e-3) ! en kg/kg
!   	parameter (zone_tempf=0.5e-3) ! en kg/kg
!	parameter (zone_tempa=0.5e-3)

        ! zone 1: >= zone_temp1
        ! zone 2 à 4: intermédiaire, 
        ! zone 5: <zone_tempf
        
        ntraceurs_zone_opt=nzone_temp+4
        
          izone_cont=nzone_temp+1
          izone_oce=nzone_temp+1 
          izone_poubelle=nzone_temp+1
          if (option_seuil_tag_tmin.eq.1) then
            izone_init=nzone_temp+1 ! zone d'initialisation par défaut
          else
            izone_init=nzone_temp
          endif
          option_revap=1   
          izone_revap=nzone_temp+3
          izone_cond=nzone_temp+2
          izone_ddft=nzone_temp+4
          option_tmin=1          
          option_cond=1
          do izone=1,nzone_temp
            write(strz,'(i2.2)') izone
            strtrac(izone)='t'//strz
            write(*,*) 'izone,strz,strtrac=',izone,strz,strtrac(izone)
          enddo !do izone=1,nzone_temp
          strtrac(izone_poubelle)='sfc'
          strtrac(izone_cond)='con'
          strtrac(izone_revap)='rev'
          strtrac(izone_ddft)='dft'

        elseif (option_traceurs.eq.20) then
          ! on vapeur tropical/extractropicale/recyclage extractropical
          ! pour comprendre controles humidité et isotopes subtropicaux.        
          
          lim_tag20=35.0
          call getin('lim_tag20',lim_tag20)
          write(*,*) 'lim_tag20=',lim_tag20

          ntraceurs_zone_opt=3
          izone_cont=1
          izone_oce=1
          izone_poubelle=2 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=2 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_trop=2
          izone_extra=3

          strtrac(izone_trop)='tro' ! vapeur tropicale
          strtrac(izone_extra)='ext' ! vapeur extractropicale evaporée 
                ! dans les tropiques
          strtrac(izone_cont)='rec' ! recyclage

        elseif (option_traceurs.eq.21) then
          ! on trace 2 boites 3D: UT tropicale et extratropiques 
          ! fonctionnement similaire à option 5 pour taggage des zones
          ! AMMA
!          write(*,*) 'iso_traceurs_init 129'

          ntraceurs_zone_opt=3
          izone_cont=1
          izone_oce=1
          izone_poubelle=1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_trop=2
          izone_extra=3
          option_cond=0

          strtrac(izone_poubelle)='res'
          strtrac(izone_trop)='tro'
          strtrac(izone_extra)='ext'

        elseif (option_traceurs.eq.22) then
          ! on trace la vapeur qui a été processée dans zones de
          ! convections à 3 niveaux: BT, MT et UT

          lim_precip_tag22=20.0
          call getin('lim_precip_tag22',lim_precip_tag22)
          write(*,*) 'lim_precip_tag22=',lim_precip_tag22

          ntraceurs_zone_opt=3
          izone_cont=1
          izone_oce=1
          izone_poubelle=1 ! zone où on met les flux non physiques, de
                ! réajustement
          izone_init=1 ! zone d'initialisation par défaut
          option_revap=0
          option_tmin=0
          izone_revap=0
          izone_conv_BT=2
          izone_conv_UT=3
          option_cond=0

          strtrac(izone_poubelle)='res'
          strtrac(izone_conv_BT)='cbt'
          strtrac(izone_conv_UT)='cut'

        else
            write(*,*) 'traceurs_init 36: option pas encore prévue'
            stop
        endif

        
          if (ntraceurs_zone_opt.ne.ntraceurs_zone) then
                write(*,*) 'ntraceurs_zone_opt,ntraceurs_zone=', &
                        & ntraceurs_zone_opt,ntraceurs_zone
                call abort_physic ('isotrac_mod','ntraceurs_zone incoherent',1)
          endif

       
        ! seuil sur le taux de condensation
        if (option_tmin.eq.1) then
          seuil_tag_tmin=0.01
          call getin('seuil_tag_tmin',seuil_tag_tmin)
          write(*,*) 'seuil_tag_tmin=',seuil_tag_tmin

          seuil_tag_tmin_ls=seuil_tag_tmin
          call getin('seuil_tag_tmin_ls',seuil_tag_tmin_ls)
          write(*,*) 'seuil_tag_tmin_ls=',seuil_tag_tmin_ls

          option_seuil_tag_tmin=1
          call getin('option_seuil_tag_tmin',option_seuil_tag_tmin)
          write(*,*) 'option_seuil_tag_tmin=',option_seuil_tag_tmin
        endif


        do ixt=1,niso
           index_zone(ixt)=0
           index_iso(ixt)=ixt
        enddo
        itrac=niso        
        do izone=1,ntraceurs_zone
          do ixt=1,niso
            itrac=itrac+1
            index_zone(itrac)=izone
            index_iso(itrac)=ixt
            itZonIso_loc(izone,ixt)=itrac
            if (itZonIso(izone,ixt).ne.itZonIso_loc(izone,ixt)) then
                write(*,*) 'isotrac 989: izone,ixt,itrac=',izone,ixt,itrac
                CALL abort_physic ('isotrac','isotrac 989',1)
            endif
          enddo
        enddo
#ifdef ISOVERIF
!        call iso_verif_egalite(float(itrac),float(ntiso), &
!     &           'traceurs_init 50')
        if (itrac.ne.ntiso) then
          write(*,*) 'traceurs_init 50'
          stop
        endif
     
        write(*,*) 'traceurs_init 65: bilan de l''init:'
        write(*,*) 'index_zone=',index_zone(1:ntiso)
        write(*,*) 'index_iso=',index_iso(1:ntiso)
        write(*,*) 'itZonIso=',itZonIso(1:ntraceurs_zone,1:niso)
        do izone=1,ntraceurs_zone
          write(*,*) 'strtrac(',izone,')=',strtrac(izone)
        enddo !do izone=1,ntraceurs_zone
        write(*,*) 'ntracisoOR=',ntracisoOR
#endif  

        end subroutine iso_traceurs_init


END MODULE isotrac_mod
#endif
#endif
