#!/bin/bash

set -vx

#####################################################################
# Choix eventuel de la version : branche ou trunk et svn particuliere
#####################################################################

branche=IPSLCM6.0.15
branche=trunk
rev="-r 4084"
rev=""
latest=""
#latest=20210512 # Pour imposer de tester la convergence avec une version passee

TMP_D=/tmp/lmdz ; mkdir -p $TMP_D

if [ $branche != trunk ] ; then
    echo cas non prevu
#     exit
fi

check=0
check=1 # On verifie un certain nombre de choses.
force=0

optionnel=" -cpp ORCHIDEE_NOZ0H "

local=`pwd`
while (($# > 0)) ; do
  case $1 in
      "-h") cat <<fin
USAGE creation_modipsl.sh
Crée les archives du modele pour installation par install.sh
-force : pour créeer une seconde version le meme jour
fin
        exit ;;
      "-force") force=1 ; shift ;;
      "-r") rev="-r $2" ; shift ; shift ;;
      "-b") branche="$2" ; shift ; shift ;;
      "-latest") latest=$2 ; shift ; shift ;;
      *) echo option non prevue ; ./creation_modipsl.sh -h ; exit
  esac
done

# machine_cible=erskine.lmd.jussieu.fr
#machine_cible=carey
machine_cible=lmdz-cq
if [ "`hostname`" != "$machine_cible" ] ; then echo Lancer sur $machine_cible ; exit ; fi
set -ex

###########################################################################
# localisation svn
###########################################################################
# cvs -d :pserver:lmdzbrowse@cvs.lmd.jussieu.fr:/home/cvsroot checkout LMDZ5 
LMDZv=LMDZ6
if [ $LMDZv = LMDZ6 ] ; then
   LMDZ=LMDZ
else
   LMDZ=LMDZ5
fi

if [ $branche == trunk ] ; then
   branchepath=trunk
else
   branchepath=branches/$branche
fi
svnmodel=https://svn.lmd.jussieu.fr/LMDZ/$LMDZv/$branchepath


##########################################################################
# Recuperation des infos svn pour le choix du nom du modele
##########################################################################
echo svn info $rev $svnmodel :
svn info $rev $svnmodel
datesvn=`svn info $rev $svnmodel | grep "Last Changed Date" | awk ' { print $4 } ' | sed -e 's/-//g'`
echo DATESVN $datesvn

if [  "$datesvn" = "" ] ; then
#    DATESVN vide
    datesvn=`svn info https://svn.lmd.jussieu.fr/LMDZ/$LMDZv/$branchepath $rev | grep 'Date de la dern' | awk ' { print $6 } '  | sed -e 's/-//g'`
fi
echo datesvn $datesvn
version=$datesvn.$branche
echo version $version

##########################################################################
# Sauvegarde eventuelle de la version precedente si deux versions
# sont creees le meme jour
##########################################################################
if [ -f modipsl.$version.tar.gz ] ; then
   if [ $force = 1 ] ; then
      if [ -d $TMP_D/LMDZ$version ] ; then mv -f $TMP_D/LMDZ$version $TMP_D/LMDZ${version}_$$ ; fi
      cd /home/users/lmdz/WWW/RESUBENCH/$branche/gfortran
      if [ -f ${datesvn} ] ; then mv -f ${datesvn} ${datesvn}_$$ ; fi
      ln -sf ${datesvn}_$$ latest
      cd $local
      if [ -f modipsl.$version.tar.gz ] ; then mv modipsl.$version.tar.gz modipsl.${version}_$$.tar.gz ; fi
      echo ${datesvn} ${datesvn}_$$
    else
      echo Le fichier modipsl.$version.tar.gz existe deja
      echo Preparer un changement automatique de nom pour automatiser
      echo la creation de plusieurs versions dans la journee
      exit
    fi
fi

if [ "$latest" != "" ] ; then
   cd /home/users/lmdz/WWW/RESUBENCH/$branche/gfortran
   \rm -f latest
   ln -s $latest latest
fi

#####################################################################
# Les fichiers modipsl.vN.tar.gz contiennent des versions successives
# de IOIPSL
# Les versions modipsl.20080305.v5.tar.gz contiennent des versions
# successives avec de modipsl les dates correspondant a des versions
# successives de LMDZ4 puis LMDZ5
#####################################################################
vorig=v8  # updated version of IOIPSL 04/04/2012, including 'rebuild' script
vorig=v9  # updated version of IOIPSL 07/08/2013, modfication de AA_male.ldef pour g95
vorig=v10 # 'rebuild' is reintroduced in v9 . Was lost even in v8 ... (FH)
vorig=v11 # update ORCHIDEE version to r2247, changes needed in install.sh for ORCHIDEE compilation
vorig=v12 # modification AA_make.gdef pour ada. on garde g95 pour install alors qu'il a disparu dans modipsl
vorig=v13 # mise a jour ORCHIDEE (r3013) pour problème d'interface après le rajout de sinang=rmu0 dans surf_land_orchidee_mod.F90
vorig=v14 # dans ioipsl/histcom.f9, nb_var_max : 600 -> 1OOO, nb_zax_max : 5 -> 100, flio_max_dims : 15 -> 50 pour rebuild cosp
vorig=v15 # modifications pour tenir compte de jean-zay nouvelle machine Idris
vorig=v16 # 2022/02/17 on bascule sur orchidee CMIP6

modipsltar=modipsl.$vorig.tar

##### tmpdir=/tmp/tmpmodipsl$$
tmpdir=$local/tmpmodipsl$$
mkdir -p $tmpdir
cd $tmpdir
if [ -f /u/lmdz/WWW/Distrib/$modipsltar.gz ] ; then
   cp /u/lmdz/WWW/Distrib/$modipsltar.gz .
else
   wget http://www.lmd.jussieu.fr/~lmdz/Distrib/$modipsltar.gz
fi

tar xvf $modipsltar.gz
#gzip -9 $modipsltar

cd modipsl/modeles



###########################################################################
# On effectue le svn checkout sur une machine avec un ancien svn
# pour eviter que les utilisateurs se retrouvent avec un svn plus ancien
# que celui sur lequel la version a été créée.
echo Premier svn checkout $rev $svnmodel $LMDZ
#ssh butler ' ( cd '`pwd`' ; svn checkout '$rev' '$svnmodel' '$LMDZ' ) '
svn checkout $rev $svnmodel $LMDZ  

###########################################################################


cd ../..
echo $version
tar cvf modipsl.$version.tar modipsl

gzip modipsl.$version.tar
mv modipsl.$version.tar.gz ~/WWW/Distrib

cd  ~/WWW/Distrib
ln -sf modipsl.$version.tar.gz modipsl.$branche.tar.gz
cd ~/WWW/pub/src

# Ajout pour la nouvelle arborescence
ln -sf ../../Distrib/modipsl.$version.tar.gz .
ln -sf modipsl.$version.tar.gz modipsl.$branche.tar.gz
cd  ~/WWW/Distrib


####################################################################
# La partie ci-dessous concerne le check des versions.
# On devrait sans doute appeler rechech.sh
####################################################################

if [ $check = 1 ] ; then
   ./check_version.sh $version >| WORK/check.out.$version 2>&1
   cat tmp.resu >> Correspondance
   cat tmp.resu >> LISMOI.$branche
   \cp -f LISMOI.trunk ../pub/src/Readme
fi
