
! $Id: $

MODULE infotrac_phy

! Infotrac for physics; for now contains the same information as infotrac for
! the dynamics (could be further cleaned) and is initialized using values
! provided by the dynamics

  USE readTracFiles_mod, ONLY: trac_type, maxlen, delPhase

! nqtot : total number of tracers and higher order of moment, water vapor and liquid included
  INTEGER, SAVE :: nqtot
!$OMP THREADPRIVATE(nqtot)

!CR: on ajoute le nombre de traceurs de l eau
  INTEGER, SAVE :: nqo
!$OMP THREADPRIVATE(nqo)

! nbtr : number of tracers not including higher order of moment or water vapor or liquid
!        number of tracers used in the physics
  INTEGER, SAVE :: nbtr
!$OMP THREADPRIVATE(nbtr)

  INTEGER, SAVE :: nqtottr
!$OMP THREADPRIVATE(nqtottr)

! ThL : number of CO2 tracers   ModThL
  INTEGER, SAVE :: nqCO2
!$OMP THREADPRIVATE(nqCO2)

#ifdef CPP_StratAer
  !=== SPECIFIC TO STRATOSPHERIC AEROSOLS (CK/OB)
  INTEGER, SAVE ::  nbtr_bin, nbtr_sulgas         !--- number of aerosols bins and sulfur gases for StratAer model
!$OMP THREADPRIVATE(nbtr_bin, nbtr_sulgas)
  INTEGER, SAVE ::  id_OCS_strat, id_SO2_strat, id_H2SO4_strat, id_BIN01_strat, id_TEST_strat
!$OMP THREADPRIVATE(id_OCS_strat, id_SO2_strat, id_H2SO4_strat, id_BIN01_strat, id_TEST_strat)
#endif

! Tracers parameters
  TYPE(trac_type), TARGET, ALLOCATABLE, SAVE :: tracers(:)
!$OMP THREADPRIVATE(tracers)

! conv_flg(it)=0 : convection desactivated for tracer number it 
  INTEGER, ALLOCATABLE, DIMENSION(:), SAVE  :: conv_flg
!$OMP THREADPRIVATE(conv_flg)

! pbl_flg(it)=0  : boundary layer diffusion desactivaded for tracer number it 
  INTEGER, ALLOCATABLE, DIMENSION(:), SAVE  :: pbl_flg
!$OMP THREADPRIVATE(pbl_flg)

  CHARACTER(len=4),SAVE :: type_trac
!$OMP THREADPRIVATE(type_trac)
  CHARACTER(len=8),DIMENSION(:),ALLOCATABLE, SAVE :: solsym
!$OMP THREADPRIVATE(solsym)
   
    ! CRisi: cas particulier des isotopes
    LOGICAL,SAVE :: ok_isotopes,ok_iso_verif,ok_isotrac,ok_init_iso
!$OMP THREADPRIVATE(ok_isotopes,ok_iso_verif,ok_isotrac,ok_init_iso)
    INTEGER :: niso_possibles   
    PARAMETER ( niso_possibles=5)
    real, DIMENSION (niso_possibles),SAVE :: tnat,alpha_ideal
!$OMP THREADPRIVATE(tnat,alpha_ideal)
    LOGICAL, DIMENSION(niso_possibles),SAVE ::  use_iso
!$OMP THREADPRIVATE(use_iso)
    INTEGER, ALLOCATABLE, DIMENSION(:,:), SAVE ::  iqiso ! donne indice iq en fn de (ixt,phase) 
!$OMP THREADPRIVATE(iqiso)
    INTEGER, ALLOCATABLE, DIMENSION(:), SAVE ::  iso_indnum ! donne numéro iso entre 1 et niso effectif en fn de nqtot
!$OMP THREADPRIVATE(iso_indnum)
    INTEGER, DIMENSION(niso_possibles), SAVE :: indnum_fn_num ! donne indice entre entre 1 et niso en fonction du numéro d isotope entre 1 et niso_possibles
!$OMP THREADPRIVATE(indnum_fn_num)
    INTEGER, ALLOCATABLE, DIMENSION(:,:), SAVE ::  index_trac ! numéro ixt en fn izone, indnum entre 1 et niso
!$OMP THREADPRIVATE(index_trac)
    INTEGER,SAVE :: niso,ntraceurs_zone,ntraciso
!$OMP THREADPRIVATE(niso,ntraceurs_zone,ntraciso)

CONTAINS

  SUBROUTINE init_infotrac_phy(nqtot_,nqo_,nbtr_,nqtottr_,nqCO2_,tracers_,type_trac_,&
                               conv_flg_,pbl_flg_,solsym_,&
                               ok_isotopes_,ok_iso_verif_,ok_isotrac_,&
                               ok_init_iso_,niso_possibles_,tnat_,&
                               alpha_ideal_,use_iso_,iqiso_,iso_indnum_,&
                               indnum_fn_num_,index_trac_,&
                               niso_,ntraceurs_zone_,ntraciso_)

    ! transfer information on tracers from dynamics to physics
    USE print_control_mod, ONLY: prt_level, lunout
    IMPLICIT NONE

    INTEGER,INTENT(IN) :: nqtot_
    INTEGER,INTENT(IN) :: nqo_
    INTEGER,INTENT(IN) :: nbtr_
    INTEGER,INTENT(IN) :: nqtottr_
    INTEGER,INTENT(IN) :: nqCO2_
    TYPE(trac_type), INTENT(IN) :: tracers_(nqtot_) ! tracers descriptors
    CHARACTER(len=*),INTENT(IN) :: type_trac_
    INTEGER,INTENT(IN) :: conv_flg_(nbtr_)
    INTEGER,INTENT(IN) :: pbl_flg_(nbtr_)
    CHARACTER(len=*),INTENT(IN) :: solsym_(nbtr_)
    ! Isotopes:
    LOGICAL,INTENT(IN) :: ok_isotopes_
    LOGICAL,INTENT(IN) :: ok_iso_verif_
    LOGICAL,INTENT(IN) :: ok_isotrac_
    LOGICAL,INTENT(IN) :: ok_init_iso_
    INTEGER,INTENT(IN) :: niso_possibles_
    REAL,INTENT(IN) :: tnat_(niso_possibles_)
    REAL,INTENT(IN) :: alpha_ideal_(niso_possibles_)
    LOGICAL,INTENT(IN) :: use_iso_(niso_possibles_)
    INTEGER,INTENT(IN) :: iqiso_(ntraciso_,nqo_)
    INTEGER,INTENT(IN) :: iso_indnum_(nqtot_)
    INTEGER,INTENT(IN) :: indnum_fn_num_(niso_possibles_)
    INTEGER,INTENT(IN) :: index_trac_(ntraceurs_zone_,niso_)
    INTEGER,INTENT(IN) :: niso_
    INTEGER,INTENT(IN) :: ntraceurs_zone_
    INTEGER,INTENT(IN) :: ntraciso_

    INTEGER :: iq, itr
    CHARACTER(LEN=maxlen), ALLOCATABLE :: tnames(:)
    CHARACTER(LEN=maxlen) :: modname="init_infotrac_phy"

    nqtot=nqtot_
    nqo=nqo_
    nbtr=nbtr_
    nqCO2=nqCO2_
    nqtottr=nqtottr_
    ALLOCATE(tracers(nqtot)); tracers(:) = tracers_(:)
#ifdef CPP_StratAer
    IF (type_trac == 'coag') THEN
      nbtr_bin    = COUNT([(tracers(iq)%name(1:3)=='BIN', iq=1, nqtot)])
      nbtr_sulgas = COUNT([(tracers(iq)%name(1:3)=='GAS', iq=1, nqtot)])
      tnames = PACK(tracers(:)%name, MASK=tracers(:)%isInPhysics)
      id_BIN01_strat = strIdx(tnames, 'BIN01'   )
      id_OCS_strat   = strIdx(tnames, 'GASOSC'  )
      id_SO2_strat   = strIdx(tnames, 'GASSO2'  )
      id_H2SO4_strat = strIdx(tnames, 'GASH2SO4')
      id_TEST_strat  = strIdx(tnames, 'GASTEST' )
      WRITE(lunout,*)'nbtr_bin       =', nbtr_bin
      WRITE(lunout,*)'nbtr_sulgas    =', nbtr_sulgas
      WRITE(lunout,*)'id_BIN01_strat =', id_BIN01_strat
      WRITE(lunout,*)'id_OCS_strat   =',   id_OCS_strat
      WRITE(lunout,*)'id_SO2_strat   =',   id_SO2_strat
      WRITE(lunout,*)'id_H2SO4_strat =', id_H2SO4_strat
      WRITE(lunout,*)'id_TEST_strat  =',  id_TEST_strat
    END IF
#endif
    type_trac = type_trac_
    ALLOCATE(conv_flg(nbtr))
    conv_flg(:)=conv_flg_(:)
    ALLOCATE(pbl_flg(nbtr))
    pbl_flg(:)=pbl_flg_(:)
    ALLOCATE(solsym(nbtr))
    solsym(:)=solsym_(:)
     
    IF(prt_level.ge.1) THEN
      write(lunout,*) TRIM(modname)//": nqtot,nqo,nbtr,nqCO2",nqtot,nqo,nbtr,nqCO2
    ENDIF
    
    ! Isotopes:
    
    ! First check that the "niso_possibles" has the correct value
    IF (niso_possibles.ne.niso_possibles_) THEN
      CALL abort_physic(modname,&
           "wrong value for parameter niso_possibles in infotrac_phy",1)
    ENDIF
    
    ok_isotopes=ok_isotopes_
    ok_iso_verif=ok_iso_verif_
    ok_isotrac=ok_isotrac_
    ok_init_iso=ok_init_iso_
    
    niso=niso_
    ntraceurs_zone=ntraceurs_zone_
    ntraciso=ntraciso_
    
    IF (ok_isotopes) THEN
      tnat(:)=tnat_(:)
      alpha_ideal(:)=alpha_ideal_(:)
      use_iso(:)=use_iso_(:)
    
      ALLOCATE(iqiso(ntraciso,nqo))
      iqiso(:,:)=iqiso_(:,:)
      ALLOCATE(iso_indnum(nqtot))
      iso_indnum(:)=iso_indnum_(:)
      
      indnum_fn_num(:)=indnum_fn_num_(:)
      
      ALLOCATE(index_trac(ntraceurs_zone,niso))
      index_trac(:,:)=index_trac_(:,:)
    ENDIF ! of IF(ok_isotopes)

    WRITE(*,*) 'infotrac_phy 207: nqtottr=',nqtottr
    WRITE(*,*) 'ntraciso,niso=',ntraciso,niso
#ifdef ISOVERIF
    ! DC: the "1" will be replaced by iH2O (H2O isotopes group index)
    WRITE(*,*) 'iso_iName=',PACK(tracers(:)%iso_iName, MASK=tracers(:)%iso_iGroup==1)
#endif

  END SUBROUTINE init_infotrac_phy

END MODULE infotrac_phy
